/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_6_R3.command.TicksPerSecondCommand;
import org.spigotmc.LogFilter;
import org.spigotmc.Metrics;
import org.spigotmc.RestartCommand;
import org.spigotmc.WatchdogThread;

public class SpigotConfig {
    private static final File CONFIG_FILE = new File("spigot.yml");
    private static final String HEADER = "This is the main configuration file for Spigot.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\nFor a reference for any variable inside this file, check out the Spigot wiki at\nhttp://www.spigotmc.org/wiki/spigot-configuration/\n\nIf you need help with the configuration or have any questions related to Spigot,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #spigot @ irc.esper.net ( http://webchat.esper.net/?channel=spigot )\nForums: http://www.spigotmc.org/forum/\n";
    static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static Metrics metrics;
    public static boolean preventProxies;
    public static int timeoutTime;
    public static boolean restartOnCrash;
    public static String restartScript;
    public static List<Listener> listeners;
    public static int nettyThreads;
    public static List<String> bungeeAddresses;
    public static boolean bungee;
    public static List<String> spamExclusions;
    public static boolean logCommands;
    public static boolean tabComplete;
    public static String whitelistMessage;
    public static String unknownCommandMessage;
    public static String serverFullMessage;
    public static String outdatedClientMessage;
    public static String outdatedServerMessage;
    public static List<Pattern> logFilters;

    public static void init() {
        config = YamlConfiguration.loadConfiguration((File)CONFIG_FILE);
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        commands = new HashMap<String, Command>();
        version = SpigotConfig.getInt("config-version", 3);
        SpigotConfig.set("config-version", 3);
        SpigotConfig.readConfig(SpigotConfig.class, null);
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.F().server.getCommandMap().register(entry.getKey(), "Spigot", entry.getValue());
        }
        if (metrics == null) {
            try {
                metrics = new Metrics();
                metrics.start();
            }
            catch (IOException ex) {
                Bukkit.getServer().getLogger().log(Level.SEVERE, "Could not start metrics service", ex);
            }
        }
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, (Object)def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, (Object)def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, (Object)def);
        return config.getString(path, config.getString(path));
    }

    private static void preventProxies() {
        preventProxies = SpigotConfig.getBoolean("settings.prevent-proxies", false);
    }

    private static void tpsCommand() {
        commands.put("tps", (Command)new TicksPerSecondCommand("tps"));
    }

    private static void watchdog() {
        timeoutTime = SpigotConfig.getInt("settings.timeout-time", timeoutTime);
        restartOnCrash = SpigotConfig.getBoolean("settings.restart-on-crash", restartOnCrash);
        restartScript = SpigotConfig.getString("settings.restart-script", restartScript);
        commands.put("restart", new RestartCommand("restart"));
        WatchdogThread.doStart(timeoutTime, restartOnCrash);
    }

    private static void listeners() {
        listeners.clear();
        HashMap<String, Object> def = new HashMap<String, Object>();
        def.put("host", "default");
        def.put("port", "default");
        def.put("netty", true);
        config.addDefault("listeners", Collections.singletonList(def));
        for (Map info : config.getList("listeners")) {
            String host = (String)info.get("host");
            if (!"default".equals(host)) {
                throw new IllegalArgumentException("Can only bind listener to default! Configure it in server.properties");
            }
            host = Bukkit.getIp();
            if (info.get("port") instanceof Integer) {
                throw new IllegalArgumentException("Can only bind port to default! Configure it in server.properties");
            }
            int port = Bukkit.getPort();
            boolean netty = (Boolean)info.get("netty");
            listeners.add(new Listener(host, port, netty, Bukkit.getConnectionThrottle()));
        }
        if (listeners.size() != 1) {
            throw new IllegalArgumentException("May only have one listener!");
        }
        nettyThreads = SpigotConfig.getInt("settings.netty-threads", 3);
    }

    private static void bungee() {
        bungeeAddresses = SpigotConfig.getList("settings.bungeecord-addresses", bungeeAddresses);
        bungee = SpigotConfig.getBoolean("settings.bungeecord", true);
    }

    private static void spamExclusions() {
        spamExclusions = SpigotConfig.getList("commands.spam-exclusions", Arrays.asList("/skill"));
    }

    private static void logCommands() {
        logCommands = SpigotConfig.getBoolean("commands.log", true);
    }

    private static void tabComplete() {
        tabComplete = SpigotConfig.getBoolean("commands.tab-complete", true);
    }

    private static String transform(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s).replaceAll("\\n", "\n");
    }

    private static void messages() {
        whitelistMessage = SpigotConfig.transform(SpigotConfig.getString("messages.whitelist", "You are not whitelisted on this server!"));
        unknownCommandMessage = SpigotConfig.transform(SpigotConfig.getString("messages.unknown-command", "Unknown command. Type \"/help\" for help."));
        serverFullMessage = SpigotConfig.transform(SpigotConfig.getString("messages.server-full", "The server is full!"));
        outdatedClientMessage = SpigotConfig.transform(SpigotConfig.getString("messages.outdated-client", "Outdated client!"));
        outdatedServerMessage = SpigotConfig.transform(SpigotConfig.getString("messages.outdated-server", "Outdated server!"));
    }

    private static void filters() {
        List<String> def = Arrays.asList("^(.*)(/login)(.*)$");
        logFilters = new ArrayList<Pattern>();
        for (String regex : SpigotConfig.getList("settings.log-filters", def)) {
            try {
                logFilters.add(Pattern.compile(regex));
            }
            catch (PatternSyntaxException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Supplied filter " + regex + " is invalid, ignoring!", ex);
            }
        }
        Bukkit.getLogger().setFilter(new LogFilter());
    }

    static {
        timeoutTime = 60;
        restartOnCrash = true;
        restartScript = "./start.sh";
        listeners = new ArrayList<Listener>();
        bungeeAddresses = Arrays.asList("127.0.0.1");
        bungee = true;
    }

    public static class Listener {
        public String host;
        public int port;
        public boolean netty;
        public long connectionThrottle;

        public Listener(String host, int port, boolean netty, long connectionThrottle) {
            this.host = host;
            this.port = port;
            this.netty = netty;
            this.connectionThrottle = connectionThrottle;
        }
    }
}

