/*
 * Decompiled with CFR 0.152.
 */
package guava10.com.google.common.collect;

import guava10.com.google.common.annotations.GwtCompatible;
import guava10.com.google.common.base.Preconditions;
import guava10.com.google.common.collect.NaturalOrdering;
import guava10.com.google.common.collect.Ordering;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class ReverseNaturalOrdering
extends Ordering<Comparable>
implements Serializable {
    static final ReverseNaturalOrdering INSTANCE = new ReverseNaturalOrdering();
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable left, Comparable right) {
        Preconditions.checkNotNull(left);
        if (left == right) {
            return 0;
        }
        return right.compareTo(left);
    }

    @Override
    public <S extends Comparable> Ordering<S> reverse() {
        return Ordering.natural();
    }

    @Override
    public <E extends Comparable> E min(E a, E b2) {
        return NaturalOrdering.INSTANCE.max(a, b2);
    }

    @Override
    public <E extends Comparable> E min(E a, E b2, E c2, E ... rest) {
        return NaturalOrdering.INSTANCE.max(a, b2, c2, rest);
    }

    @Override
    public <E extends Comparable> E min(Iterable<E> iterable) {
        return (E)((Comparable)NaturalOrdering.INSTANCE.max(iterable));
    }

    @Override
    public <E extends Comparable> E max(E a, E b2) {
        return NaturalOrdering.INSTANCE.min(a, b2);
    }

    @Override
    public <E extends Comparable> E max(E a, E b2, E c2, E ... rest) {
        return NaturalOrdering.INSTANCE.min(a, b2, c2, rest);
    }

    @Override
    public <E extends Comparable> E max(Iterable<E> iterable) {
        return (E)((Comparable)NaturalOrdering.INSTANCE.min(iterable));
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural().reverse()";
    }

    private ReverseNaturalOrdering() {
    }
}

