/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.command;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.IntSetting;
import net.minecraftforge.cauldron.configuration.Setting;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.util.StringUtil;

public class CauldronCommand
extends Command {
    private static final List<String> COMMANDS = ImmutableList.of((Object)"get", (Object)"set", (Object)"tick-interval", (Object)"save", (Object)"reload", (Object)"chunks", (Object)"heap");
    private static final List<String> CHUNK_COMMANDS = ImmutableList.of((Object)"print", (Object)"dump");

    public CauldronCommand() {
        super("cauldron");
        this.description = "Toggle certain Cauldron options";
        this.usageMessage = "/cauldron [" + StringUtils.join(COMMANDS, (char)'|') + "] <option> [value]";
        this.setPermission("cauldron.command.cauldron");
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length > 0 && "heap".equalsIgnoreCase(args[0])) {
            this.processHeap(sender, args);
            return true;
        }
        if (args.length > 0 && "chunks".equalsIgnoreCase(args[0])) {
            this.processChunks(sender, args);
            return true;
        }
        if (args.length == 1 && "save".equalsIgnoreCase(args[0])) {
            MinecraftServer.F();
            MinecraftServer.cauldronConfig.save();
            sender.sendMessage(ChatColor.GREEN + "Config file saved");
            return true;
        }
        if (args.length == 1 && "reload".equalsIgnoreCase(args[0])) {
            MinecraftServer.F();
            MinecraftServer.cauldronConfig.load();
            for (int i = 0; i < MinecraftServer.F().worlds.size(); ++i) {
                ((js)MinecraftServer.F().worlds.get((int)i)).cauldronConfig.init();
            }
            sender.sendMessage(ChatColor.GREEN + "Config file reloaded");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        if ("tick-interval".equalsIgnoreCase(args[0])) {
            return this.intervalSet(sender, args);
        }
        if ("get".equalsIgnoreCase(args[0])) {
            return this.getToggle(sender, args);
        }
        if ("set".equalsIgnoreCase(args[0])) {
            return this.setToggle(sender, args);
        }
        sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
        return false;
    }

    private void processHeap(CommandSender sender, String[] args) {
        File file = new File(new File(new File("."), "dumps"), "heap-dump-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.bin");
        sender.sendMessage("Writing chunk info to: " + file);
        CauldronHooks.dumpHeap(file, true);
        sender.sendMessage("Chunk info complete");
    }

    private void processChunks(CommandSender sender, String[] args) {
        sender.sendMessage(ChatColor.GOLD + "Dimension stats: ");
        for (js world : MinecraftServer.F().worlds) {
            sender.sendMessage(ChatColor.GOLD + "Dimension: " + ChatColor.GRAY + world.t.i + ChatColor.GOLD + " Loaded Chunks: " + ChatColor.GRAY + world.b.f.size() + ChatColor.GOLD + " Active Chunks: " + ChatColor.GRAY + world.G.size() + ChatColor.GOLD + " Entities: " + ChatColor.GRAY + world.e.size() + ChatColor.GOLD + " Tile Entities: " + ChatColor.GRAY + world.g.size());
            sender.sendMessage(ChatColor.GOLD + " Entities Last Tick: " + ChatColor.GRAY + world.entitiesTicked + ChatColor.GOLD + " Tiles Last Tick: " + ChatColor.GRAY + world.tilesTicked + ChatColor.GOLD + " Removed Entities: " + ChatColor.GRAY + world.f.size() + ChatColor.GOLD + " Removed Tile Entities: " + ChatColor.GRAY + world.b.size());
        }
        if (args.length < 2 || !"dump".equalsIgnoreCase(args[1])) {
            return;
        }
        boolean dumpAll = args.length > 2 && "all".equalsIgnoreCase(args[2]);
        File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
        sender.sendMessage("Writing chunk info to: " + file);
        CauldronHooks.writeChunks(file, dumpAll);
        sender.sendMessage("Chunk info complete");
    }

    private boolean getToggle(CommandSender sender, String[] args) {
        try {
            MinecraftServer.F();
            Setting toggle = MinecraftServer.cauldronConfig.getSettings().get(args[1]);
            if (toggle == null) {
                MinecraftServer.F();
                if (MinecraftServer.cauldronConfig.isSet(args[1])) {
                    MinecraftServer.F();
                    if (MinecraftServer.cauldronConfig.isBoolean(args[1])) {
                        MinecraftServer.F();
                        String string = args[1];
                        MinecraftServer.F();
                        toggle = new BoolSetting(MinecraftServer.cauldronConfig, string, MinecraftServer.cauldronConfig.getBoolean(args[1], false), "");
                    } else {
                        MinecraftServer.F();
                        if (MinecraftServer.cauldronConfig.isInt(args[1])) {
                            MinecraftServer.F();
                            String string = args[1];
                            MinecraftServer.F();
                            toggle = new IntSetting(MinecraftServer.cauldronConfig, string, MinecraftServer.cauldronConfig.getInt(args[1], 1), "");
                        }
                    }
                    if (toggle != null) {
                        MinecraftServer.F();
                        MinecraftServer.cauldronConfig.getSettings().put(toggle.path, toggle);
                        MinecraftServer.F();
                        MinecraftServer.cauldronConfig.load();
                    }
                }
            }
            if (toggle == null) {
                sender.sendMessage(ChatColor.RED + "Could not find option: " + args[1]);
                return false;
            }
            Object value = toggle.getValue();
            String option = (Boolean.TRUE.equals(value) ? ChatColor.GREEN : ChatColor.RED) + " " + value;
            sender.sendMessage(ChatColor.GOLD + args[1] + " " + option);
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            ex.printStackTrace();
        }
        return true;
    }

    private boolean intervalSet(CommandSender sender, String[] args) {
        try {
            int setting = NumberUtils.toInt((String)args[2], (int)1);
            MinecraftServer.F();
            MinecraftServer.cauldronConfig.set(args[1], setting);
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        return true;
    }

    private boolean setToggle(CommandSender sender, String[] args) {
        try {
            MinecraftServer.F();
            Setting toggle = MinecraftServer.cauldronConfig.getSettings().get(args[1]);
            if (toggle == null) {
                MinecraftServer.F();
                if (MinecraftServer.cauldronConfig.isSet(args[1])) {
                    MinecraftServer.F();
                    String string = args[1];
                    MinecraftServer.F();
                    toggle = new BoolSetting(MinecraftServer.cauldronConfig, string, MinecraftServer.cauldronConfig.getBoolean(args[1], false), "");
                    MinecraftServer.F();
                    MinecraftServer.cauldronConfig.getSettings().put(toggle.path, toggle);
                    MinecraftServer.F();
                    MinecraftServer.cauldronConfig.load();
                }
            }
            if (toggle == null) {
                sender.sendMessage(ChatColor.RED + "Could not find option: " + args[1]);
                return false;
            }
            if (args.length == 2) {
                sender.sendMessage(ChatColor.RED + "Usage: " + args[0] + " " + args[1] + " [value]");
                return false;
            }
            toggle.setValue(args[2]);
            Object value = toggle.getValue();
            String option = (Boolean.TRUE.equals(value) ? ChatColor.GREEN : ChatColor.RED) + " " + value;
            sender.sendMessage(ChatColor.GOLD + args[1] + " " + option);
            MinecraftServer.F();
            if (toggle == MinecraftServer.cauldronConfig.loadChunkOnRequest) {
                for (js world : MinecraftServer.F().worlds) {
                    jr jr2 = world.b;
                    MinecraftServer.F();
                    jr2.a = MinecraftServer.cauldronConfig.loadChunkOnRequest.getValue();
                }
            }
            MinecraftServer.F();
            MinecraftServer.cauldronConfig.save();
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            ex.printStackTrace();
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], COMMANDS, new ArrayList(COMMANDS.size()));
        }
        if (args.length == 2 && "get".equalsIgnoreCase(args[0]) || "set".equalsIgnoreCase(args[0])) {
            String string = args[1];
            MinecraftServer.F();
            Set<String> set = MinecraftServer.cauldronConfig.getSettings().keySet();
            MinecraftServer.F();
            return (List)StringUtil.copyPartialMatches((String)string, set, new ArrayList(MinecraftServer.cauldronConfig.getSettings().size()));
        }
        if (args.length == 2 && "chunks".equalsIgnoreCase(args[0])) {
            return (List)StringUtil.copyPartialMatches((String)args[1], CHUNK_COMMANDS, new ArrayList(CHUNK_COMMANDS.size()));
        }
        return ImmutableList.of();
    }
}

