/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import gnu.trove.set.hash.TByteHashSet;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.SpigotWorldConfig;

public class AntiXray {
    private static final CustomTimingsHandler update = new CustomTimingsHandler("xray - update");
    private static final CustomTimingsHandler obfuscate = new CustomTimingsHandler("xray - obfuscate");
    private final boolean[] obfuscateBlocks = new boolean[Short.MAX_VALUE];
    private byte[] replacementOres;

    public AntiXray(SpigotWorldConfig config) {
        for (int id : config.blocks) {
            this.obfuscateBlocks[id] = true;
        }
        TByteHashSet blocks = new TByteHashSet();
        for (int i = 0; i < this.obfuscateBlocks.length; ++i) {
            aqz block;
            if (!this.obfuscateBlocks[i] || (block = aqz.s[i]) == null || block.t()) continue;
            blocks.add((byte)i);
        }
        this.replacementOres = blocks.toArray();
    }

    public void updateNearbyBlocks(abw world, int x2, int y, int z2) {
        if (world.spigotConfig.antiXray) {
            update.startTiming();
            this.updateNearbyBlocks(world, x2, y, z2, 2, false);
            update.stopTiming();
        }
    }

    public void obfuscateSync(int chunkX, int chunkY, int bitmask, byte[] buffer, abw world) {
        if (world.spigotConfig.antiXray) {
            obfuscate.startTiming();
            this.obfuscate(chunkX, chunkY, bitmask, buffer, world);
            obfuscate.stopTiming();
        }
    }

    public void obfuscate(int chunkX, int chunkY, int bitmask, byte[] buffer, abw world) {
        if (world.spigotConfig.antiXray) {
            int initialRadius = 1;
            int index = 0;
            int randomOre = 0;
            int startX = chunkX << 4;
            int startZ = chunkY << 4;
            for (int i = 0; i < 16; ++i) {
                if ((bitmask & 1 << i) == 0) continue;
                for (int y = 0; y < 16; ++y) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        for (int x2 = 0; x2 < 16; ++x2) {
                            if (index >= buffer.length) continue;
                            int blockId = buffer[index] & 0xFF;
                            if (this.obfuscateBlocks[blockId]) {
                                if (initialRadius != 0 && !AntiXray.isLoaded(world, startX + x2, (i << 4) + y, startZ + z2, initialRadius)) continue;
                                if (initialRadius == 0 || !AntiXray.hasTransparentBlockAdjacent(world, startX + x2, (i << 4) + y, startZ + z2, initialRadius)) {
                                    switch (world.spigotConfig.engineMode) {
                                        case 1: {
                                            buffer[index] = (byte)aqz.y.cF;
                                            break;
                                        }
                                        case 2: {
                                            if (randomOre >= this.replacementOres.length) {
                                                randomOre = 0;
                                            }
                                            buffer[index] = this.replacementOres[randomOre++];
                                        }
                                    }
                                }
                            }
                            ++index;
                        }
                    }
                }
            }
        }
    }

    private void updateNearbyBlocks(abw world, int x2, int y, int z2, int radius, boolean updateSelf) {
        if (world.f(x2, y, z2)) {
            int id = world.a(x2, y, z2);
            if (updateSelf && this.obfuscateBlocks[id]) {
                world.j(x2, y, z2);
            }
            if (radius > 0) {
                this.updateNearbyBlocks(world, x2 + 1, y, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x2 - 1, y, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x2, y + 1, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x2, y - 1, z2, radius - 1, true);
                this.updateNearbyBlocks(world, x2, y, z2 + 1, radius - 1, true);
                this.updateNearbyBlocks(world, x2, y, z2 - 1, radius - 1, true);
            }
        }
    }

    private static boolean isLoaded(abw world, int x2, int y, int z2, int radius) {
        return world.f(x2, y, z2) || radius > 0 && (AntiXray.isLoaded(world, x2 + 1, y, z2, radius - 1) || AntiXray.isLoaded(world, x2 - 1, y, z2, radius - 1) || AntiXray.isLoaded(world, x2, y + 1, z2, radius - 1) || AntiXray.isLoaded(world, x2, y - 1, z2, radius - 1) || AntiXray.isLoaded(world, x2, y, z2 + 1, radius - 1) || AntiXray.isLoaded(world, x2, y, z2 - 1, radius - 1));
    }

    private static boolean hasTransparentBlockAdjacent(abw world, int x2, int y, int z2, int radius) {
        return !aqz.l((int)world.a(x2, y, z2)) || radius > 0 && (AntiXray.hasTransparentBlockAdjacent(world, x2 + 1, y, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x2 - 1, y, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x2, y + 1, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x2, y - 1, z2, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x2, y, z2 + 1, radius - 1) || AntiXray.hasTransparentBlockAdjacent(world, x2, y, z2 - 1, radius - 1));
    }
}

