/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class ServerInstall
extends Action {
    private List<Artifact> grabbed = new ArrayList<Artifact>();

    public ServerInstall(Install profile, ProgressCallback monitor) {
        super(profile, monitor, false);
    }

    @Override
    public boolean run(File target, Predicate<String> optionals) throws ActionCanceledException {
        if (target.exists() && !target.isDirectory()) {
            this.error("There is a file at this location, the server cannot be installed here!");
            return false;
        }
        File librariesDir = new File(target, "libraries");
        if (!target.exists()) {
            target.mkdirs();
        }
        librariesDir.mkdir();
        if (this.profile.getMirror() != null) {
            this.monitor.stage(this.getSponsorMessage());
        }
        this.checkCancel();
        Artifact contained = this.profile.getPath();
        this.monitor.stage("Extractiung main jar:");
        if (!DownloadUtils.extractFile(contained, new File(target, contained.getFilename()), null)) {
            this.error("  Failed to extract main jar: " + contained.getFilename());
            return false;
        }
        this.monitor.stage("  Extracted successfully");
        this.checkCancel();
        this.monitor.stage("Considering minecraft server jar");
        File serverTarget = new File(target, "minecraft_server." + this.profile.getMinecraft() + ".jar");
        if (!serverTarget.exists()) {
            File versionJson = new File(target, this.profile.getMinecraft() + ".json");
            Version vanilla = Util.getVanillaVersion(this.profile.getMinecraft(), versionJson);
            if (vanilla == null) {
                this.error("Failed to download version manifest, can not find server jar URL.");
                return false;
            }
            Version.Download server = vanilla.getDownload("server");
            if (server == null) {
                this.error("Failed to download minecraft server, info missing from manifest: " + versionJson);
                return false;
            }
            if (!DownloadUtils.download(this.monitor, this.profile.getMirror(), server, serverTarget)) {
                serverTarget.delete();
                this.error("Downloading minecraft server failed, invalid checksum.\nTry again, or manually place server jar to skip download.");
                return false;
            }
        }
        this.checkCancel();
        if (!this.downloadLibraries(librariesDir, optionals)) {
            return false;
        }
        this.checkCancel();
        return this.processors.process(librariesDir, serverTarget);
    }

    @Override
    public boolean isPathValid(File targetDir) {
        return targetDir.exists() && targetDir.isDirectory() && targetDir.list().length == 0;
    }

    @Override
    public String getFileError(File targetDir) {
        if (!targetDir.exists()) {
            return "The specified directory does not exist<br/>It will be created";
        }
        if (!targetDir.isDirectory()) {
            return "The specified path needs to be a directory";
        }
        return "There are already files at the target directory";
    }

    @Override
    public String getSuccessMessage() {
        if (this.grabbed.size() > 0) {
            return String.format("Successfully downloaded minecraft server, downloaded %d libraries and installed %s", this.grabbed.size(), this.profile.getVersion());
        }
        return String.format("Successfully downloaded minecraft server and installed %s", this.profile.getVersion());
    }
}

