/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

public class TlsUtils {
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    static final byte[][] SSL3_CONST = TlsUtils.genConst();

    protected static void writeUint8(short s2, OutputStream outputStream) throws IOException {
        outputStream.write(s2);
    }

    protected static void writeUint8(short s2, byte[] byArray, int n2) {
        byArray[n2] = (byte)s2;
    }

    protected static void writeUint16(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
    }

    protected static void writeUint16(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 8);
        byArray[n3 + 1] = (byte)n2;
    }

    protected static void writeUint24(int n2, OutputStream outputStream) throws IOException {
        outputStream.write(n2 >> 16);
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
    }

    protected static void writeUint24(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 16);
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3 + 2] = (byte)n2;
    }

    protected static void writeUint32(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l2 >> 24));
        outputStream.write((int)(l2 >> 16));
        outputStream.write((int)(l2 >> 8));
        outputStream.write((int)l2);
    }

    protected static void writeUint32(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 24);
        byArray[n2 + 1] = (byte)(l2 >> 16);
        byArray[n2 + 2] = (byte)(l2 >> 8);
        byArray[n2 + 3] = (byte)l2;
    }

    protected static void writeUint64(long l2, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l2 >> 56));
        outputStream.write((int)(l2 >> 48));
        outputStream.write((int)(l2 >> 40));
        outputStream.write((int)(l2 >> 32));
        outputStream.write((int)(l2 >> 24));
        outputStream.write((int)(l2 >> 16));
        outputStream.write((int)(l2 >> 8));
        outputStream.write((int)l2);
    }

    protected static void writeUint64(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)(l2 >> 56);
        byArray[n2 + 1] = (byte)(l2 >> 48);
        byArray[n2 + 2] = (byte)(l2 >> 40);
        byArray[n2 + 3] = (byte)(l2 >> 32);
        byArray[n2 + 4] = (byte)(l2 >> 24);
        byArray[n2 + 5] = (byte)(l2 >> 16);
        byArray[n2 + 6] = (byte)(l2 >> 8);
        byArray[n2 + 7] = (byte)l2;
    }

    protected static void writeOpaque8(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8((short)byArray.length, outputStream);
        outputStream.write(byArray);
    }

    protected static void writeOpaque16(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint16(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    protected static void writeOpaque24(byte[] byArray, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint24(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    protected static void writeUint8Array(short[] sArray, OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            TlsUtils.writeUint8(sArray[i2], outputStream);
        }
    }

    protected static void writeUint16Array(int[] nArray, OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TlsUtils.writeUint16(nArray[i2], outputStream);
        }
    }

    protected static short readUint8(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (short)n2;
    }

    protected static int readUint16(InputStream inputStream) throws IOException {
        int n2;
        int n3 = inputStream.read();
        if ((n3 | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n3 << 8 | n2;
    }

    protected static int readUint24(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return n4 << 16 | n3 << 8 | n2;
    }

    protected static long readUint32(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = inputStream.read();
        if ((n5 | (n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (long)n5 << 24 | (long)n4 << 16 | (long)n3 << 8 | (long)n2;
    }

    protected static void readFully(byte[] byArray, InputStream inputStream) throws IOException {
        if (Streams.readFully(inputStream, byArray) != byArray.length) {
            throw new EOFException();
        }
    }

    protected static byte[] readOpaque8(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8(inputStream);
        byte[] byArray = new byte[s2];
        TlsUtils.readFully(byArray, inputStream);
        return byArray;
    }

    protected static byte[] readOpaque16(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint16(inputStream);
        byte[] byArray = new byte[n2];
        TlsUtils.readFully(byArray, inputStream);
        return byArray;
    }

    static ProtocolVersion readVersion(byte[] byArray) throws IOException {
        return ProtocolVersion.get(byArray[0], byArray[1]);
    }

    static ProtocolVersion readVersion(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        return ProtocolVersion.get(n2, n3);
    }

    protected static void writeGMTUnixTime(byte[] byArray, int n2) {
        int n3 = (int)(System.currentTimeMillis() / 1000L);
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    static void writeVersion(ProtocolVersion protocolVersion, OutputStream outputStream) throws IOException {
        outputStream.write(protocolVersion.getMajorVersion());
        outputStream.write(protocolVersion.getMinorVersion());
    }

    static void writeVersion(ProtocolVersion protocolVersion, byte[] byArray, int n2) throws IOException {
        byArray[n2] = (byte)protocolVersion.getMajorVersion();
        byArray[n2 + 1] = (byte)protocolVersion.getMinorVersion();
    }

    private static void hmac_hash(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        KeyParameter keyParameter = new KeyParameter(byArray);
        byte[] byArray4 = byArray2;
        int n2 = digest.getDigestSize();
        int n3 = (byArray3.length + n2 - 1) / n2;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i2 = 0; i2 < n3; ++i2) {
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.init(keyParameter);
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n2 * i2, Math.min(n2, byArray3.length - n2 * i2));
        }
    }

    protected static byte[] PRF(byte[] byArray, String string, byte[] byArray2, int n2) {
        byte[] byArray3 = Strings.toByteArray(string);
        int n3 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray, 0, byArray4, 0, n3);
        System.arraycopy(byArray, byArray.length - n3, byArray5, 0, n3);
        byte[] byArray6 = TlsUtils.concat(byArray3, byArray2);
        byte[] byArray7 = new byte[n2];
        byte[] byArray8 = new byte[n2];
        TlsUtils.hmac_hash(new MD5Digest(), byArray4, byArray6, byArray8);
        TlsUtils.hmac_hash(new SHA1Digest(), byArray5, byArray6, byArray7);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = i2;
            byArray7[n4] = (byte)(byArray7[n4] ^ byArray8[i2]);
        }
        return byArray7;
    }

    static byte[] PRF_1_2(Digest digest, byte[] byArray, String string, byte[] byArray2, int n2) {
        byte[] byArray3 = Strings.toByteArray(string);
        byte[] byArray4 = TlsUtils.concat(byArray3, byArray2);
        byte[] byArray5 = new byte[n2];
        TlsUtils.hmac_hash(digest, byArray, byArray4, byArray5);
        return byArray5;
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static void validateKeyUsage(X509CertificateStructure x509CertificateStructure, int n2) throws IOException {
        DERBitString dERBitString;
        int n3;
        X509Extension x509Extension;
        X509Extensions x509Extensions = x509CertificateStructure.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(X509Extension.keyUsage)) != null && ((n3 = (dERBitString = KeyUsage.getInstance(x509Extension)).getBytes()[0] & 0xFF) & n2) != n2) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] calculateKeyBlock(TlsClientContext tlsClientContext, int n2) {
        byte[] byArray;
        boolean bl2;
        ProtocolVersion protocolVersion = tlsClientContext.getServerVersion();
        SecurityParameters securityParameters = tlsClientContext.getSecurityParameters();
        byte[] byArray2 = TlsUtils.concat(securityParameters.serverRandom, securityParameters.clientRandom);
        boolean bl3 = bl2 = protocolVersion.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (bl2) {
            return TlsUtils.PRF(securityParameters.masterSecret, "key expansion", byArray2, n2);
        }
        MD5Digest mD5Digest = new MD5Digest();
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n3 = mD5Digest.getDigestSize();
        byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray4 = new byte[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            byArray = SSL3_CONST[n4];
            sHA1Digest.update(byArray, 0, byArray.length);
            sHA1Digest.update(securityParameters.masterSecret, 0, securityParameters.masterSecret.length);
            sHA1Digest.update(byArray2, 0, byArray2.length);
            sHA1Digest.doFinal(byArray3, 0);
            mD5Digest.update(securityParameters.masterSecret, 0, securityParameters.masterSecret.length);
            mD5Digest.update(byArray3, 0, byArray3.length);
            mD5Digest.doFinal(byArray4, n5);
            n5 += n3;
            ++n4;
        }
        byArray = new byte[n2];
        System.arraycopy(byArray4, 0, byArray, 0, n2);
        return byArray;
    }

    static byte[] calculateMasterSecret(TlsClientContext tlsClientContext, byte[] byArray) {
        boolean bl2;
        ProtocolVersion protocolVersion = tlsClientContext.getServerVersion();
        SecurityParameters securityParameters = tlsClientContext.getSecurityParameters();
        byte[] byArray2 = TlsUtils.concat(securityParameters.clientRandom, securityParameters.serverRandom);
        boolean bl3 = bl2 = protocolVersion.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (bl2) {
            return TlsUtils.PRF(byArray, "master secret", byArray2, 48);
        }
        MD5Digest mD5Digest = new MD5Digest();
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n2 = mD5Digest.getDigestSize();
        byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray4 = new byte[n2 * 3];
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            byte[] byArray5 = SSL3_CONST[i2];
            sHA1Digest.update(byArray5, 0, byArray5.length);
            sHA1Digest.update(byArray, 0, byArray.length);
            sHA1Digest.update(byArray2, 0, byArray2.length);
            sHA1Digest.doFinal(byArray3, 0);
            mD5Digest.update(byArray, 0, byArray.length);
            mD5Digest.update(byArray3, 0, byArray3.length);
            mD5Digest.doFinal(byArray4, n3);
            n3 += n2;
        }
        return byArray4;
    }

    static byte[] calculateVerifyData(TlsClientContext tlsClientContext, String string, byte[] byArray) {
        boolean bl2;
        ProtocolVersion protocolVersion = tlsClientContext.getServerVersion();
        SecurityParameters securityParameters = tlsClientContext.getSecurityParameters();
        boolean bl3 = bl2 = protocolVersion.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (bl2) {
            return TlsUtils.PRF(securityParameters.masterSecret, string, byArray, 12);
        }
        return byArray;
    }

    private static byte[][] genConst() {
        int n2 = 10;
        byte[][] byArrayArray = new byte[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = new byte[i2 + 1];
            Arrays.fill(byArray, (byte)(65 + i2));
            byArrayArray[i2] = byArray;
        }
        return byArrayArray;
    }
}

