/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTTextureAtlasSprite
implements IClassTransformer {
    public byte[] transform(String arg0, String arg1, byte[] arg2) {
        SMCLog.fine("transforming %s %s", arg0, arg1);
        ClassReader cr = new ClassReader(arg2);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVuploadFrameTexture
    extends MethodVisitor {
        public MVuploadFrameTexture(MethodVisitor mv) {
            super(262144, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(21, 1);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(21, 3);
            mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "uploadFrameTexture", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;III)V");
            mv.visitInsn(177);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", null, l0, l2, 0);
            mv.visitLocalVariable("frameIndex", "I", null, l0, l2, 1);
            mv.visitLocalVariable("xPos", "I", null, l0, l2, 2);
            mv.visitLocalVariable("yPos", "I", null, l0, l2, 3);
            mv.visitMaxs(4, 4);
            mv.visitEnd();
        }
    }

    private static class MVloadSprite
    extends MethodVisitor {
        public MVloadSprite(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 188 && operand == 10) {
                this.mv.visitInsn(6);
                this.mv.visitInsn(104);
            }
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals("java/awt/image/BufferedImage") && nameM.equals("getRGB") && descM.equals("(IIII[III)[I")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "loadAtlasSprite", "(Ljava/awt/image/BufferedImage;IIII[III)[I");
                return;
            }
            if (ownerM.equals("net/minecraft/client/renderer/texture/TextureAtlasSprite") && nameM.equals("func_130101_a") && descM.equals("([IIII)[I")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "extractFrame", "([IIII)[I");
                return;
            }
            if (ownerM.equals("net/minecraft/client/renderer/texture/TextureAtlasSprite") && nameM.equals("fixTransparentColor") && descM.equals("([I)V")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "fixTransparentColor", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;[I)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class MVload
    extends MethodVisitor {
        public MVload(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals("net/minecraft/client/resources/ResourceManager") && nameM.equals("func_110536_a") && descM.equals("(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/Resource;")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "loadResource", "(Lnet/minecraft/client/resources/ResourceManager;Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/resources/Resource;");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    protected static class MVanimation
    extends MethodVisitor {
        public MVanimation(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            String ownerM = SMCRemap.remapper.mapType(owner);
            String nameM = SMCRemap.remapper.mapMethodName(owner, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (ownerM.equals("net/minecraft/client/renderer/texture/TextureUtil") && nameM.equals("func_110998_a") && descM.equals("([IIIIIZZ)V")) {
                this.mv.visitMethodInsn(184, "shadersmodcore/client/ShadersTex", "updateSubImage", "([IIIIIZZ)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            String descM = SMCRemap.remapper.mapMethodDesc(desc);
            if (nameM.equals("func_94219_l") && descM.equals("()V")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVanimation(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("load") && descM.equals("(Lnet/minecraft/client/resources/ResourceManager;Lnet/minecraft/util/ResourceLocation;)Z")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVload(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("func_130100_a") && descM.equals("(Lnet/minecraft/client/resources/Resource;)V")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVloadSprite(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (nameM.equals("uploadFrameTexture") && descM.equals("(III)V")) {
                SMCLog.finer("  patching method %s.%s%s = %s", this.classname, name, desc, nameM);
                return new MVuploadFrameTexture(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

