#version 120

/* DRAWBUFFERS:0N2N4 */
//affect the minecraft lightmap (not torches)
#define MIN_LIGHTAMOUNT 0.1
#define MINELIGHTMAP_EXP 2.0
//#define USE_WATER_TEXTURE

//water color and opacity
vec4 watercolor = vec4(0.1,0.25,0.45,0.6); //r,g,b,opacity

uniform sampler2D texture;
uniform float rainStrength;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying vec3 normal;

varying float iswater;


const float MAX_OCCLUSION_DISTANCE = 100.0;

const int MAX_OCCLUSION_POINTS = 20;

uniform int worldTime;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

const float bump_distance = 80.0f;
const float fademult = 0.1f;





void main() {	
	
vec4 tex = texture2D(texture, texcoord.xy);
#ifndef USE_WATER_TEXTURE
 if (iswater > 0.9) tex = watercolor;
 #endif

	
	
	vec3 indlmap = mix(pow(min(lmcoord.t+MIN_LIGHTAMOUNT,1.0),MINELIGHTMAP_EXP),1.0,lmcoord.s)*tex.rgb*color.rgb;
	gl_FragData[0] = vec4(indlmap,tex.a);
	gl_FragDepth = gl_FragCoord.z;
	
	vec4 frag2;
	

			frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);			
	
	
	gl_FragData[2] = frag2;	
	//x = specularity / y = land(0.0/1.0)/shadow early exit(0.2)/water(0.05) / z = torch lightmap
	gl_FragData[4] = vec4(0.0, mix(1.0,0.05,iswater), lmcoord.s, 1.0);
	
}