#version 120

#define WAVING_WATER

uniform int worldTime;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

varying vec3 normal;

attribute vec4 mc_Entity;

varying float iswater;

uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

const float PI = 3.141592653589793;

//varying vec4 bloommask;

//attribute vec4 mc_Entity;

void main() {

	iswater = 0.0f;

	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	//vec4 viewpos = gl_ModelViewMatrix * gl_Vertex;

	/* un-rotate */
	vec4 viewpos = gbufferModelViewInverse * position;

	vec3 worldpos = viewpos.xyz + cameraPosition;
	float displacement = 0.0;
	/*
	if (mc_Entity.x == 8.0 || mc_Entity.x == 9.0) {
	iswater = 1.0;
		float speed = 1.0;
		
        float magnitude = (sin((worldTime * 3.14159265358979323846264 / ((28.0) * speed))) * 0.05 + 0.15) * 0.4;
        float d0 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5;
        float d1 = sin(worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;
        float d2 = sin(worldTime * 3.14159265358979323846264 / (162.0 * speed)) * 3.0 - 1.5;
        float d3 = sin(worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 - 1.5;
		displacement = sin((worldTime * 3.14159265358979323846264 / (15.0 * speed)) + (position.z + d2) + (position.x + d3)) * magnitude;
        position.y += displacement;
		
					for(int i = 1; i < 4; ++i){
		
			float octave = i * 0.5;
			float speed = (octave) * 2.0;
			
			float magnitude = (sin((position.y * octave + position.x * octave + worldTime * octave * 3.14159265358979323846264 / ((28.0) * speed))) * 0.15 + 0.15) * 0.2;
			float d0 = sin(position.y * octave * 3.0 + position.x * octave * 0.3 + worldTime * 3.14159265358979323846264 / (112.0 * speed)) * 3.0 - 1.5;
			float d1 = sin(position.y * octave * 0.7 - position.x * octave * 10.0 + worldTime * 3.14159265358979323846264 / (142.0 * speed)) * 3.0 - 1.5;
			float d2 = sin(worldTime * 3.14159265358979323846264 / (132.0 * speed)) * 3.0 - 1.5;
			float d3 = sin(worldTime * 3.14159265358979323846264 / (122.0 * speed)) * 3.0 - 1.5;
			displacement += sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z * octave + d2) + (position.x * octave + d3)) * (magnitude/2.0);
			displacement -= sin((worldTime * 3.14159265358979323846264 / (11.0 * speed)) + (position.z * octave * 0.5 + d1) + (position.x * octave * 2.0 + d0)) * (magnitude/2.0);
			position.y += displacement;
		}
	}
	*/
		if(mc_Entity.x == 8.0 || mc_Entity.x == 9.0) { 
		iswater = 1.0;
	    float fy = fract(worldpos.y + 0.001);
	    if (fy > 0.002)
		{
		    /* animate */
			float wave = 0.05 * sin(2 * PI * (worldTime / 86.0 + worldpos.x /  7.0 + worldpos.z / 13.0))
		               + 0.05 * sin(2 * PI * (worldTime / 60.0 + worldpos.x / 11.0 + worldpos.z /  5.0));
					   displacement = clamp(wave, -fy, 1.0-fy);
			viewpos.y += displacement;
		}
	}

	/* re-rotate */
	viewpos = gbufferModelView * viewpos;

	/* projectify */
	gl_Position = gl_ProjectionMatrix * viewpos;
	
	
	color = gl_Color;
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	


	gl_FogFragCoord = gl_Position.z;
	
	
	normal = normalize(gl_NormalMatrix * normalize(gl_Normal) + vec3(0.33*-displacement,0.0,0.16*displacement));

	
}