/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;

@SideOnly(value=Side.CLIENT)
public class Face {
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public void addFaceForRender(bfq tessellator) {
        this.addFaceForRender(tessellator, 5.0E-4f);
    }

    public void addFaceForRender(bfq tessellator, float textureOffset) {
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        tessellator.b(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i2 = 0; i2 < this.textureCoordinates.length; ++i2) {
                averageU += this.textureCoordinates[i2].u;
                averageV += this.textureCoordinates[i2].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        for (int i3 = 0; i3 < this.vertices.length; ++i3) {
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i3].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i3].v > averageV) {
                    offsetV = -offsetV;
                }
                tessellator.a(this.vertices[i3].x, this.vertices[i3].y, this.vertices[i3].z, this.textureCoordinates[i3].u + offsetU, this.textureCoordinates[i3].v + offsetV);
                continue;
            }
            tessellator.a((double)this.vertices[i3].x, (double)this.vertices[i3].y, (double)this.vertices[i3].z);
        }
    }

    public Vertex calculateFaceNormal() {
        atc v1 = atc.a(this.vertices[1].x - this.vertices[0].x, this.vertices[1].y - this.vertices[0].y, this.vertices[1].z - this.vertices[0].z);
        atc v2 = atc.a(this.vertices[2].x - this.vertices[0].x, this.vertices[2].y - this.vertices[0].y, this.vertices[2].z - this.vertices[0].z);
        atc normalVector = null;
        normalVector = v1.c(v2).a();
        return new Vertex((float)normalVector.c, (float)normalVector.d, (float)normalVector.e);
    }
}

