/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends aei>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, js> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);
    private static ConcurrentMap<abw, abw> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static boolean registerProviderType(int id2, Class<? extends aei> provider, boolean keepLoaded) {
        if (providers.containsKey(id2)) {
            return false;
        }
        providers.put(id2, provider);
        spawnSettings.put(id2, keepLoaded);
        return true;
    }

    public static int[] unregisterProviderType(int id2) {
        if (!providers.containsKey(id2)) {
            return new int[0];
        }
        providers.remove(id2);
        spawnSettings.remove(id2);
        int[] ret = new int[dimensions.size()];
        int x2 = 0;
        for (Map.Entry<Integer, Integer> ent : dimensions.entrySet()) {
            if (ent.getValue() != id2) continue;
            ret[x2++] = ent.getKey();
        }
        return Arrays.copyOf(ret, x2);
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerProviderType(0, aek.class, true);
        DimensionManager.registerProviderType(-1, aej.class, true);
        DimensionManager.registerProviderType(1, ael.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id2, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, provider type %d does not exist", id2, providerType));
        }
        if (dimensions.containsKey(id2)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id2));
        }
        dimensions.put(id2, providerType);
        if (id2 >= 0) {
            dimensionMap.set(id2);
        }
    }

    public static void unregisterDimension(int id2) {
        if (!dimensions.containsKey(id2)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id2));
        }
        dimensions.remove(id2);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static aei getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).t;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(worlds.values());
            ListIterator li2 = allWorlds.listIterator();
            while (li2.hasNext()) {
                abw w2 = (abw)li2.next();
                leakedWorlds.add((Object)System.identityHashCode(w2));
            }
            for (abw w2 : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w2));
                if (leakCount == 5) {
                    FMLLog.fine("The world %x (%s) may have leaked: first encounter (5 occurences).\n", System.identityHashCode(w2), w2.N().k());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.fine("The world %x (%s) may have leaked: seen %d times.\n", System.identityHashCode(w2), w2.N().k(), leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id2, js world) {
        if (world != null) {
            worlds.put(id2, world);
            weakWorldMap.put(world, world);
            MinecraftServer.F().worldTickTimes.put(id2, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id2, world.N().k(), world.p());
        } else {
            worlds.remove(id2);
            MinecraftServer.F().worldTickTimes.remove(id2);
            FMLLog.info("Unloading dimension %d", id2);
        }
        ArrayList<js> tmp = new ArrayList<js>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, js> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.F().b = tmp.toArray(new js[tmp.size()]);
    }

    public static void initDimension(int dim) {
        js overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e2) {
            System.err.println("Cannot Hotload Dim: " + e2.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.p();
        amc savehandler = overworld.M();
        acd worldSettings = new acd(overworld.N());
        js world = dim == 0 ? overworld : new jl(mcServer, savehandler, overworld.N().k(), dim, worldSettings, overworld, mcServer.a, overworld.Y());
        world.a(new jo(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.K()) {
            world.N().a(mcServer.h());
        }
        mcServer.c(mcServer.i());
    }

    public static js getWorld(int id2) {
        return worlds.get(id2);
    }

    public static js[] getWorlds() {
        return worlds.values().toArray(new js[worlds.size()]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id2 = DimensionManager.getProviderType(dim);
        return spawnSettings.containsKey(id2) && spawnSettings.get(id2) != false;
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static aei createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                aei provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e2) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.SEVERE, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), e2);
            throw new RuntimeException(e2);
        }
    }

    public static void unloadWorld(int id2) {
        unloadQueue.add(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id2 : unloadQueue) {
            js w2 = worlds.get(id2);
            try {
                if (w2 != null) {
                    w2.a(true, null);
                    continue;
                }
                FMLLog.warning("Unexpected world unload - world %d is already unloaded", id2);
            }
            catch (aca e2) {
                e2.printStackTrace();
            }
            finally {
                if (w2 == null) continue;
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(w2));
                w2.n();
                DimensionManager.setWorld(id2, null);
            }
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static by saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        by dimMap = new by();
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = 0;
            for (int j2 = 0; j2 < 32; ++j2) {
                val |= dimensionMap.get(i2 * 32 + j2) ? 1 << j2 : 0;
            }
            data[i2] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(by compoundTag) {
        if (compoundTag == null) {
            dimensionMap.clear();
            for (Integer id2 : dimensions.keySet()) {
                if (id2 < 0) continue;
                dimensionMap.set(id2);
            }
        } else {
            int[] intArray = compoundTag.k("DimensionArray");
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    dimensionMap.set(i2 * 32 + j2, (intArray[i2] & 1 << j2) != 0);
                }
            }
        }
    }

    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return ((alq)DimensionManager.getWorld(0).M()).b();
        }
        if (MinecraftServer.F() != null) {
            MinecraftServer srv = MinecraftServer.F();
            alq saveHandler = (alq)srv.P().a(srv.L(), false);
            return saveHandler.b();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }
}

