/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ReferenceMap;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2ReferenceSortedMap;
import it.unimi.dsi.fastutil.doubles.Double2ReferenceMap;
import it.unimi.dsi.fastutil.doubles.Double2ReferenceSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class Double2ReferenceRBTreeMap<V>
extends AbstractDouble2ReferenceSortedMap<V>
implements Serializable,
Cloneable {
    protected transient Entry<V> tree;
    protected int count;
    protected transient Entry<V> firstEntry;
    protected transient Entry<V> lastEntry;
    protected transient ObjectSortedSet<Double2ReferenceMap.Entry<V>> entries;
    protected transient DoubleSortedSet keys;
    protected transient ReferenceCollection<V> values;
    protected transient boolean modified;
    protected Comparator<? super Double> storedComparator;
    protected transient DoubleComparator actualComparator;
    private static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry<V>[] nodePath;

    public Double2ReferenceRBTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof DoubleComparator ? (DoubleComparator)this.storedComparator : new DoubleComparator(){

            @Override
            public int compare(double k1, double k2) {
                return Double2ReferenceRBTreeMap.this.storedComparator.compare((Double)k1, (Double)k2);
            }

            @Override
            public int compare(Double ok1, Double ok2) {
                return Double2ReferenceRBTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Double2ReferenceRBTreeMap(Comparator<? super Double> c2) {
        this();
        this.storedComparator = c2;
    }

    public Double2ReferenceRBTreeMap(Map<? extends Double, ? extends V> m2) {
        this();
        this.putAll((Map<Double, ? extends V>)m2);
    }

    public Double2ReferenceRBTreeMap(SortedMap<Double, V> m2) {
        this(m2.comparator());
        this.putAll((Map<Double, V>)m2);
    }

    public Double2ReferenceRBTreeMap(Double2ReferenceMap<? extends V> m2) {
        this();
        this.putAll(m2);
    }

    public Double2ReferenceRBTreeMap(Double2ReferenceSortedMap<V> m2) {
        this(m2.comparator());
        this.putAll(m2);
    }

    public Double2ReferenceRBTreeMap(double[] k2, V[] v2, Comparator<? super Double> c2) {
        this(c2);
        if (k2.length != v2.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v2.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v2[i2]);
        }
    }

    public Double2ReferenceRBTreeMap(double[] k2, V[] v2) {
        this(k2, v2, null);
    }

    final int compare(double k1, double k2) {
        return this.actualComparator == null ? Double.compare(k1, k2) : this.actualComparator.compare(k1, k2);
    }

    final Entry<V> findKey(double k2) {
        int cmp;
        Entry<V> e2 = this.tree;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return e2;
    }

    final Entry<V> locateKey(double k2) {
        Entry<V> e2 = this.tree;
        Entry<V> last = this.tree;
        int cmp = 0;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            last = e2;
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return cmp == 0 ? e2 : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    @Override
    public V put(double k2, V v2) {
        Entry<V> e2 = this.add(k2);
        Object oldValue = e2.value;
        e2.value = v2;
        return (V)oldValue;
    }

    private Entry<V> add(double k2) {
        Entry<Object> e2;
        this.modified = false;
        int maxDepth = 0;
        if (this.tree == null) {
            ++this.count;
            this.firstEntry = new Entry<Object>(k2, this.defRetValue);
            this.lastEntry = this.firstEntry;
            this.tree = this.firstEntry;
            e2 = this.firstEntry;
        } else {
            Entry<Object> p2 = this.tree;
            int i2 = 0;
            while (true) {
                int cmp;
                if ((cmp = this.compare(k2, p2.key)) == 0) {
                    while (i2-- != 0) {
                        this.nodePath[i2] = null;
                    }
                    return p2;
                }
                this.nodePath[i2] = p2;
                this.dirPath[i2++] = cmp > 0;
                if (this.dirPath[i2++]) {
                    if (p2.succ()) {
                        ++this.count;
                        e2 = new Entry<Object>(k2, this.defRetValue);
                        if (p2.right == null) {
                            this.lastEntry = e2;
                        }
                        e2.left = p2;
                        e2.right = p2.right;
                        p2.right(e2);
                        break;
                    }
                    p2 = p2.right;
                    continue;
                }
                if (p2.pred()) {
                    ++this.count;
                    e2 = new Entry<Object>(k2, this.defRetValue);
                    if (p2.left == null) {
                        this.firstEntry = e2;
                    }
                    e2.right = p2;
                    e2.left = p2.left;
                    p2.left(e2);
                    break;
                }
                p2 = p2.left;
            }
            this.modified = true;
            maxDepth = i2--;
            while (i2 > 0 && !this.nodePath[i2].black()) {
                Entry x2;
                Entry y2;
                if (!this.dirPath[i2 - 1]) {
                    y2 = this.nodePath[i2 - 1].right;
                    if (!this.nodePath[i2 - 1].succ() && !y2.black()) {
                        this.nodePath[i2].black(true);
                        y2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        i2 -= 2;
                        continue;
                    }
                    if (!this.dirPath[i2]) {
                        y2 = this.nodePath[i2];
                    } else {
                        x2 = this.nodePath[i2];
                        y2 = x2.right;
                        x2.right = y2.left;
                        y2.left = x2;
                        this.nodePath[i2 - 1].left = y2;
                        if (y2.pred()) {
                            y2.pred(false);
                            x2.succ(y2);
                        }
                    }
                    x2 = this.nodePath[i2 - 1];
                    x2.black(false);
                    y2.black(true);
                    x2.left = y2.right;
                    y2.right = x2;
                    if (i2 < 2) {
                        this.tree = y2;
                    } else if (this.dirPath[i2 - 2]) {
                        this.nodePath[i2 - 2].right = y2;
                    } else {
                        this.nodePath[i2 - 2].left = y2;
                    }
                    if (!y2.succ()) break;
                    y2.succ(false);
                    x2.pred(y2);
                    break;
                }
                y2 = this.nodePath[i2 - 1].left;
                if (!this.nodePath[i2 - 1].pred() && !y2.black()) {
                    this.nodePath[i2].black(true);
                    y2.black(true);
                    this.nodePath[i2 - 1].black(false);
                    i2 -= 2;
                    continue;
                }
                if (this.dirPath[i2]) {
                    y2 = this.nodePath[i2];
                } else {
                    x2 = this.nodePath[i2];
                    y2 = x2.left;
                    x2.left = y2.right;
                    y2.right = x2;
                    this.nodePath[i2 - 1].right = y2;
                    if (y2.succ()) {
                        y2.succ(false);
                        x2.pred(y2);
                    }
                }
                x2 = this.nodePath[i2 - 1];
                x2.black(false);
                y2.black(true);
                x2.right = y2.left;
                y2.left = x2;
                if (i2 < 2) {
                    this.tree = y2;
                } else if (this.dirPath[i2 - 2]) {
                    this.nodePath[i2 - 2].right = y2;
                } else {
                    this.nodePath[i2 - 2].left = y2;
                }
                if (!y2.pred()) break;
                y2.pred(false);
                x2.succ(y2);
                break;
            }
        }
        this.tree.black(true);
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V remove(double k2) {
        int i2;
        Entry<V> p2;
        block68: {
            Entry s2;
            int j2;
            boolean color;
            block74: {
                block69: {
                    Entry r2;
                    block73: {
                        block71: {
                            block72: {
                                block66: {
                                    block67: {
                                        this.modified = false;
                                        if (this.tree == null) {
                                            return (V)this.defRetValue;
                                        }
                                        p2 = this.tree;
                                        i2 = 0;
                                        double kk = k2;
                                        while (true) {
                                            int cmp;
                                            if ((cmp = this.compare(kk, p2.key)) == 0) {
                                                if (p2.left != null) break block66;
                                                break block67;
                                            }
                                            this.dirPath[i2] = cmp > 0;
                                            this.nodePath[i2] = p2;
                                            if (this.dirPath[i2++]) {
                                                if ((p2 = p2.right()) != null) continue;
                                                while (true) {
                                                    if (i2-- == 0) {
                                                        return (V)this.defRetValue;
                                                    }
                                                    this.nodePath[i2] = null;
                                                }
                                            }
                                            if ((p2 = p2.left()) == null) break;
                                        }
                                        while (true) {
                                            if (i2-- == 0) {
                                                return (V)this.defRetValue;
                                            }
                                            this.nodePath[i2] = null;
                                        }
                                    }
                                    this.firstEntry = p2.next();
                                }
                                if (p2.right == null) {
                                    this.lastEntry = p2.prev();
                                }
                                if (!p2.succ()) break block71;
                                if (!p2.pred()) break block72;
                                if (i2 == 0) {
                                    this.tree = p2.left;
                                    break block68;
                                } else if (this.dirPath[i2 - 1]) {
                                    this.nodePath[i2 - 1].succ(p2.right);
                                    break block68;
                                } else {
                                    this.nodePath[i2 - 1].pred(p2.left);
                                }
                                break block68;
                            }
                            p2.prev().right = p2.right;
                            if (i2 == 0) {
                                this.tree = p2.left;
                                break block68;
                            } else if (this.dirPath[i2 - 1]) {
                                this.nodePath[i2 - 1].right = p2.left;
                                break block68;
                            } else {
                                this.nodePath[i2 - 1].left = p2.left;
                            }
                            break block68;
                        }
                        r2 = p2.right;
                        if (!r2.pred()) break block73;
                        r2.left = p2.left;
                        r2.pred(p2.pred());
                        if (!r2.pred()) {
                            r2.prev().right = r2;
                        }
                        if (i2 == 0) {
                            this.tree = r2;
                        } else if (this.dirPath[i2 - 1]) {
                            this.nodePath[i2 - 1].right = r2;
                        } else {
                            this.nodePath[i2 - 1].left = r2;
                        }
                        color = r2.black();
                        r2.black(p2.black());
                        p2.black(color);
                        this.dirPath[i2] = true;
                        this.nodePath[i2++] = r2;
                        break block68;
                    }
                    j2 = i2++;
                    while (true) {
                        this.dirPath[i2] = false;
                        this.nodePath[i2++] = r2;
                        s2 = r2.left;
                        if (s2.pred()) {
                            this.dirPath[j2] = true;
                            this.nodePath[j2] = s2;
                            if (s2.succ()) {
                                break;
                            }
                            break block69;
                        }
                        r2 = s2;
                    }
                    r2.pred(s2);
                    break block74;
                }
                r2.left = s2.right;
            }
            s2.left = p2.left;
            if (!p2.pred()) {
                p2.prev().right = s2;
                s2.pred(false);
            }
            s2.right(p2.right);
            color = s2.black();
            s2.black(p2.black());
            p2.black(color);
            if (j2 == 0) {
                this.tree = s2;
            } else if (this.dirPath[j2 - 1]) {
                this.nodePath[j2 - 1].right = s2;
            } else {
                this.nodePath[j2 - 1].left = s2;
            }
        }
        int maxDepth = i2;
        if (p2.black()) {
            while (i2 > 0) {
                block70: {
                    Entry y2;
                    Entry w2;
                    if (this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].succ() || !this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].pred()) {
                        Entry x2;
                        Entry entry = x2 = this.dirPath[i2 - 1] ? this.nodePath[i2 - 1].right : this.nodePath[i2 - 1].left;
                        if (!x2.black()) {
                            x2.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[i2 - 1]) {
                        w2 = this.nodePath[i2 - 1].right;
                        if (!w2.black()) {
                            w2.black(true);
                            this.nodePath[i2 - 1].black(false);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            this.nodePath[i2] = this.nodePath[i2 - 1];
                            this.dirPath[i2] = false;
                            this.nodePath[i2 - 1] = w2;
                            if (maxDepth == i2++) {
                                ++maxDepth;
                            }
                            w2 = this.nodePath[i2 - 1].right;
                        }
                        if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                            w2.black(false);
                            break block70;
                        } else {
                            if (w2.succ() || w2.right.black()) {
                                y2 = w2.left;
                                y2.black(true);
                                w2.black(false);
                                w2.left = y2.right;
                                y2.right = w2;
                                this.nodePath[i2 - 1].right = y2;
                                w2 = this.nodePath[i2 - 1].right;
                                if (w2.succ()) {
                                    w2.succ(false);
                                    w2.right.pred(w2);
                                }
                            }
                            w2.black(this.nodePath[i2 - 1].black());
                            this.nodePath[i2 - 1].black(true);
                            w2.right.black(true);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            if (!w2.pred()) break;
                            w2.pred(false);
                            this.nodePath[i2 - 1].succ(w2);
                            break;
                        }
                    }
                    w2 = this.nodePath[i2 - 1].left;
                    if (!w2.black()) {
                        w2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        this.nodePath[i2] = this.nodePath[i2 - 1];
                        this.dirPath[i2] = true;
                        this.nodePath[i2 - 1] = w2;
                        if (maxDepth == i2++) {
                            ++maxDepth;
                        }
                        w2 = this.nodePath[i2 - 1].left;
                    }
                    if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                        w2.black(false);
                    } else {
                        if (w2.pred() || w2.left.black()) {
                            y2 = w2.right;
                            y2.black(true);
                            w2.black(false);
                            w2.right = y2.left;
                            y2.left = w2;
                            this.nodePath[i2 - 1].left = y2;
                            w2 = this.nodePath[i2 - 1].left;
                            if (w2.pred()) {
                                w2.pred(false);
                                w2.left.succ(w2);
                            }
                        }
                        w2.black(this.nodePath[i2 - 1].black());
                        this.nodePath[i2 - 1].black(true);
                        w2.left.black(true);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        if (!w2.succ()) break;
                        w2.succ(false);
                        this.nodePath[i2 - 1].pred(w2);
                        break;
                    }
                }
                --i2;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        this.modified = true;
        --this.count;
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return (V)p2.value;
    }

    @Override
    public boolean containsValue(Object v2) {
        ValueIterator i2 = new ValueIterator();
        int j2 = this.count;
        while (j2-- != 0) {
            Object ev = i2.next();
            if (ev != v2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    @Override
    public boolean containsKey(double k2) {
        return this.findKey(k2) != null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public V get(double k2) {
        Entry<V> e2 = this.findKey(k2);
        return (V)(e2 == null ? this.defRetValue : e2.value);
    }

    @Override
    public double firstDoubleKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    @Override
    public double lastDoubleKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    @Override
    public ObjectSortedSet<Double2ReferenceMap.Entry<V>> double2ReferenceEntrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Double2ReferenceMap.Entry<V>>(){
                final Comparator<? super Double2ReferenceMap.Entry<V>> comparator = new Comparator<Double2ReferenceMap.Entry<V>>(){

                    @Override
                    public int compare(Double2ReferenceMap.Entry<V> x2, Double2ReferenceMap.Entry<V> y2) {
                        return Double2ReferenceRBTreeMap.this.actualComparator.compare(x2.getDoubleKey(), y2.getDoubleKey());
                    }
                };

                @Override
                public Comparator<? super Double2ReferenceMap.Entry<V>> comparator() {
                    return this.comparator;
                }

                @Override
                public ObjectBidirectionalIterator<Double2ReferenceMap.Entry<V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public ObjectBidirectionalIterator<Double2ReferenceMap.Entry<V>> iterator(Double2ReferenceMap.Entry<V> from) {
                    return new EntryIterator(from.getDoubleKey());
                }

                @Override
                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)o2;
                    if (e2.getKey() == null || !(e2.getKey() instanceof Double)) {
                        return false;
                    }
                    Entry f2 = Double2ReferenceRBTreeMap.this.findKey((Double)e2.getKey());
                    return e2.equals(f2);
                }

                @Override
                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)o2;
                    if (e2.getKey() == null || !(e2.getKey() instanceof Double)) {
                        return false;
                    }
                    Entry f2 = Double2ReferenceRBTreeMap.this.findKey((Double)e2.getKey());
                    if (f2 != null) {
                        Double2ReferenceRBTreeMap.this.remove(f2.key);
                    }
                    return f2 != null;
                }

                @Override
                public int size() {
                    return Double2ReferenceRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Double2ReferenceRBTreeMap.this.clear();
                }

                @Override
                public Double2ReferenceMap.Entry<V> first() {
                    return Double2ReferenceRBTreeMap.this.firstEntry;
                }

                @Override
                public Double2ReferenceMap.Entry<V> last() {
                    return Double2ReferenceRBTreeMap.this.lastEntry;
                }

                @Override
                public ObjectSortedSet<Double2ReferenceMap.Entry<V>> subSet(Double2ReferenceMap.Entry<V> from, Double2ReferenceMap.Entry<V> to) {
                    return Double2ReferenceRBTreeMap.this.subMap(from.getDoubleKey(), to.getDoubleKey()).double2ReferenceEntrySet();
                }

                @Override
                public ObjectSortedSet<Double2ReferenceMap.Entry<V>> headSet(Double2ReferenceMap.Entry<V> to) {
                    return Double2ReferenceRBTreeMap.this.headMap(to.getDoubleKey()).double2ReferenceEntrySet();
                }

                @Override
                public ObjectSortedSet<Double2ReferenceMap.Entry<V>> tailSet(Double2ReferenceMap.Entry<V> from) {
                    return Double2ReferenceRBTreeMap.this.tailMap(from.getDoubleKey()).double2ReferenceEntrySet();
                }
            };
        }
        return this.entries;
    }

    @Override
    public DoubleSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ReferenceCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public boolean contains(Object k2) {
                    return Double2ReferenceRBTreeMap.this.containsValue(k2);
                }

                @Override
                public int size() {
                    return Double2ReferenceRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Double2ReferenceRBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public DoubleComparator comparator() {
        return this.actualComparator;
    }

    @Override
    public Double2ReferenceSortedMap<V> headMap(double to) {
        return new Submap(0.0, true, to, false);
    }

    @Override
    public Double2ReferenceSortedMap<V> tailMap(double from) {
        return new Submap(from, false, 0.0, true);
    }

    @Override
    public Double2ReferenceSortedMap<V> subMap(double from, double to) {
        return new Submap(from, false, to, false);
    }

    public Double2ReferenceRBTreeMap<V> clone() {
        Double2ReferenceRBTreeMap c2;
        try {
            c2 = (Double2ReferenceRBTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.allocatePaths();
        if (this.count != 0) {
            Entry<V> rp = new Entry<V>();
            Entry rq = new Entry();
            Entry<V> p2 = rp;
            rp.left(this.tree);
            Entry q2 = rq;
            rq.pred(null);
            while (true) {
                Object e2;
                if (!p2.pred()) {
                    e2 = p2.left.clone();
                    ((Entry)e2).pred(q2.left);
                    ((Entry)e2).succ(q2);
                    q2.left(e2);
                    p2 = p2.left;
                    q2 = q2.left;
                } else {
                    while (p2.succ()) {
                        p2 = p2.right;
                        if (p2 == null) {
                            q2.right = null;
                            c2.tree = rq.left;
                            c2.firstEntry = c2.tree;
                            while (c2.firstEntry.left != null) {
                                c2.firstEntry = c2.firstEntry.left;
                            }
                            c2.lastEntry = c2.tree;
                            while (c2.lastEntry.right != null) {
                                c2.lastEntry = c2.lastEntry.right;
                            }
                            return c2;
                        }
                        q2 = q2.right;
                    }
                    p2 = p2.right;
                    q2 = q2.right;
                }
                if (p2.succ()) continue;
                e2 = p2.right.clone();
                ((Entry)e2).succ(q2.right);
                ((Entry)e2).pred(q2);
                q2.right(e2);
            }
        }
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int n2 = this.count;
        EntryIterator i2 = new EntryIterator();
        s2.defaultWriteObject();
        while (n2-- != 0) {
            Entry e2 = i2.nextEntry();
            s2.writeDouble(e2.key);
            s2.writeObject(e2.value);
        }
    }

    private Entry<V> readTree(ObjectInputStream s2, int n2, Entry<V> pred, Entry<V> succ) throws IOException, ClassNotFoundException {
        if (n2 == 1) {
            Entry<Object> top = new Entry<Object>(s2.readDouble(), s2.readObject());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n2 == 2) {
            Entry<Object> top = new Entry<Object>(s2.readDouble(), s2.readObject());
            top.black(true);
            top.right(new Entry<Object>(s2.readDouble(), s2.readObject()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n2 / 2;
        int leftN = n2 - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s2, leftN, pred, top));
        top.key = s2.readDouble();
        top.value = s2.readObject();
        top.black(true);
        top.right(this.readTree(s2, rightN, top, succ));
        if (n2 + 2 == (n2 + 2 & -(n2 + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            this.tree = this.readTree(s2, this.count, null, null);
            Entry<V> e2 = this.tree;
            while (e2.left() != null) {
                e2 = e2.left();
            }
            this.firstEntry = e2;
            e2 = this.tree;
            while (e2.right() != null) {
                e2 = e2.right();
            }
            this.lastEntry = e2;
        }
    }

    private void checkNodePath() {
    }

    private static <V> int checkTree(Entry<V> e2, int d2, int D2) {
        return 0;
    }

    private final class Submap
    extends AbstractDouble2ReferenceSortedMap<V>
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        double from;
        double to;
        boolean bottom;
        boolean top;
        protected transient ObjectSortedSet<Double2ReferenceMap.Entry<V>> entries;
        protected transient DoubleSortedSet keys;
        protected transient ReferenceCollection<V> values;

        public Submap(double from, boolean bottom, double to, boolean top) {
            if (!bottom && !top && Double2ReferenceRBTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Double2ReferenceRBTreeMap.this.defRetValue;
        }

        @Override
        public void clear() {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                i2.nextEntry();
                i2.remove();
            }
        }

        final boolean in(double k2) {
            return !(!this.bottom && Double2ReferenceRBTreeMap.this.compare(k2, this.from) < 0 || !this.top && Double2ReferenceRBTreeMap.this.compare(k2, this.to) >= 0);
        }

        @Override
        public ObjectSortedSet<Double2ReferenceMap.Entry<V>> double2ReferenceEntrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSortedSet<Double2ReferenceMap.Entry<V>>(){

                    @Override
                    public ObjectBidirectionalIterator<Double2ReferenceMap.Entry<V>> iterator() {
                        return new SubmapEntryIterator();
                    }

                    @Override
                    public ObjectBidirectionalIterator<Double2ReferenceMap.Entry<V>> iterator(Double2ReferenceMap.Entry<V> from) {
                        return new SubmapEntryIterator(from.getDoubleKey());
                    }

                    @Override
                    public Comparator<? super Double2ReferenceMap.Entry<V>> comparator() {
                        return Double2ReferenceRBTreeMap.this.double2ReferenceEntrySet().comparator();
                    }

                    @Override
                    public boolean contains(Object o2) {
                        if (!(o2 instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e2 = (Map.Entry)o2;
                        if (e2.getKey() == null || !(e2.getKey() instanceof Double)) {
                            return false;
                        }
                        Entry f2 = Double2ReferenceRBTreeMap.this.findKey((Double)e2.getKey());
                        return f2 != null && Submap.this.in(f2.key) && e2.equals(f2);
                    }

                    @Override
                    public boolean remove(Object o2) {
                        if (!(o2 instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e2 = (Map.Entry)o2;
                        if (e2.getKey() == null || !(e2.getKey() instanceof Double)) {
                            return false;
                        }
                        Entry f2 = Double2ReferenceRBTreeMap.this.findKey((Double)e2.getKey());
                        if (f2 != null && Submap.this.in(f2.key)) {
                            Submap.this.remove(f2.key);
                        }
                        return f2 != null;
                    }

                    @Override
                    public int size() {
                        int c2 = 0;
                        ObjectIterator i2 = this.iterator();
                        while (i2.hasNext()) {
                            ++c2;
                            i2.next();
                        }
                        return c2;
                    }

                    @Override
                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }

                    @Override
                    public Double2ReferenceMap.Entry<V> first() {
                        return Submap.this.firstEntry();
                    }

                    @Override
                    public Double2ReferenceMap.Entry<V> last() {
                        return Submap.this.lastEntry();
                    }

                    @Override
                    public ObjectSortedSet<Double2ReferenceMap.Entry<V>> subSet(Double2ReferenceMap.Entry<V> from, Double2ReferenceMap.Entry<V> to) {
                        return Submap.this.subMap(from.getDoubleKey(), to.getDoubleKey()).double2ReferenceEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Double2ReferenceMap.Entry<V>> headSet(Double2ReferenceMap.Entry<V> to) {
                        return Submap.this.headMap(to.getDoubleKey()).double2ReferenceEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Double2ReferenceMap.Entry<V>> tailSet(Double2ReferenceMap.Entry<V> from) {
                        return Submap.this.tailMap(from.getDoubleKey()).double2ReferenceEntrySet();
                    }
                };
            }
            return this.entries;
        }

        @Override
        public DoubleSortedSet keySet() {
            if (this.keys == null) {
                this.keys = new KeySet();
            }
            return this.keys;
        }

        @Override
        public ReferenceCollection<V> values() {
            if (this.values == null) {
                this.values = new AbstractReferenceCollection<V>(){

                    @Override
                    public ObjectIterator<V> iterator() {
                        return new SubmapValueIterator();
                    }

                    @Override
                    public boolean contains(Object k2) {
                        return Submap.this.containsValue(k2);
                    }

                    @Override
                    public int size() {
                        return Submap.this.size();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        @Override
        public boolean containsKey(double k2) {
            return this.in(k2) && Double2ReferenceRBTreeMap.this.containsKey(k2);
        }

        @Override
        public boolean containsValue(Object v2) {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                Object ev = i2.nextEntry().value;
                if (ev != v2) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(double k2) {
            Entry e2;
            double kk = k2;
            return this.in(kk) && (e2 = Double2ReferenceRBTreeMap.this.findKey(kk)) != null ? e2.value : this.defRetValue;
        }

        @Override
        public V put(double k2, V v2) {
            Double2ReferenceRBTreeMap.this.modified = false;
            if (!this.in(k2)) {
                throw new IllegalArgumentException("Key (" + k2 + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            Object oldValue = Double2ReferenceRBTreeMap.this.put(k2, v2);
            return Double2ReferenceRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        @Override
        public V remove(double k2) {
            Double2ReferenceRBTreeMap.this.modified = false;
            if (!this.in(k2)) {
                return this.defRetValue;
            }
            Object oldValue = Double2ReferenceRBTreeMap.this.remove(k2);
            return Double2ReferenceRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        @Override
        public int size() {
            SubmapIterator i2 = new SubmapIterator();
            int n2 = 0;
            while (i2.hasNext()) {
                ++n2;
                i2.nextEntry();
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        @Override
        public DoubleComparator comparator() {
            return Double2ReferenceRBTreeMap.this.actualComparator;
        }

        @Override
        public Double2ReferenceSortedMap<V> headMap(double to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Double2ReferenceRBTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        @Override
        public Double2ReferenceSortedMap<V> tailMap(double from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Double2ReferenceRBTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        @Override
        public Double2ReferenceSortedMap<V> subMap(double from, double to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                double d2 = to = Double2ReferenceRBTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                double d3 = from = Double2ReferenceRBTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry<V> firstEntry() {
            Entry e2;
            if (Double2ReferenceRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e2 = Double2ReferenceRBTreeMap.this.firstEntry;
            } else {
                e2 = Double2ReferenceRBTreeMap.this.locateKey(this.from);
                if (Double2ReferenceRBTreeMap.this.compare(e2.key, this.from) < 0) {
                    e2 = e2.next();
                }
            }
            if (e2 == null || !this.top && Double2ReferenceRBTreeMap.this.compare(e2.key, this.to) >= 0) {
                return null;
            }
            return e2;
        }

        public Entry<V> lastEntry() {
            Entry e2;
            if (Double2ReferenceRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e2 = Double2ReferenceRBTreeMap.this.lastEntry;
            } else {
                e2 = Double2ReferenceRBTreeMap.this.locateKey(this.to);
                if (Double2ReferenceRBTreeMap.this.compare(e2.key, this.to) >= 0) {
                    e2 = e2.prev();
                }
            }
            if (e2 == null || !this.bottom && Double2ReferenceRBTreeMap.this.compare(e2.key, this.from) < 0) {
                return null;
            }
            return e2;
        }

        @Override
        public double firstDoubleKey() {
            Entry e2 = this.firstEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        @Override
        public double lastDoubleKey() {
            Entry e2 = this.lastEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        /*
         * Signature claims super is it.unimi.dsi.fastutil.doubles.Double2ReferenceRBTreeMap$Submap.SubmapIterator, not it.unimi.dsi.fastutil.doubles.Double2ReferenceRBTreeMap$Submap$SubmapIterator - discarding signature.
         */
        private final class SubmapValueIterator
        extends SubmapIterator
        implements ObjectListIterator {
            private SubmapValueIterator() {
            }

            @Override
            public V next() {
                return this.nextEntry().value;
            }

            @Override
            public V previous() {
                return this.previousEntry().value;
            }

            @Override
            public void set(V v2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(V v2) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * Signature claims super is it.unimi.dsi.fastutil.doubles.Double2ReferenceRBTreeMap$Submap.SubmapIterator, not it.unimi.dsi.fastutil.doubles.Double2ReferenceRBTreeMap$Submap$SubmapIterator - discarding signature.
         */
        private final class SubmapKeyIterator
        extends SubmapIterator
        implements DoubleListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(double from) {
                super(from);
            }

            @Override
            public double nextDouble() {
                return this.nextEntry().key;
            }

            @Override
            public double previousDouble() {
                return this.previousEntry().key;
            }

            @Override
            public void set(double k2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(double k2) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public Double next() {
                return this.nextEntry().key;
            }

            @Override
            @Deprecated
            public Double previous() {
                return this.previousEntry().key;
            }

            @Override
            @Deprecated
            public void set(Double ok) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public void add(Double ok) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * Signature claims super is it.unimi.dsi.fastutil.doubles.Double2ReferenceRBTreeMap$Submap.SubmapIterator, not it.unimi.dsi.fastutil.doubles.Double2ReferenceRBTreeMap$Submap$SubmapIterator - discarding signature.
         */
        private class SubmapEntryIterator
        extends SubmapIterator
        implements ObjectListIterator {
            SubmapEntryIterator() {
            }

            SubmapEntryIterator(double k2) {
                super(k2);
            }

            @Override
            public Double2ReferenceMap.Entry<V> next() {
                return this.nextEntry();
            }

            @Override
            public Double2ReferenceMap.Entry<V> previous() {
                return this.previousEntry();
            }

            @Override
            public void set(Double2ReferenceMap.Entry<V> ok) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Double2ReferenceMap.Entry<V> ok) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(double k2) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Double2ReferenceRBTreeMap.this.compare(k2, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Double2ReferenceRBTreeMap.this.compare(k2, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Double2ReferenceRBTreeMap.this.locateKey(k2);
                if (submap.Double2ReferenceRBTreeMap.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            @Override
            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Double2ReferenceRBTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            @Override
            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Double2ReferenceRBTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }

        private class KeySet
        extends AbstractDouble2ReferenceSortedMap.KeySet {
            private KeySet() {
            }

            @Override
            public DoubleBidirectionalIterator iterator() {
                return new SubmapKeyIterator();
            }

            @Override
            public DoubleBidirectionalIterator iterator(double from) {
                return new SubmapKeyIterator(from);
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements ObjectListIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }

        @Override
        public V previous() {
            return this.previousEntry().value;
        }

        @Override
        public void set(V v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(V v2) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractDouble2ReferenceSortedMap.KeySet {
        private KeySet() {
        }

        @Override
        public DoubleBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public DoubleBidirectionalIterator iterator(double from) {
            return new KeyIterator(from);
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements DoubleListIterator {
        public KeyIterator() {
        }

        public KeyIterator(double k2) {
            super(k2);
        }

        @Override
        public double nextDouble() {
            return this.nextEntry().key;
        }

        @Override
        public double previousDouble() {
            return this.previousEntry().key;
        }

        @Override
        public void set(double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double next() {
            return this.nextEntry().key;
        }

        @Override
        @Deprecated
        public Double previous() {
            return this.previousEntry().key;
        }

        @Override
        @Deprecated
        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends TreeIterator
    implements ObjectListIterator<Double2ReferenceMap.Entry<V>> {
        EntryIterator() {
        }

        EntryIterator(double k2) {
            super(k2);
        }

        @Override
        public Double2ReferenceMap.Entry<V> next() {
            return this.nextEntry();
        }

        @Override
        public Double2ReferenceMap.Entry<V> previous() {
            return this.previousEntry();
        }

        @Override
        public void set(Double2ReferenceMap.Entry<V> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2ReferenceMap.Entry<V> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator {
        Entry<V> prev;
        Entry<V> next;
        Entry<V> curr;
        int index = 0;

        TreeIterator() {
            this.next = Double2ReferenceRBTreeMap.this.firstEntry;
        }

        TreeIterator(double k2) {
            this.next = Double2ReferenceRBTreeMap.this.locateKey(k2);
            if (this.next != null) {
                if (Double2ReferenceRBTreeMap.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry<V> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.curr = this.prev;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry<V> previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.prev;
            this.curr = this.next;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.prev = this.curr;
            this.next = this.prev;
            this.updatePrevious();
            this.updateNext();
            Double2ReferenceRBTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }

        public int back(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n2 - i2 - 1;
        }
    }

    private static final class Entry<V>
    extends AbstractDouble2ReferenceMap.BasicEntry<V>
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        Entry<V> left;
        Entry<V> right;
        int info;

        Entry() {
            super(0.0, null);
        }

        Entry(double k2, V v2) {
            super(k2, v2);
            this.info = -1073741824;
        }

        Entry<V> left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry<V> right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry<V> pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry<V> succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry<V> left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry<V> right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry<V> next() {
            Entry<V> next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry<V> prev() {
            Entry<V> prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            this.value = value;
            return (V)oldValue;
        }

        public Entry<V> clone() {
            Entry c2;
            try {
                c2 = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c2.key = this.key;
            c2.value = this.value;
            c2.info = this.info;
            return c2;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)e2.getKey()) && this.value == e2.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ (this.value == null ? 0 : System.identityHashCode(this.value));
        }

        @Override
        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

