/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollections;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;

public class DoubleLists {
    public static final EmptyList EMPTY_LIST = new EmptyList();

    private DoubleLists() {
    }

    public static DoubleList shuffle(DoubleList l2, Random random) {
        int i2 = l2.size();
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            double t2 = l2.getDouble(i2);
            l2.set(i2, l2.getDouble(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static DoubleList singleton(double element) {
        return new Singleton(element);
    }

    public static DoubleList singleton(Object element) {
        return new Singleton((Double)element);
    }

    public static DoubleList synchronize(DoubleList l2) {
        return l2 instanceof RandomAccess ? new SynchronizedRandomAccessList(l2) : new SynchronizedList(l2);
    }

    public static DoubleList synchronize(DoubleList l2, Object sync) {
        return l2 instanceof RandomAccess ? new SynchronizedRandomAccessList(l2, sync) : new SynchronizedList(l2, sync);
    }

    public static DoubleList unmodifiable(DoubleList l2) {
        return l2 instanceof RandomAccess ? new UnmodifiableRandomAccessList(l2) : new UnmodifiableList(l2);
    }

    public static class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected UnmodifiableRandomAccessList(DoubleList l2) {
            super(l2);
        }

        @Override
        public DoubleList subList(int from, int to) {
            return new UnmodifiableRandomAccessList(this.list.subList(from, to));
        }
    }

    public static class UnmodifiableList
    extends DoubleCollections.UnmodifiableCollection
    implements DoubleList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList list;

        protected UnmodifiableList(DoubleList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public double getDouble(int i2) {
            return this.list.getDouble(i2);
        }

        @Override
        public double set(int i2, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i2, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(double k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public int lastIndexOf(double k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(int from, double[] a2, int offset, int length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, double[] a2, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, double[] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(int size) {
            this.list.size(size);
        }

        @Override
        public DoubleListIterator listIterator() {
            return DoubleIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public DoubleListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public DoubleListIterator listIterator(int i2) {
            return DoubleIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        @Deprecated
        public DoubleListIterator doubleListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public DoubleListIterator doubleListIterator(int i2) {
            return this.listIterator(i2);
        }

        @Override
        public DoubleList subList(int from, int to) {
            return new UnmodifiableList(this.list.subList(from, to));
        }

        @Override
        @Deprecated
        public DoubleList doubleSubList(int from, int to) {
            return this.subList(from, to);
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public int compareTo(List<? extends Double> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(int index, DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, DoubleList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double get(int i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(int i2, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double set(int index, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public int indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public int lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected SynchronizedRandomAccessList(DoubleList l2, Object sync) {
            super(l2, sync);
        }

        protected SynchronizedRandomAccessList(DoubleList l2) {
            super(l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DoubleList subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(from, to), this.sync);
            }
        }
    }

    public static class SynchronizedList
    extends DoubleCollections.SynchronizedCollection
    implements DoubleList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList list;

        protected SynchronizedList(DoubleList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedList(DoubleList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getDouble(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getDouble(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double set(int i2, double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int i2, double k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double removeDouble(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeDouble(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends Double> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(int from, double[] a2, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int index, double[] a2, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int index, double[] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        @Override
        public DoubleListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public DoubleListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public DoubleListIterator listIterator(int i2) {
            return this.list.listIterator(i2);
        }

        @Override
        @Deprecated
        public DoubleListIterator doubleListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public DoubleListIterator doubleListIterator(int i2) {
            return this.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DoubleList subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.subList(from, to), this.sync);
            }
        }

        @Override
        @Deprecated
        public DoubleList doubleSubList(int from, int to) {
            return this.subList(from, to);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(List<? extends Double> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, DoubleCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, DoubleList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(DoubleList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double get(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(int i2, Double k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double set(int index, Double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double remove(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public int indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public int lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s2) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s2.defaultWriteObject();
            }
        }
    }

    public static class Singleton
    extends AbstractDoubleList
    implements RandomAccess,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final double element;

        private Singleton(double element) {
            this.element = element;
        }

        @Override
        public double getDouble(int i2) {
            if (i2 == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(double k2) {
            return Double.doubleToLongBits(k2) == Double.doubleToLongBits(this.element);
        }

        @Override
        public double[] toDoubleArray() {
            double[] a2 = new double[]{this.element};
            return a2;
        }

        @Override
        public DoubleListIterator listIterator() {
            return DoubleIterators.singleton(this.element);
        }

        @Override
        public DoubleListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public DoubleListIterator listIterator(int i2) {
            if (i2 > 1 || i2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            DoubleListIterator l2 = this.listIterator();
            if (i2 == 1) {
                l2.next();
            }
            return l2;
        }

        @Override
        public DoubleList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return EMPTY_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, DoubleList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyList
    extends DoubleCollections.EmptyCollection
    implements DoubleList,
    RandomAccess,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyList() {
        }

        @Override
        public double getDouble(int i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double set(int index, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(double k2) {
            return -1;
        }

        @Override
        public int lastIndexOf(double k2) {
            return -1;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, DoubleList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(int index, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double set(int index, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove(int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public int indexOf(Object k2) {
            return -1;
        }

        @Override
        @Deprecated
        public int lastIndexOf(Object k2) {
            return -1;
        }

        @Override
        public DoubleListIterator listIterator() {
            return DoubleIterators.EMPTY_ITERATOR;
        }

        @Override
        public DoubleListIterator iterator() {
            return DoubleIterators.EMPTY_ITERATOR;
        }

        @Override
        public DoubleListIterator listIterator(int i2) {
            if (i2 == 0) {
                return DoubleIterators.EMPTY_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        @Deprecated
        public DoubleListIterator doubleListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public DoubleListIterator doubleListIterator(int i2) {
            return this.listIterator(i2);
        }

        @Override
        public DoubleList subList(int from, int to) {
            if (from == 0 && to == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public DoubleList doubleSubList(int from, int to) {
            return this.subList(from, to);
        }

        @Override
        public void getElements(int from, double[] a2, int offset, int length) {
            if (from == 0 && length == 0 && offset >= 0 && offset <= a2.length) {
                return;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, double[] a2, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, double[] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(int s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(List<? extends Double> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof List && ((List)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }
}

