/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.ints.AbstractIntBigList;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntBigList;
import it.unimi.dsi.fastutil.ints.IntBigListIterator;
import it.unimi.dsi.fastutil.ints.IntBigListIterators;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntCollections;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public class IntBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private IntBigLists() {
    }

    public static IntBigList shuffle(IntBigList l2, Random random) {
        long i2 = l2.size64();
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            int t2 = l2.getInt(i2);
            l2.set(i2, l2.getInt(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static IntBigList singleton(int element) {
        return new Singleton(element);
    }

    public static IntBigList singleton(Object element) {
        return new Singleton((Integer)element);
    }

    public static IntBigList synchronize(IntBigList l2) {
        return new SynchronizedBigList(l2);
    }

    public static IntBigList synchronize(IntBigList l2, Object sync) {
        return new SynchronizedBigList(l2, sync);
    }

    public static IntBigList unmodifiable(IntBigList l2) {
        return new UnmodifiableBigList(l2);
    }

    public static IntBigList asBigList(IntList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractIntBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final IntList list;

        protected ListBigList(IntList list) {
            this.list = list;
        }

        private int intIndex(long index) {
            if (index >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size) {
            this.list.size(this.intIndex(size));
        }

        @Override
        public IntBigListIterator iterator() {
            return IntBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public IntBigListIterator listIterator() {
            return IntBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public IntBigListIterator listIterator(long index) {
            return IntBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index)));
        }

        @Override
        public boolean addAll(long index, Collection<? extends Integer> c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public IntBigList subList(long from, long to) {
            return new ListBigList(this.list.subList(this.intIndex(from), this.intIndex(to)));
        }

        @Override
        public boolean contains(int key) {
            return this.list.contains(key);
        }

        @Override
        public int[] toIntArray() {
            return this.list.toIntArray();
        }

        @Override
        public void removeElements(long from, long to) {
            this.list.removeElements(this.intIndex(from), this.intIndex(to));
        }

        @Override
        @Deprecated
        public int[] toIntArray(int[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean addAll(long index, IntCollection c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(IntCollection c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean addAll(long index, IntBigList c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(IntBigList c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean containsAll(IntCollection c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean removeAll(IntCollection c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(IntCollection c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void add(long index, int key) {
            this.list.add(this.intIndex(index), key);
        }

        @Override
        public boolean add(int key) {
            return this.list.add(key);
        }

        @Override
        public int getInt(long index) {
            return this.list.getInt(this.intIndex(index));
        }

        @Override
        public long indexOf(int k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(int k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public int removeInt(long index) {
            return this.list.removeInt(this.intIndex(index));
        }

        @Override
        public int set(long index, int k2) {
            return this.list.set(this.intIndex(index), k2);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends IntCollections.UnmodifiableCollection
    implements IntBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final IntBigList list;

        protected UnmodifiableBigList(IntBigList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public int getInt(long i2) {
            return this.list.getInt(i2);
        }

        @Override
        public int set(long i2, int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i2, int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeInt(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(int k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(int k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(long index, Collection<? extends Integer> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from, int[][] a2, long offset, long length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, int[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, int[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size) {
            this.list.size(size);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public IntBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public IntBigListIterator listIterator() {
            return IntBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public IntBigListIterator listIterator(long i2) {
            return IntBigListIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        public IntBigList subList(long from, long to) {
            return IntBigLists.unmodifiable(this.list.subList(from, to));
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.list.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Integer> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(long index, IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(IntBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index, IntBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Integer get(long i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(long i2, Integer k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Integer set(long index, Integer k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Integer remove(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedBigList
    extends IntCollections.SynchronizedCollection
    implements IntBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final IntBigList list;

        protected SynchronizedBigList(IntBigList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedBigList(IntBigList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInt(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getInt(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int set(long i2, int k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i2, int k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int removeInt(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeInt(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(int k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(int k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, Collection<? extends Integer> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from, int[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, int[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, int[][] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public IntBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public IntBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public IntBigListIterator listIterator(long i2) {
            return this.list.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IntBigList subList(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                return IntBigLists.synchronize(this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Integer> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, IntCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, IntBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(IntBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i2, Integer k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Integer get(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Integer set(long index, Integer k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Integer remove(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }
    }

    public static class Singleton
    extends AbstractIntBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final int element;

        private Singleton(int element) {
            this.element = element;
        }

        @Override
        public int getInt(long i2) {
            if (i2 == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeInt(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(int k2) {
            return k2 == this.element;
        }

        @Override
        public int[] toIntArray() {
            int[] a2 = new int[]{this.element};
            return a2;
        }

        @Override
        public IntBigListIterator listIterator() {
            return IntBigListIterators.singleton(this.element);
        }

        @Override
        public IntBigListIterator listIterator(long i2) {
            if (i2 > 1L || i2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            IntBigListIterator l2 = this.listIterator();
            if (i2 == 1L) {
                l2.nextInt();
            }
            return l2;
        }

        @Override
        public IntBigList subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0L || to != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Integer> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(IntBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, IntBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends IntCollections.EmptyCollection
    implements IntBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public int getInt(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeInt(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index, int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int set(long index, int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(int k2) {
            return -1L;
        }

        @Override
        public long lastIndexOf(int k2) {
            return -1L;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Integer> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(IntBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, IntCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, IntBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index, Integer k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Integer k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Integer get(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Integer set(long index, Integer k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Integer remove(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k2) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k2) {
            return -1L;
        }

        @Override
        public IntBigListIterator listIterator() {
            return IntBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public IntBigListIterator iterator() {
            return IntBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public IntBigListIterator listIterator(long i2) {
            if (i2 == 0L) {
                return IntBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        public IntBigList subList(long from, long to) {
            if (from == 0L && to == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from, int[][] a2, long offset, long length) {
            IntBigArrays.ensureOffsetLength(a2, offset, length);
            if (from != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, int[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, int[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Integer> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof BigList && ((BigList)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

