/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Arrays;

public class IntIndirectHeaps {
    private IntIndirectHeaps() {
    }

    public static int downHeap(int[] refArray, int[] heap, int[] inv, int size, int i2, IntComparator c2) {
        assert (i2 < size);
        int e2 = heap[i2];
        int E2 = refArray[e2];
        if (c2 == null) {
            int child;
            while ((child = (i2 << 1) + 1) < size) {
                int t2 = heap[child];
                int right = child + 1;
                if (right < size && refArray[heap[right]] < refArray[t2]) {
                    child = right;
                    t2 = heap[child];
                }
                if (E2 > refArray[t2]) {
                    heap[i2] = t2;
                    inv[heap[i2]] = i2;
                    i2 = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i2 << 1) + 1) < size) {
                int t3 = heap[child];
                int right = child + 1;
                if (right < size && c2.compare(refArray[heap[right]], refArray[t3]) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c2.compare(E2, refArray[t3]) > 0) {
                    heap[i2] = t3;
                    inv[heap[i2]] = i2;
                    i2 = child;
                    continue;
                }
                break;
            }
        }
        heap[i2] = e2;
        inv[e2] = i2;
        return i2;
    }

    public static int upHeap(int[] refArray, int[] heap, int[] inv, int size, int i2, IntComparator c2) {
        assert (i2 < size);
        int e2 = heap[i2];
        int E2 = refArray[e2];
        if (c2 == null) {
            int parent;
            int t2;
            while (i2 != 0 && refArray[t2 = heap[parent = i2 - 1 >>> 1]] > E2) {
                heap[i2] = t2;
                inv[heap[i2]] = i2;
                i2 = parent;
            }
        } else {
            int parent;
            int t3;
            while (i2 != 0 && c2.compare(refArray[t3 = heap[parent = i2 - 1 >>> 1]], E2) > 0) {
                heap[i2] = t3;
                inv[heap[i2]] = i2;
                i2 = parent;
            }
        }
        heap[i2] = e2;
        inv[e2] = i2;
        return i2;
    }

    public static void makeHeap(int[] refArray, int offset, int length, int[] heap, int[] inv, IntComparator c2) {
        IntArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        if (inv.length < refArray.length) {
            throw new IllegalArgumentException("The inversion array length (" + heap.length + ") is smaller than the length of the reference array (" + refArray.length + ")");
        }
        Arrays.fill(inv, 0, refArray.length, -1);
        int i2 = length;
        while (i2-- != 0) {
            heap[i2] = offset + i2;
            inv[heap[i2]] = i2;
        }
        i2 = length >>> 1;
        while (i2-- != 0) {
            IntIndirectHeaps.downHeap(refArray, heap, inv, length, i2, c2);
        }
    }

    public static void makeHeap(int[] refArray, int[] heap, int[] inv, int size, IntComparator c2) {
        int i2 = size >>> 1;
        while (i2-- != 0) {
            IntIndirectHeaps.downHeap(refArray, heap, inv, size, i2, c2);
        }
    }
}

