/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class ReferenceCollections {
    private ReferenceCollections() {
    }

    public static <K> ReferenceCollection<K> synchronize(ReferenceCollection<K> c2) {
        return new SynchronizedCollection<K>(c2);
    }

    public static <K> ReferenceCollection<K> synchronize(ReferenceCollection<K> c2, Object sync) {
        return new SynchronizedCollection<K>(c2, sync);
    }

    public static <K> ReferenceCollection<K> unmodifiable(ReferenceCollection<K> c2) {
        return new UnmodifiableCollection<K>(c2);
    }

    public static <K> ReferenceCollection<K> asCollection(ObjectIterable<K> iterable) {
        if (iterable instanceof ReferenceCollection) {
            return (ReferenceCollection)iterable;
        }
        return new IterableCollection<K>(iterable);
    }

    public static class IterableCollection<K>
    extends AbstractReferenceCollection<K>
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ObjectIterable<K> iterable;

        protected IterableCollection(ObjectIterable<K> iterable) {
            if (iterable == null) {
                throw new NullPointerException();
            }
            this.iterable = iterable;
        }

        @Override
        public int size() {
            int c2 = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++c2;
            }
            return c2;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterable.iterator().hasNext();
        }

        @Override
        public ObjectIterator<K> iterator() {
            return this.iterable.iterator();
        }
    }

    public static class UnmodifiableCollection<K>
    implements ReferenceCollection<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceCollection<K> collection;

        protected UnmodifiableCollection(ReferenceCollection<K> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            this.collection = c2;
        }

        @Override
        public boolean add(K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return this.collection.contains(o2);
        }

        @Override
        public ObjectIterator<K> iterator() {
            return ObjectIterators.unmodifiable(this.collection.iterator());
        }

        @Override
        @Deprecated
        public ObjectIterator<K> objectIterator() {
            return this.iterator();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.collection.toArray(a2);
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.collection.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.collection.toString();
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }
    }

    public static class SynchronizedCollection<K>
    implements ReferenceCollection<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceCollection<K> collection;
        protected final Object sync;

        protected SynchronizedCollection(ReferenceCollection<K> c2, Object sync) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            this.collection = c2;
            this.sync = sync;
        }

        protected SynchronizedCollection(ReferenceCollection<K> c2) {
            if (c2 == null) {
                throw new NullPointerException();
            }
            this.collection = c2;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(K k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.add(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.contains(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.remove(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray(a2);
            }
        }

        @Override
        public ObjectIterator<K> iterator() {
            return this.collection.iterator();
        }

        @Override
        @Deprecated
        public ObjectIterator<K> objectIterator() {
            return this.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends K> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.collection.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s2) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s2.defaultWriteObject();
            }
        }
    }

    public static abstract class EmptyCollection<K>
    extends AbstractReferenceCollection<K> {
        protected EmptyCollection() {
        }

        @Override
        public boolean contains(Object k2) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator() {
            return ObjectIterators.EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof Collection)) {
                return false;
            }
            return ((Collection)o2).isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }
    }
}

