/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortPriorityQueue;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortHeaps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ShortHeapPriorityQueue
extends AbstractShortPriorityQueue
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient short[] heap = ShortArrays.EMPTY_ARRAY;
    protected int size;
    protected ShortComparator c;

    public ShortHeapPriorityQueue(int capacity, ShortComparator c2) {
        if (capacity > 0) {
            this.heap = new short[capacity];
        }
        this.c = c2;
    }

    public ShortHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ShortHeapPriorityQueue(ShortComparator c2) {
        this(0, c2);
    }

    public ShortHeapPriorityQueue() {
        this(0, null);
    }

    public ShortHeapPriorityQueue(short[] a2, int size, ShortComparator c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        ShortHeaps.makeHeap(a2, size, c2);
    }

    public ShortHeapPriorityQueue(short[] a2, ShortComparator c2) {
        this(a2, a2.length, c2);
    }

    public ShortHeapPriorityQueue(short[] a2, int size) {
        this(a2, size, null);
    }

    public ShortHeapPriorityQueue(short[] a2) {
        this(a2, a2.length);
    }

    public ShortHeapPriorityQueue(ShortCollection collection, ShortComparator c2) {
        this(collection.toShortArray(), c2);
    }

    public ShortHeapPriorityQueue(ShortCollection collection) {
        this(collection, (ShortComparator)null);
    }

    public ShortHeapPriorityQueue(Collection<? extends Short> collection, ShortComparator c2) {
        this(collection.size(), c2);
        Iterator<? extends Short> iterator = collection.iterator();
        int size = collection.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.heap[i2] = iterator.next();
        }
    }

    public ShortHeapPriorityQueue(Collection<? extends Short> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(short x2) {
        if (this.size == this.heap.length) {
            this.heap = ShortArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        ShortHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public short dequeueShort() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        short result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            ShortHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public short firstShort() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        ShortHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = ShortArrays.trim(this.heap, this.size);
    }

    @Override
    public ShortComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeShort(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new short[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readShort();
        }
    }
}

