/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();

    public BaseMpscLinkedAtomicArrayQueue(int initialCapacity) {
        AtomicReferenceArray buffer;
        RangeUtil.checkGreaterThanOrEqual(initialCapacity, 2, "initialCapacity");
        int p2capacity = Pow2.roundToPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1 << 1;
        this.producerBuffer = buffer = LinkedAtomicArrayQueueUtil.allocate(p2capacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.soProducerLimit(mask);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        long size = currentProducerIndex - after >> 1;
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e2) {
        AtomicReferenceArray buffer;
        long mask;
        long pIndex;
        if (null == e2) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit <= pIndex) {
                int result = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e2);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, pIndex + 2L)) break;
        }
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex, mask);
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, e2);
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index, mask);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e2 == null) {
            if (index != this.lvProducerIndex()) {
                while ((e2 = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e2 == JUMP) {
            AtomicReferenceArray<E> nextBuffer = this.getNextBuffer(buffer, mask);
            return this.newBufferPoll(nextBuffer, index);
        }
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return e2;
    }

    @Override
    public E peek() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index, mask);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e2 == null && index != this.lvProducerIndex()) {
            while ((e2 = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset)) == null) {
            }
        }
        if (e2 == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(buffer, mask), index);
        }
        return e2;
    }

    private int offerSlowPath(long mask, long pIndex, long producerLimit) {
        long cIndex = this.lvConsumerIndex();
        long bufferCapacity = this.getCurrentBufferCapacity(mask);
        int result = 0;
        if (cIndex + bufferCapacity > pIndex) {
            if (!this.casProducerLimit(producerLimit, cIndex + bufferCapacity)) {
                result = 1;
            }
        } else {
            result = this.availableInQueue(pIndex, cIndex) <= 0L ? 2 : (this.casProducerIndex(pIndex, pIndex + 1L) ? 3 : 1);
        }
        return result;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> getNextBuffer(AtomicReferenceArray<E> buffer, long mask) {
        int offset = this.nextArrayOffset(mask);
        AtomicReferenceArray nextBuffer = (AtomicReferenceArray)LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
        return nextBuffer;
    }

    private int nextArrayOffset(long mask) {
        return LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> nextBuffer, long index) {
        int offset = this.newBufferAndOffset(nextBuffer, index);
        E n2 = LinkedAtomicArrayQueueUtil.lvElement(nextBuffer, offset);
        if (n2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        LinkedAtomicArrayQueueUtil.soElement(nextBuffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return n2;
    }

    private E newBufferPeek(AtomicReferenceArray<E> nextBuffer, long index) {
        int offset = this.newBufferAndOffset(nextBuffer, index);
        E n2 = LinkedAtomicArrayQueueUtil.lvElement(nextBuffer, offset);
        if (null == n2) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return n2;
    }

    private int newBufferAndOffset(AtomicReferenceArray<E> nextBuffer, long index) {
        this.consumerBuffer = nextBuffer;
        this.consumerMask = LinkedAtomicArrayQueueUtil.length(nextBuffer) - 2 << 1;
        int offsetInNew = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index, this.consumerMask);
        return offsetInNew;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index, mask);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e2 == null) {
            return null;
        }
        if (e2 == JUMP) {
            AtomicReferenceArray<E> nextBuffer = this.getNextBuffer(buffer, mask);
            return this.newBufferPoll(nextBuffer, index);
        }
        LinkedAtomicArrayQueueUtil.soElement(buffer, offset, null);
        this.soConsumerIndex(index + 2L);
        return e2;
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray buffer = this.consumerBuffer;
        long index = this.consumerIndex;
        long mask = this.consumerMask;
        int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(index, mask);
        Object e2 = LinkedAtomicArrayQueueUtil.lvElement(buffer, offset);
        if (e2 == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(buffer, mask), index);
        }
        return e2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int batchSize) {
        long batchIndex;
        AtomicReferenceArray buffer;
        long mask;
        long pIndex;
        block5: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            batchIndex = Math.min(producerLimit, pIndex + (long)(2 * batchSize));
            if (pIndex == producerLimit || producerLimit < batchIndex) {
                int result = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (result) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, s2.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, batchIndex)) break;
        }
        int claimedSlots = (int)((batchIndex - pIndex) / 2L);
        int i2 = 0;
        for (i2 = 0; i2 < claimedSlots; ++i2) {
            int offset = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex + (long)(2 * i2), mask);
            LinkedAtomicArrayQueueUtil.soElement(buffer, offset, s2.get());
        }
        return claimedSlots;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy w2, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            while (this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0 && exit.keepRunning()) {
            }
            int idleCounter = 0;
            while (exit.keepRunning() && this.fill(s2, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = w2.idle(idleCounter);
            }
        }
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c2) {
        return this.drain(c2, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c2, int limit) {
        E m2;
        int i2;
        for (i2 = 0; i2 < limit && (m2 = this.relaxedPoll()) != null; ++i2) {
            c2.accept(m2);
        }
        return i2;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c2, MessagePassingQueue.WaitStrategy w2, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e2 = this.relaxedPoll();
            if (e2 == null) {
                idleCounter = w2.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c2.accept(e2);
        }
    }

    private void resize(long oldMask, AtomicReferenceArray<E> oldBuffer, long pIndex, E e2) {
        AtomicReferenceArray newBuffer;
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        this.producerBuffer = newBuffer = LinkedAtomicArrayQueueUtil.allocate(newBufferLength);
        int newMask = newBufferLength - 2 << 1;
        this.producerMask = newMask;
        int offsetInOld = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex, oldMask);
        int offsetInNew = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(pIndex, newMask);
        LinkedAtomicArrayQueueUtil.soElement(newBuffer, offsetInNew, e2);
        LinkedAtomicArrayQueueUtil.soElement(oldBuffer, this.nextArrayOffset(oldMask), newBuffer);
        long cIndex = this.lvConsumerIndex();
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        RangeUtil.checkPositive(availableInQueue, "availableInQueue");
        this.soProducerLimit(pIndex + Math.min((long)newMask, availableInQueue));
        this.soProducerIndex(pIndex + 2L);
        LinkedAtomicArrayQueueUtil.soElement(oldBuffer, offsetInOld, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

