/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CharArrayFrontCodedList
extends AbstractObjectList<char[]>
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    protected final int n;
    protected final int ratio;
    protected final char[][] array;
    protected transient long[] p;

    public CharArrayFrontCodedList(Iterator<char[]> arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        char[][] array = CharBigArrays.EMPTY_BIG_ARRAY;
        long[] p2 = LongArrays.EMPTY_ARRAY;
        char[][] a2 = new char[2][];
        long curSize = 0L;
        int n2 = 0;
        int b2 = 0;
        while (arrays.hasNext()) {
            a2[b2] = arrays.next();
            int length = a2[b2].length;
            if (n2 % ratio == 0) {
                p2 = LongArrays.grow(p2, n2 / ratio + 1);
                p2[n2 / ratio] = curSize;
                array = CharBigArrays.grow(array, curSize + (long)CharArrayFrontCodedList.count(length) + (long)length, curSize);
                curSize += (long)CharArrayFrontCodedList.writeInt(array, length, curSize);
                CharBigArrays.copyToBig(a2[b2], 0, array, curSize, length);
                curSize += (long)length;
            } else {
                int common;
                int minLength = a2[1 - b2].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a2[0][common] == a2[1][common]; ++common) {
                }
                array = CharBigArrays.grow(array, curSize + (long)CharArrayFrontCodedList.count(length -= common) + (long)CharArrayFrontCodedList.count(common) + (long)length, curSize);
                curSize += (long)CharArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += (long)CharArrayFrontCodedList.writeInt(array, common, curSize);
                CharBigArrays.copyToBig(a2[b2], common, array, curSize, length);
                curSize += (long)length;
            }
            b2 = 1 - b2;
            ++n2;
        }
        this.n = n2;
        this.ratio = ratio;
        this.array = CharBigArrays.trim(array, curSize);
        this.p = LongArrays.trim(p2, (n2 + ratio - 1) / ratio);
    }

    public CharArrayFrontCodedList(Collection<char[]> c2, int ratio) {
        this(c2.iterator(), ratio);
    }

    private static int readInt(char[][] a2, long pos) {
        int c0 = CharBigArrays.get(a2, pos);
        return c0 < 32768 ? c0 : (c0 & Short.MAX_VALUE) << 16 | CharBigArrays.get(a2, pos + 1L);
    }

    private static int count(int length) {
        return length < 32768 ? 1 : 2;
    }

    private static int writeInt(char[][] a2, int length, long pos) {
        if (length < 32768) {
            CharBigArrays.set(a2, pos, (char)length);
            return 1;
        }
        CharBigArrays.set(a2, pos++, (char)(length >>> 16 | 0x8000));
        CharBigArrays.set(a2, pos, (char)(length & 0xFFFF));
        return 2;
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(int index) {
        char[][] array = this.array;
        int delta = index % this.ratio;
        long pos = this.p[index / this.ratio];
        int length = CharArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += (long)(CharArrayFrontCodedList.count(length) + length);
        length = CharArrayFrontCodedList.readInt(array, pos);
        int common = CharArrayFrontCodedList.readInt(array, pos + (long)CharArrayFrontCodedList.count(length));
        for (int i2 = 0; i2 < delta - 1; ++i2) {
            length = CharArrayFrontCodedList.readInt(array, pos += (long)(CharArrayFrontCodedList.count(length) + CharArrayFrontCodedList.count(common) + length));
            common = CharArrayFrontCodedList.readInt(array, pos + (long)CharArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(int index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(int index, char[] a2, int offset, int length) {
        long startPos;
        int delta = index % this.ratio;
        long pos = startPos = this.p[index / this.ratio];
        int arrayLength = CharArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = this.p[index / this.ratio] + (long)CharArrayFrontCodedList.count(arrayLength);
            CharBigArrays.copyFromBig(this.array, pos, a2, offset, Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i2 = 0; i2 < delta; ++i2) {
            long prevArrayPos = pos + (long)CharArrayFrontCodedList.count(arrayLength) + (long)(i2 != 0 ? CharArrayFrontCodedList.count(common) : 0);
            common = CharArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + (long)arrayLength) + (long)CharArrayFrontCodedList.count(arrayLength = CharArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            CharBigArrays.copyFromBig(this.array, prevArrayPos, a2, currLen + offset, actualCommon - currLen);
            currLen = actualCommon;
        }
        if (currLen < length) {
            CharBigArrays.copyFromBig(this.array, pos + (long)CharArrayFrontCodedList.count(arrayLength) + (long)CharArrayFrontCodedList.count(common), a2, currLen + offset, Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    @Override
    public char[] get(int index) {
        return this.getArray(index);
    }

    public char[] getArray(int index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        char[] a2 = new char[length];
        this.extract(index, a2, 0, length);
        return a2;
    }

    public int get(int index, char[] a2, int offset, int length) {
        this.ensureRestrictedIndex(index);
        CharArrays.ensureOffsetLength(a2, offset, length);
        int arrayLength = this.extract(index, a2, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(int index, char[] a2) {
        return this.get(index, a2, 0, a2.length);
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public ObjectListIterator<char[]> listIterator(final int start) {
        this.ensureIndex(start);
        return new AbstractObjectListIterator<char[]>(){
            char[] s = CharArrays.EMPTY_ARRAY;
            int i = 0;
            long pos = 0L;
            boolean inSync;
            {
                if (start != 0) {
                    if (start == CharArrayFrontCodedList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = CharArrayFrontCodedList.this.p[start / CharArrayFrontCodedList.this.ratio];
                        int j2 = start % CharArrayFrontCodedList.this.ratio;
                        this.i = start - j2;
                        while (j2-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.i < CharArrayFrontCodedList.this.n;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int previousIndex() {
                return this.i - 1;
            }

            @Override
            public int nextIndex() {
                return this.i;
            }

            @Override
            public char[] next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % CharArrayFrontCodedList.this.ratio == 0) {
                    this.pos = CharArrayFrontCodedList.this.p[this.i / CharArrayFrontCodedList.this.ratio];
                    length = CharArrayFrontCodedList.readInt(CharArrayFrontCodedList.this.array, this.pos);
                    this.s = CharArrays.ensureCapacity(this.s, length, 0);
                    CharBigArrays.copyFromBig(CharArrayFrontCodedList.this.array, this.pos + (long)CharArrayFrontCodedList.count(length), this.s, 0, length);
                    this.pos += (long)(length + CharArrayFrontCodedList.count(length));
                    this.inSync = true;
                } else if (this.inSync) {
                    length = CharArrayFrontCodedList.readInt(CharArrayFrontCodedList.this.array, this.pos);
                    int common = CharArrayFrontCodedList.readInt(CharArrayFrontCodedList.this.array, this.pos + (long)CharArrayFrontCodedList.count(length));
                    this.s = CharArrays.ensureCapacity(this.s, length + common, common);
                    CharBigArrays.copyFromBig(CharArrayFrontCodedList.this.array, this.pos + (long)CharArrayFrontCodedList.count(length) + (long)CharArrayFrontCodedList.count(common), this.s, common, length);
                    this.pos += (long)(CharArrayFrontCodedList.count(length) + CharArrayFrontCodedList.count(common) + length);
                    length += common;
                } else {
                    length = CharArrayFrontCodedList.this.length(this.i);
                    this.s = CharArrays.ensureCapacity(this.s, length, 0);
                    CharArrayFrontCodedList.this.extract(this.i, this.s, 0, length);
                }
                ++this.i;
                return CharArrays.copy(this.s, 0, length);
            }

            @Override
            public char[] previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return CharArrayFrontCodedList.this.getArray(--this.i);
            }
        };
    }

    public CharArrayFrontCodedList clone() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("[");
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (i2 != 0) {
                s2.append(", ");
            }
            s2.append(CharArrayList.wrap(this.getArray(i2)).toString());
        }
        s2.append("]");
        return s2.toString();
    }

    protected long[] rebuildPointerArray() {
        long[] p2 = new long[(this.n + this.ratio - 1) / this.ratio];
        char[][] a2 = this.array;
        long pos = 0L;
        int j2 = 0;
        int skip = this.ratio - 1;
        for (int i2 = 0; i2 < this.n; ++i2) {
            int length = CharArrayFrontCodedList.readInt(a2, pos);
            int count = CharArrayFrontCodedList.count(length);
            if (++skip == this.ratio) {
                skip = 0;
                p2[j2++] = pos;
                pos += (long)(count + length);
                continue;
            }
            pos += (long)(count + CharArrayFrontCodedList.count(CharArrayFrontCodedList.readInt(a2, pos + (long)count)) + length);
        }
        return p2;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.p = this.rebuildPointerArray();
    }
}

