/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.chars.AbstractCharList;
import it.unimi.dsi.fastutil.chars.AbstractCharListIterator;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharIterators;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CharArrayList
extends AbstractCharList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient char[] a;
    protected int size;
    private static final boolean ASSERTS = false;

    protected CharArrayList(char[] a2, boolean dummy) {
        this.a = a2;
    }

    public CharArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new char[capacity];
    }

    public CharArrayList() {
        this(16);
    }

    public CharArrayList(Collection<? extends Character> c2) {
        this(c2.size());
        this.size = CharIterators.unwrap(CharIterators.asCharIterator(c2.iterator()), this.a);
    }

    public CharArrayList(CharCollection c2) {
        this(c2.size());
        this.size = CharIterators.unwrap(c2.iterator(), this.a);
    }

    public CharArrayList(CharList l2) {
        this(l2.size());
        this.size = l2.size();
        l2.getElements(0, this.a, 0, this.size);
    }

    public CharArrayList(char[] a2) {
        this(a2, 0, a2.length);
    }

    public CharArrayList(char[] a2, int offset, int length) {
        this(length);
        System.arraycopy(a2, offset, this.a, 0, length);
        this.size = length;
    }

    public CharArrayList(Iterator<? extends Character> i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.next().charValue());
        }
    }

    public CharArrayList(CharIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextChar());
        }
    }

    public char[] elements() {
        return this.a;
    }

    public static CharArrayList wrap(char[] a2, int length) {
        if (length > a2.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a2.length + ")");
        }
        CharArrayList l2 = new CharArrayList(a2, false);
        l2.size = length;
        return l2;
    }

    public static CharArrayList wrap(char[] a2) {
        return CharArrayList.wrap(a2, a2.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = CharArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(int capacity) {
        this.a = CharArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(int index, char k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k2;
        ++this.size;
    }

    @Override
    public boolean add(char k2) {
        this.grow(this.size + 1);
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public char getChar(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(char k2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (k2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char k2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (k2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public char removeChar(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(char k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.removeChar(index);
        return true;
    }

    @Override
    public char set(int index, char k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        char old = this.a[index];
        this.a[index] = k2;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            java.util.Arrays.fill(this.a, this.size, size, '\u0000');
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n2) {
        if (n2 >= this.a.length || this.size == this.a.length) {
            return;
        }
        char[] t2 = new char[Math.max(n2, this.size)];
        System.arraycopy(this.a, 0, t2, 0, this.size);
        this.a = t2;
    }

    @Override
    public void getElements(int from, char[] a2, int offset, int length) {
        CharArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(int index, char[] a2, int offset, int length) {
        this.ensureIndex(index);
        CharArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public char[] toArray(char[] a2) {
        if (a2 == null || a2.length < this.size) {
            a2 = new char[this.size];
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        return a2;
    }

    @Override
    public boolean addAll(int index, CharCollection c2) {
        this.ensureIndex(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        this.grow(this.size + n2);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        }
        CharIterator i2 = c2.iterator();
        this.size += n2;
        while (n2-- != 0) {
            this.a[index++] = i2.nextChar();
        }
        return true;
    }

    @Override
    public boolean addAll(int index, CharList l2) {
        this.ensureIndex(index);
        int n2 = l2.size();
        if (n2 == 0) {
            return false;
        }
        this.grow(this.size + n2);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        }
        l2.getElements(0, this.a, index, n2);
        this.size += n2;
        return true;
    }

    @Override
    public boolean removeAll(CharCollection c2) {
        char[] a2 = this.a;
        int j2 = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (c2.contains(a2[i2])) continue;
            a2[j2++] = a2[i2];
        }
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        char[] a2 = this.a;
        int j2 = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (c2.contains(Character.valueOf(a2[i2]))) continue;
            a2[j2++] = a2[i2];
        }
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public CharListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractCharListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < CharArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return CharArrayList.this.a[this.last];
            }

            @Override
            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return CharArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(char k2) {
                CharArrayList.this.add(this.pos++, k2);
                this.last = -1;
            }

            @Override
            public void set(char k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharArrayList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                CharArrayList.this.removeChar(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public CharArrayList clone() {
        CharArrayList c2 = new CharArrayList(this.size);
        System.arraycopy(this.a, 0, c2.a, 0, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(CharArrayList l2) {
        if (l2 == this) {
            return true;
        }
        int s2 = this.size();
        if (s2 != l2.size()) {
            return false;
        }
        char[] a1 = this.a;
        char[] a2 = l2.a;
        while (s2-- != 0) {
            if (a1[s2] == a2[s2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(CharArrayList l2) {
        int i2;
        int s1 = this.size();
        int s2 = l2.size();
        char[] a1 = this.a;
        char[] a2 = l2.a;
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            char e1 = a1[i2];
            char e2 = a2[i2];
            int r2 = Character.compare(e1, e2);
            if (r2 == 0) continue;
            return r2;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeChar(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new char[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readChar();
        }
    }
}

