/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleComparator;

public class DoubleHeaps {
    private DoubleHeaps() {
    }

    public static int downHeap(double[] heap, int size, int i2, DoubleComparator c2) {
        assert (i2 < size);
        double e2 = heap[i2];
        if (c2 == null) {
            int child;
            while ((child = (i2 << 1) + 1) < size) {
                double t2 = heap[child];
                int right = child + 1;
                if (right < size && Double.compare(heap[right], t2) < 0) {
                    child = right;
                    t2 = heap[child];
                }
                if (Double.compare(e2, t2) > 0) {
                    heap[i2] = t2;
                    i2 = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i2 << 1) + 1) < size) {
                double t3 = heap[child];
                int right = child + 1;
                if (right < size && c2.compare(heap[right], t3) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c2.compare(e2, t3) > 0) {
                    heap[i2] = t3;
                    i2 = child;
                    continue;
                }
                break;
            }
        }
        heap[i2] = e2;
        return i2;
    }

    public static int upHeap(double[] heap, int size, int i2, DoubleComparator c2) {
        assert (i2 < size);
        double e2 = heap[i2];
        if (c2 == null) {
            int parent;
            double t2;
            while (i2 != 0 && Double.compare(t2 = heap[parent = i2 - 1 >>> 1], e2) > 0) {
                heap[i2] = t2;
                i2 = parent;
            }
        } else {
            int parent;
            double t3;
            while (i2 != 0 && c2.compare(t3 = heap[parent = i2 - 1 >>> 1], e2) > 0) {
                heap[i2] = t3;
                i2 = parent;
            }
        }
        heap[i2] = e2;
        return i2;
    }

    public static void makeHeap(double[] heap, int size, DoubleComparator c2) {
        int i2 = size >>> 1;
        while (i2-- != 0) {
            DoubleHeaps.downHeap(heap, size, i2, c2);
        }
    }
}

