/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatHash;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2ObjectOpenCustomHashMap<V>
extends AbstractFloat2ObjectMap<V>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient V[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected FloatHash.Strategy strategy;
    protected transient int n;
    protected transient int maxFill;
    protected int size;
    protected final float f;
    protected transient Float2ObjectMap.FastEntrySet<V> entries;
    protected transient FloatSet keys;
    protected transient ObjectCollection<V> values;

    public Float2ObjectOpenCustomHashMap(int expected, float f2, FloatHash.Strategy strategy) {
        this.strategy = strategy;
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.n = HashCommon.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new float[this.n + 1];
        this.value = new Object[this.n + 1];
    }

    public Float2ObjectOpenCustomHashMap(int expected, FloatHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public Float2ObjectOpenCustomHashMap(FloatHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Float2ObjectOpenCustomHashMap(Map<? extends Float, ? extends V> m2, float f2, FloatHash.Strategy strategy) {
        this(m2.size(), f2, strategy);
        this.putAll(m2);
    }

    public Float2ObjectOpenCustomHashMap(Map<? extends Float, ? extends V> m2, FloatHash.Strategy strategy) {
        this(m2, 0.75f, strategy);
    }

    public Float2ObjectOpenCustomHashMap(Float2ObjectMap<V> m2, float f2, FloatHash.Strategy strategy) {
        this(m2.size(), f2, strategy);
        this.putAll(m2);
    }

    public Float2ObjectOpenCustomHashMap(Float2ObjectMap<V> m2, FloatHash.Strategy strategy) {
        this(m2, 0.75f, strategy);
    }

    public Float2ObjectOpenCustomHashMap(float[] k2, V[] v2, float f2, FloatHash.Strategy strategy) {
        this(k2.length, f2, strategy);
        if (k2.length != v2.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v2.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v2[i2]);
        }
    }

    public Float2ObjectOpenCustomHashMap(float[] k2, V[] v2, FloatHash.Strategy strategy) {
        this(k2, v2, 0.75f, strategy);
    }

    public FloatHash.Strategy strategy() {
        return this.strategy;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private V removeEntry(int pos) {
        V oldValue = this.value[pos];
        this.value[pos] = null;
        --this.size;
        this.shiftKeys(pos);
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    private V removeNullEntry() {
        this.containsNullKey = false;
        V oldValue = this.value[this.n];
        this.value[this.n] = null;
        --this.size;
        if (this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends V> m2) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(m2.size());
        } else {
            this.tryCapacity(this.size() + m2.size());
        }
        super.putAll(m2);
    }

    private int insert(float k2, V v2) {
        int pos;
        if (this.strategy.equals(k2, 0.0f)) {
            if (this.containsNullKey) {
                return this.n;
            }
            this.containsNullKey = true;
            pos = this.n;
        } else {
            float[] key = this.key;
            pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
            float curr = key[pos];
            if (Float.floatToIntBits(curr) != 0) {
                if (this.strategy.equals(curr, k2)) {
                    return pos;
                }
                while (Float.floatToIntBits(curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (!this.strategy.equals(curr, k2)) continue;
                    return pos;
                }
            }
        }
        this.key[pos] = k2;
        this.value[pos] = v2;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return -1;
    }

    @Override
    public V put(float k2, V v2) {
        int pos = this.insert(k2, v2);
        if (pos < 0) {
            return (V)this.defRetValue;
        }
        V oldValue = this.value[pos];
        this.value[pos] = v2;
        return oldValue;
    }

    protected final void shiftKeys(int pos) {
        float[] key = this.key;
        while (true) {
            float curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if (Float.floatToIntBits(curr = key[pos]) == 0) {
                    key[last] = 0.0f;
                    this.value[last] = null;
                    return;
                }
                int slot = HashCommon.mix(this.strategy.hashCode(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
            this.value[last] = this.value[pos];
        }
    }

    @Override
    public V remove(float k2) {
        if (this.strategy.equals(k2, 0.0f)) {
            if (this.containsNullKey) {
                return this.removeNullEntry();
            }
            return (V)this.defRetValue;
        }
        float[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        float curr = key[pos];
        if (Float.floatToIntBits(curr) == 0) {
            return (V)this.defRetValue;
        }
        if (this.strategy.equals(k2, curr)) {
            return this.removeEntry(pos);
        }
        do {
            if (Float.floatToIntBits(curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return (V)this.defRetValue;
        } while (!this.strategy.equals(k2, curr));
        return this.removeEntry(pos);
    }

    @Override
    public V get(float k2) {
        if (this.strategy.equals(k2, 0.0f)) {
            return (V)(this.containsNullKey ? this.value[this.n] : this.defRetValue);
        }
        float[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        float curr = key[pos];
        if (Float.floatToIntBits(curr) == 0) {
            return (V)this.defRetValue;
        }
        if (this.strategy.equals(k2, curr)) {
            return this.value[pos];
        }
        do {
            if (Float.floatToIntBits(curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return (V)this.defRetValue;
        } while (!this.strategy.equals(k2, curr));
        return this.value[pos];
    }

    @Override
    public boolean containsKey(float k2) {
        if (this.strategy.equals(k2, 0.0f)) {
            return this.containsNullKey;
        }
        float[] key = this.key;
        int pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        float curr = key[pos];
        if (Float.floatToIntBits(curr) == 0) {
            return false;
        }
        if (this.strategy.equals(k2, curr)) {
            return true;
        }
        do {
            if (Float.floatToIntBits(curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (!this.strategy.equals(k2, curr));
        return true;
    }

    @Override
    public boolean containsValue(Object v2) {
        V[] value = this.value;
        float[] key = this.key;
        if (this.containsNullKey && (value[this.n] == null ? v2 == null : value[this.n].equals(v2))) {
            return true;
        }
        int i2 = this.n;
        while (i2-- != 0) {
            if (Float.floatToIntBits(key[i2]) == 0 || !(value[i2] == null ? v2 == null : value[i2].equals(v2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNullKey = false;
        Arrays.fill(this.key, 0.0f);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Float2ObjectMap.FastEntrySet<V> float2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2ObjectOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(Object v2) {
                    return Float2ObjectOpenCustomHashMap.this.containsValue(v2);
                }

                @Override
                public void clear() {
                    Float2ObjectOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l2 = HashCommon.arraySize(this.size, this.f);
        if (l2 >= this.n || this.size > HashCommon.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n2) {
        int l2 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (l2 >= n2 || this.size > HashCommon.maxFill(l2, this.f)) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        float[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        float[] newKey = new float[newN + 1];
        Object[] newValue = new Object[newN + 1];
        int i2 = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (Float.floatToIntBits(key[--i2]) == 0) {
            }
            int pos = HashCommon.mix(this.strategy.hashCode(key[i2])) & mask;
            if (Float.floatToIntBits(newKey[pos]) != 0) {
                while (Float.floatToIntBits(newKey[pos = pos + 1 & mask]) != 0) {
                }
            }
            newKey[pos] = key[i2];
            newValue[pos] = value[i2];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    public Float2ObjectOpenCustomHashMap<V> clone() {
        Float2ObjectOpenCustomHashMap c2;
        try {
            c2 = (Float2ObjectOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.containsNullKey = this.containsNullKey;
        c2.key = (float[])this.key.clone();
        c2.value = (Object[])this.value.clone();
        c2.strategy = this.strategy;
        return c2;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int j2 = this.realSize();
        int i2 = 0;
        int t2 = 0;
        while (j2-- != 0) {
            while (Float.floatToIntBits(this.key[i2]) == 0) {
                ++i2;
            }
            t2 = this.strategy.hashCode(this.key[i2]);
            if (this != this.value[i2]) {
                t2 ^= this.value[i2] == null ? 0 : this.value[i2].hashCode();
            }
            h2 += t2;
            ++i2;
        }
        if (this.containsNullKey) {
            h2 += this.value[this.n] == null ? 0 : this.value[this.n].hashCode();
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        float[] key = this.key;
        V[] value = this.value;
        MapIterator i2 = new MapIterator();
        s2.defaultWriteObject();
        int j2 = this.size;
        while (j2-- != 0) {
            int e2 = i2.nextEntry();
            s2.writeFloat(key[e2]);
            s2.writeObject(value[e2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n + 1];
        float[] key = this.key;
        this.value = new Object[this.n + 1];
        Object[] value = this.value;
        int i2 = this.size;
        while (i2-- != 0) {
            int pos;
            float k2 = s2.readFloat();
            Object v2 = s2.readObject();
            if (this.strategy.equals(k2, 0.0f)) {
                pos = this.n;
                this.containsNullKey = true;
            } else {
                pos = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
                while (Float.floatToIntBits(key[pos]) != 0) {
                    pos = pos + 1 & this.mask;
                }
            }
            key[pos] = k2;
            value[pos] = v2;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Float2ObjectOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        @Override
        public FloatIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Float2ObjectOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(float k2) {
            return Float2ObjectOpenCustomHashMap.this.containsKey(k2);
        }

        @Override
        public boolean remove(float k2) {
            int oldSize = Float2ObjectOpenCustomHashMap.this.size;
            Float2ObjectOpenCustomHashMap.this.remove(k2);
            return Float2ObjectOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2ObjectOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Float2ObjectOpenCustomHashMap.this.key[this.nextEntry()];
        }

        @Override
        @Deprecated
        public Float next() {
            return Float.valueOf(Float2ObjectOpenCustomHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Float2ObjectMap.Entry<V>>
    implements Float2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (e2.getKey() == null || !(e2.getKey() instanceof Float)) {
                return false;
            }
            float k2 = ((Float)e2.getKey()).floatValue();
            Object v2 = e2.getValue();
            if (Float2ObjectOpenCustomHashMap.this.strategy.equals(k2, 0.0f)) {
                return Float2ObjectOpenCustomHashMap.this.containsNullKey && (Float2ObjectOpenCustomHashMap.this.value[Float2ObjectOpenCustomHashMap.this.n] == null ? v2 == null : Float2ObjectOpenCustomHashMap.this.value[Float2ObjectOpenCustomHashMap.this.n].equals(v2));
            }
            float[] key = Float2ObjectOpenCustomHashMap.this.key;
            int pos = HashCommon.mix(Float2ObjectOpenCustomHashMap.this.strategy.hashCode(k2)) & Float2ObjectOpenCustomHashMap.this.mask;
            float curr = key[pos];
            if (Float.floatToIntBits(curr) == 0) {
                return false;
            }
            if (Float2ObjectOpenCustomHashMap.this.strategy.equals(k2, curr)) {
                return Float2ObjectOpenCustomHashMap.this.value[pos] == null ? v2 == null : Float2ObjectOpenCustomHashMap.this.value[pos].equals(v2);
            }
            do {
                if (Float.floatToIntBits(curr = key[pos = pos + 1 & Float2ObjectOpenCustomHashMap.this.mask]) != 0) continue;
                return false;
            } while (!Float2ObjectOpenCustomHashMap.this.strategy.equals(k2, curr));
            return Float2ObjectOpenCustomHashMap.this.value[pos] == null ? v2 == null : Float2ObjectOpenCustomHashMap.this.value[pos].equals(v2);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            if (e2.getKey() == null || !(e2.getKey() instanceof Float)) {
                return false;
            }
            float k2 = ((Float)e2.getKey()).floatValue();
            Object v2 = e2.getValue();
            if (Float2ObjectOpenCustomHashMap.this.strategy.equals(k2, 0.0f)) {
                if (Float2ObjectOpenCustomHashMap.this.containsNullKey && (Float2ObjectOpenCustomHashMap.this.value[Float2ObjectOpenCustomHashMap.this.n] == null ? v2 == null : Float2ObjectOpenCustomHashMap.this.value[Float2ObjectOpenCustomHashMap.this.n].equals(v2))) {
                    Float2ObjectOpenCustomHashMap.this.removeNullEntry();
                    return true;
                }
                return false;
            }
            float[] key = Float2ObjectOpenCustomHashMap.this.key;
            int pos = HashCommon.mix(Float2ObjectOpenCustomHashMap.this.strategy.hashCode(k2)) & Float2ObjectOpenCustomHashMap.this.mask;
            float curr = key[pos];
            if (Float.floatToIntBits(curr) == 0) {
                return false;
            }
            if (Float2ObjectOpenCustomHashMap.this.strategy.equals(curr, k2)) {
                if (Float2ObjectOpenCustomHashMap.this.value[pos] == null ? v2 == null : Float2ObjectOpenCustomHashMap.this.value[pos].equals(v2)) {
                    Float2ObjectOpenCustomHashMap.this.removeEntry(pos);
                    return true;
                }
                return false;
            }
            do {
                if (Float.floatToIntBits(curr = key[pos = pos + 1 & Float2ObjectOpenCustomHashMap.this.mask]) != 0) continue;
                return false;
            } while (!Float2ObjectOpenCustomHashMap.this.strategy.equals(curr, k2) || !(Float2ObjectOpenCustomHashMap.this.value[pos] == null ? v2 == null : Float2ObjectOpenCustomHashMap.this.value[pos].equals(v2)));
            Float2ObjectOpenCustomHashMap.this.removeEntry(pos);
            return true;
        }

        @Override
        public int size() {
            return Float2ObjectOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2ObjectOpenCustomHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ObjectMap.Entry<V>> {
        private final MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public MapEntry next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2ObjectMap.Entry<V>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        boolean mustReturnNullKey;
        FloatArrayList wrapped;

        private MapIterator() {
            this.pos = Float2ObjectOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Float2ObjectOpenCustomHashMap.this.size;
            this.mustReturnNullKey = Float2ObjectOpenCustomHashMap.this.containsNullKey;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNullKey) {
                this.mustReturnNullKey = false;
                this.last = Float2ObjectOpenCustomHashMap.this.n;
                return this.last;
            }
            float[] key = Float2ObjectOpenCustomHashMap.this.key;
            do {
                if (--this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                float k2 = this.wrapped.getFloat(-this.pos - 1);
                int p2 = HashCommon.mix(Float2ObjectOpenCustomHashMap.this.strategy.hashCode(k2)) & Float2ObjectOpenCustomHashMap.this.mask;
                while (!Float2ObjectOpenCustomHashMap.this.strategy.equals(k2, key[p2])) {
                    p2 = p2 + 1 & Float2ObjectOpenCustomHashMap.this.mask;
                }
                return p2;
            } while (Float.floatToIntBits(key[this.pos]) == 0);
            this.last = this.pos;
            return this.last;
        }

        private final void shiftKeys(int pos) {
            float[] key = Float2ObjectOpenCustomHashMap.this.key;
            while (true) {
                float curr;
                int last = pos;
                pos = last + 1 & Float2ObjectOpenCustomHashMap.this.mask;
                while (true) {
                    if (Float.floatToIntBits(curr = key[pos]) == 0) {
                        key[last] = 0.0f;
                        Float2ObjectOpenCustomHashMap.this.value[last] = null;
                        return;
                    }
                    int slot = HashCommon.mix(Float2ObjectOpenCustomHashMap.this.strategy.hashCode(curr)) & Float2ObjectOpenCustomHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Float2ObjectOpenCustomHashMap.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new FloatArrayList(2);
                    }
                    this.wrapped.add(key[pos]);
                }
                key[last] = curr;
                Float2ObjectOpenCustomHashMap.this.value[last] = Float2ObjectOpenCustomHashMap.this.value[pos];
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == Float2ObjectOpenCustomHashMap.this.n) {
                Float2ObjectOpenCustomHashMap.this.containsNullKey = false;
                Float2ObjectOpenCustomHashMap.this.value[Float2ObjectOpenCustomHashMap.this.n] = null;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                Float2ObjectOpenCustomHashMap.this.remove(this.wrapped.getFloat(-this.pos - 1));
                this.last = -1;
                return;
            }
            --Float2ObjectOpenCustomHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }
    }

    final class MapEntry
    implements Float2ObjectMap.Entry<V>,
    Map.Entry<Float, V> {
        int index;

        MapEntry(int index) {
            this.index = index;
        }

        MapEntry() {
        }

        @Override
        public float getFloatKey() {
            return Float2ObjectOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Float2ObjectOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v2) {
            Object oldValue = Float2ObjectOpenCustomHashMap.this.value[this.index];
            Float2ObjectOpenCustomHashMap.this.value[this.index] = v2;
            return oldValue;
        }

        @Override
        @Deprecated
        public Float getKey() {
            return Float.valueOf(Float2ObjectOpenCustomHashMap.this.key[this.index]);
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return Float2ObjectOpenCustomHashMap.this.strategy.equals(Float2ObjectOpenCustomHashMap.this.key[this.index], ((Float)e2.getKey()).floatValue()) && (Float2ObjectOpenCustomHashMap.this.value[this.index] == null ? e2.getValue() == null : Float2ObjectOpenCustomHashMap.this.value[this.index].equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            return Float2ObjectOpenCustomHashMap.this.strategy.hashCode(Float2ObjectOpenCustomHashMap.this.key[this.index]) ^ (Float2ObjectOpenCustomHashMap.this.value[this.index] == null ? 0 : Float2ObjectOpenCustomHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Float2ObjectOpenCustomHashMap.this.key[this.index] + "=>" + Float2ObjectOpenCustomHashMap.this.value[this.index];
        }
    }
}

