/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.floats.AbstractFloatBigList;
import it.unimi.dsi.fastutil.floats.AbstractFloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatBigList;
import it.unimi.dsi.fastutil.floats.FloatBigListIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class FloatBigArrayBigList
extends AbstractFloatBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient float[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected FloatBigArrayBigList(float[][] a2, boolean dummy) {
        this.a = a2;
    }

    public FloatBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = FloatBigArrays.newBigArray(capacity);
    }

    public FloatBigArrayBigList() {
        this(16L);
    }

    public FloatBigArrayBigList(FloatCollection c2) {
        this(c2.size());
        FloatIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add(i2.nextFloat());
        }
    }

    public FloatBigArrayBigList(FloatBigList l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public FloatBigArrayBigList(float[][] a2) {
        this(a2, 0L, FloatBigArrays.length(a2));
    }

    public FloatBigArrayBigList(float[][] a2, long offset, long length) {
        this(length);
        FloatBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public FloatBigArrayBigList(Iterator<? extends Float> i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.next().floatValue());
        }
    }

    public FloatBigArrayBigList(FloatIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextFloat());
        }
    }

    public float[][] elements() {
        return this.a;
    }

    public static FloatBigArrayBigList wrap(float[][] a2, long length) {
        if (length > FloatBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + FloatBigArrays.length(a2) + ")");
        }
        FloatBigArrayBigList l2 = new FloatBigArrayBigList(a2, false);
        l2.size = length;
        return l2;
    }

    public static FloatBigArrayBigList wrap(float[][] a2) {
        return FloatBigArrayBigList.wrap(a2, FloatBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        this.a = FloatBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = FloatBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index, float k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            FloatBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        FloatBigArrays.set(this.a, index, k2);
        ++this.size;
    }

    @Override
    public boolean add(float k2) {
        this.grow(this.size + 1L);
        FloatBigArrays.set(this.a, this.size++, k2);
        return true;
    }

    @Override
    public float getFloat(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return FloatBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(float k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (Float.floatToIntBits(k2) != Float.floatToIntBits(FloatBigArrays.get(this.a, i2))) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(float k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (Float.floatToIntBits(k2) != Float.floatToIntBits(FloatBigArrays.get(this.a, i2))) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public float removeFloat(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        float old = FloatBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            FloatBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(float k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.removeFloat(index);
        return true;
    }

    @Override
    public float set(long index, float k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        float old = FloatBigArrays.get(this.a, index);
        FloatBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(FloatCollection c2) {
        float[] s2 = null;
        float[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((float)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        float[] s2 = null;
        float[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains(Float.valueOf((float)s2[sd]))) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > FloatBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            FloatBigArrays.fill(this.a, this.size, size, 0.0f);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = FloatBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = FloatBigArrays.trim(this.a, Math.max(n2, this.size));
    }

    @Override
    public void getElements(long from, float[][] a2, long offset, long length) {
        FloatBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        FloatBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, float[][] a2, long offset, long length) {
        this.ensureIndex(index);
        FloatBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        FloatBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        FloatBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public FloatBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new AbstractFloatBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < FloatBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return FloatBigArrays.get(FloatBigArrayBigList.this.a, this.last);
            }

            @Override
            public float previousFloat() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return FloatBigArrays.get(FloatBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(float k2) {
                FloatBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(float k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                FloatBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                FloatBigArrayBigList.this.removeFloat(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public FloatBigArrayBigList clone() {
        FloatBigArrayBigList c2 = new FloatBigArrayBigList(this.size);
        FloatBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(FloatBigArrayBigList l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        float[][] a1 = this.a;
        float[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (FloatBigArrays.get(a1, s2) == FloatBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(FloatBigArrayBigList l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        float[][] a1 = this.a;
        float[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            float e2;
            float e1 = FloatBigArrays.get(a1, i2);
            int r2 = Float.compare(e1, e2 = FloatBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeFloat(FloatBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = FloatBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            FloatBigArrays.set(this.a, i2, s2.readFloat());
            ++i2;
        }
    }
}

