/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatComparator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;

public class FloatComparators {
    public static final FloatComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final FloatComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private FloatComparators() {
    }

    public static FloatComparator oppositeComparator(FloatComparator c2) {
        return new OppositeComparator(c2);
    }

    protected static class OppositeComparator
    extends AbstractFloatComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FloatComparator comparator;

        protected OppositeComparator(FloatComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(float a2, float b2) {
            return this.comparator.compare(b2, a2);
        }
    }

    protected static class OppositeImplicitComparator
    extends AbstractFloatComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(float a2, float b2) {
            return -Float.compare(a2, b2);
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class NaturalImplicitComparator
    extends AbstractFloatComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(float a2, float b2) {
            return Float.compare(a2, b2);
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }
}

