/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class FloatIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private FloatIterators() {
    }

    public static FloatListIterator singleton(float element) {
        return new SingletonIterator(element);
    }

    public static FloatListIterator wrap(float[] array, int offset, int length) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static FloatListIterator wrap(float[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(FloatIterator i2, float[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            array[offset++] = i2.nextFloat();
        }
        return max - j2 - 1;
    }

    public static int unwrap(FloatIterator i2, float[] array) {
        return FloatIterators.unwrap(i2, array, 0, array.length);
    }

    public static float[] unwrap(FloatIterator i2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        float[] array = new float[16];
        int j2 = 0;
        while (max-- != 0 && i2.hasNext()) {
            if (j2 == array.length) {
                array = FloatArrays.grow(array, j2 + 1);
            }
            array[j2++] = i2.nextFloat();
        }
        return FloatArrays.trim(array, j2);
    }

    public static float[] unwrap(FloatIterator i2) {
        return FloatIterators.unwrap(i2, Integer.MAX_VALUE);
    }

    public static int unwrap(FloatIterator i2, FloatCollection c2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            c2.add(i2.nextFloat());
        }
        return max - j2 - 1;
    }

    public static long unwrap(FloatIterator i2, FloatCollection c2) {
        long n2 = 0L;
        while (i2.hasNext()) {
            c2.add(i2.nextFloat());
            ++n2;
        }
        return n2;
    }

    public static int pour(FloatIterator i2, FloatCollection s2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            s2.add(i2.nextFloat());
        }
        return max - j2 - 1;
    }

    public static int pour(FloatIterator i2, FloatCollection s2) {
        return FloatIterators.pour(i2, s2, Integer.MAX_VALUE);
    }

    public static FloatList pour(FloatIterator i2, int max) {
        FloatArrayList l2 = new FloatArrayList();
        FloatIterators.pour(i2, l2, max);
        l2.trim();
        return l2;
    }

    public static FloatList pour(FloatIterator i2) {
        return FloatIterators.pour(i2, Integer.MAX_VALUE);
    }

    public static FloatIterator asFloatIterator(Iterator i2) {
        if (i2 instanceof FloatIterator) {
            return (FloatIterator)i2;
        }
        return new IteratorWrapper(i2);
    }

    public static FloatListIterator asFloatIterator(ListIterator i2) {
        if (i2 instanceof FloatListIterator) {
            return (FloatListIterator)i2;
        }
        return new ListIteratorWrapper(i2);
    }

    public static FloatIterator concat(FloatIterator[] a2) {
        return FloatIterators.concat(a2, 0, a2.length);
    }

    public static FloatIterator concat(FloatIterator[] a2, int offset, int length) {
        return new IteratorConcatenator(a2, offset, length);
    }

    public static FloatIterator unmodifiable(FloatIterator i2) {
        return new UnmodifiableIterator(i2);
    }

    public static FloatBidirectionalIterator unmodifiable(FloatBidirectionalIterator i2) {
        return new UnmodifiableBidirectionalIterator(i2);
    }

    public static FloatListIterator unmodifiable(FloatListIterator i2) {
        return new UnmodifiableListIterator(i2);
    }

    public static FloatIterator wrap(ByteIterator iterator) {
        return new ByteIteratorWrapper(iterator);
    }

    public static FloatIterator wrap(ShortIterator iterator) {
        return new ShortIteratorWrapper(iterator);
    }

    protected static class ShortIteratorWrapper
    implements FloatIterator {
        final ShortIterator iterator;

        public ShortIteratorWrapper(ShortIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Float next() {
            return Float.valueOf(this.iterator.nextShort());
        }

        @Override
        public float nextFloat() {
            return this.iterator.nextShort();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    protected static class ByteIteratorWrapper
    implements FloatIterator {
        final ByteIterator iterator;

        public ByteIteratorWrapper(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @Deprecated
        public Float next() {
            return Float.valueOf(this.iterator.nextByte());
        }

        @Override
        public float nextFloat() {
            return this.iterator.nextByte();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    public static class UnmodifiableListIterator
    extends AbstractFloatListIterator {
        protected final FloatListIterator i;

        public UnmodifiableListIterator(FloatListIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public float previousFloat() {
            return this.i.previousFloat();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    extends AbstractFloatBidirectionalIterator {
        protected final FloatBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(FloatBidirectionalIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }

        @Override
        public float previousFloat() {
            return this.i.previousFloat();
        }
    }

    public static class UnmodifiableIterator
    extends AbstractFloatIterator {
        protected final FloatIterator i;

        public UnmodifiableIterator(FloatIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public float nextFloat() {
            return this.i.nextFloat();
        }
    }

    private static class IteratorConcatenator
    extends AbstractFloatIterator {
        final FloatIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(FloatIterator[] a2, int offset, int length) {
            this.a = a2;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            float next = this.a[this.lastOffset].nextFloat();
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        @Override
        public int skip(int n2) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n2 && this.length != 0) {
                skipped += this.a[this.offset].skip(n2 - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class ListIteratorWrapper
    extends AbstractFloatListIterator {
        final ListIterator<Float> i;

        public ListIteratorWrapper(ListIterator<Float> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(float k2) {
            this.i.set(Float.valueOf(k2));
        }

        @Override
        public void add(float k2) {
            this.i.add(Float.valueOf(k2));
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public float nextFloat() {
            return this.i.next().floatValue();
        }

        @Override
        public float previousFloat() {
            return this.i.previous().floatValue();
        }
    }

    private static class IteratorWrapper
    extends AbstractFloatIterator {
        final Iterator<Float> i;

        public IteratorWrapper(Iterator<Float> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public float nextFloat() {
            return this.i.next().floatValue();
        }
    }

    private static class ArrayIterator
    extends AbstractFloatListIterator {
        private final float[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(float[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        @Override
        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        @Override
        public int skip(int n2) {
            if (n2 <= this.length - this.curr) {
                this.curr += n2;
                return n2;
            }
            n2 = this.length - this.curr;
            this.curr = this.length;
            return n2;
        }

        @Override
        public int back(int n2) {
            if (n2 <= this.curr) {
                this.curr -= n2;
                return n2;
            }
            n2 = this.curr;
            this.curr = 0;
            return n2;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class SingletonIterator
    extends AbstractFloatListIterator {
        private final float element;
        private int curr;

        public SingletonIterator(float element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public float previousFloat() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyIterator
    extends AbstractFloatListIterator
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public float nextFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public float previousFloat() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public int skip(int n2) {
            return 0;
        }

        @Override
        public int back(int n2) {
            return 0;
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_ITERATOR;
        }
    }
}

