/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.chars.AbstractCharBigList;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.chars.CharBigList;
import it.unimi.dsi.fastutil.chars.CharBigListIterator;
import it.unimi.dsi.fastutil.chars.CharBigListIterators;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharCollections;
import it.unimi.dsi.fastutil.chars.CharList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public class CharBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private CharBigLists() {
    }

    public static CharBigList shuffle(CharBigList l2, Random random) {
        long i2 = l2.size64();
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            char t2 = l2.getChar(i2);
            l2.set(i2, l2.getChar(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static CharBigList singleton(char element) {
        return new Singleton(element);
    }

    public static CharBigList singleton(Object element) {
        return new Singleton(((Character)element).charValue());
    }

    public static CharBigList synchronize(CharBigList l2) {
        return new SynchronizedBigList(l2);
    }

    public static CharBigList synchronize(CharBigList l2, Object sync) {
        return new SynchronizedBigList(l2, sync);
    }

    public static CharBigList unmodifiable(CharBigList l2) {
        return new UnmodifiableBigList(l2);
    }

    public static CharBigList asBigList(CharList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractCharBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final CharList list;

        protected ListBigList(CharList list) {
            this.list = list;
        }

        private int intIndex(long index) {
            if (index >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size) {
            this.list.size(this.intIndex(size));
        }

        @Override
        public CharBigListIterator iterator() {
            return CharBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public CharBigListIterator listIterator() {
            return CharBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public CharBigListIterator listIterator(long index) {
            return CharBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index)));
        }

        @Override
        public boolean addAll(long index, Collection<? extends Character> c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public CharBigList subList(long from, long to) {
            return new ListBigList(this.list.subList(this.intIndex(from), this.intIndex(to)));
        }

        @Override
        public boolean contains(char key) {
            return this.list.contains(key);
        }

        @Override
        public char[] toCharArray() {
            return this.list.toCharArray();
        }

        @Override
        public void removeElements(long from, long to) {
            this.list.removeElements(this.intIndex(from), this.intIndex(to));
        }

        @Override
        @Deprecated
        public char[] toCharArray(char[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean addAll(long index, CharCollection c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(CharCollection c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean addAll(long index, CharBigList c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(CharBigList c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean containsAll(CharCollection c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean removeAll(CharCollection c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(CharCollection c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void add(long index, char key) {
            this.list.add(this.intIndex(index), key);
        }

        @Override
        public boolean add(char key) {
            return this.list.add(key);
        }

        @Override
        public char getChar(long index) {
            return this.list.getChar(this.intIndex(index));
        }

        @Override
        public long indexOf(char k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(char k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public char removeChar(long index) {
            return this.list.removeChar(this.intIndex(index));
        }

        @Override
        public char set(long index, char k2) {
            return this.list.set(this.intIndex(index), k2);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends Character> c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends CharCollections.UnmodifiableCollection
    implements CharBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final CharBigList list;

        protected UnmodifiableBigList(CharBigList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public char getChar(long i2) {
            return this.list.getChar(i2);
        }

        @Override
        public char set(long i2, char k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i2, char k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char removeChar(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(char k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(char k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(long index, Collection<? extends Character> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from, char[][] a2, long offset, long length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, char[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, char[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size) {
            this.list.size(size);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public CharBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public CharBigListIterator listIterator() {
            return CharBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public CharBigListIterator listIterator(long i2) {
            return CharBigListIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        public CharBigList subList(long from, long to) {
            return CharBigLists.unmodifiable(this.list.subList(from, to));
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.list.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Character> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(long index, CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index, CharBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character get(long i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(long i2, Character k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character set(long index, Character k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character remove(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedBigList
    extends CharCollections.SynchronizedCollection
    implements CharBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final CharBigList list;

        protected SynchronizedBigList(CharBigList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedBigList(CharBigList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char getChar(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getChar(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char set(long i2, char k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i2, char k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char removeChar(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeChar(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(char k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(char k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, Collection<? extends Character> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from, char[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, char[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, char[][] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public CharBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public CharBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public CharBigListIterator listIterator(long i2) {
            return this.list.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBigList subList(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                return CharBigLists.synchronize(this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Character> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, CharCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, CharBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(CharBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i2, Character k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Character get(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Character set(long index, Character k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Character remove(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }
    }

    public static class Singleton
    extends AbstractCharBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final char element;

        private Singleton(char element) {
            this.element = element;
        }

        @Override
        public char getChar(long i2) {
            if (i2 == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(char k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char removeChar(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(char k2) {
            return k2 == this.element;
        }

        @Override
        public char[] toCharArray() {
            char[] a2 = new char[]{this.element};
            return a2;
        }

        @Override
        public CharBigListIterator listIterator() {
            return CharBigListIterators.singleton(this.element);
        }

        @Override
        public CharBigListIterator listIterator(long i2) {
            if (i2 > 1L || i2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            CharBigListIterator l2 = this.listIterator();
            if (i2 == 1L) {
                l2.nextChar();
            }
            return l2;
        }

        @Override
        public CharBigList subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0L || to != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Character> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Character> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, CharBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends CharCollections.EmptyCollection
    implements CharBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public char getChar(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(char k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char removeChar(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index, char k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char set(long index, char k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(char k2) {
            return -1L;
        }

        @Override
        public long lastIndexOf(char k2) {
            return -1L;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Character> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, CharCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, CharBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index, Character k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Character k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character get(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Character set(long index, Character k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character remove(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k2) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k2) {
            return -1L;
        }

        @Override
        public CharBigListIterator listIterator() {
            return CharBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public CharBigListIterator iterator() {
            return CharBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public CharBigListIterator listIterator(long i2) {
            if (i2 == 0L) {
                return CharBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        public CharBigList subList(long from, long to) {
            if (from == 0L && to == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from, char[][] a2, long offset, long length) {
            CharBigArrays.ensureOffsetLength(a2, offset, length);
            if (from != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, char[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, char[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Character> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof BigList && ((BigList)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

