/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleBigList;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleBigListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigList;
import it.unimi.dsi.fastutil.doubles.DoubleBigListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class DoubleBigArrayBigList
extends AbstractDoubleBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient double[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected DoubleBigArrayBigList(double[][] a2, boolean dummy) {
        this.a = a2;
    }

    public DoubleBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = DoubleBigArrays.newBigArray(capacity);
    }

    public DoubleBigArrayBigList() {
        this(16L);
    }

    public DoubleBigArrayBigList(DoubleCollection c2) {
        this(c2.size());
        DoubleIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add(i2.nextDouble());
        }
    }

    public DoubleBigArrayBigList(DoubleBigList l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public DoubleBigArrayBigList(double[][] a2) {
        this(a2, 0L, DoubleBigArrays.length(a2));
    }

    public DoubleBigArrayBigList(double[][] a2, long offset, long length) {
        this(length);
        DoubleBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public DoubleBigArrayBigList(Iterator<? extends Double> i2) {
        this();
        while (i2.hasNext()) {
            this.add((double)i2.next());
        }
    }

    public DoubleBigArrayBigList(DoubleIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextDouble());
        }
    }

    public double[][] elements() {
        return this.a;
    }

    public static DoubleBigArrayBigList wrap(double[][] a2, long length) {
        if (length > DoubleBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + DoubleBigArrays.length(a2) + ")");
        }
        DoubleBigArrayBigList l2 = new DoubleBigArrayBigList(a2, false);
        l2.size = length;
        return l2;
    }

    public static DoubleBigArrayBigList wrap(double[][] a2) {
        return DoubleBigArrayBigList.wrap(a2, DoubleBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        this.a = DoubleBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = DoubleBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index, double k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            DoubleBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        DoubleBigArrays.set(this.a, index, k2);
        ++this.size;
    }

    @Override
    public boolean add(double k2) {
        this.grow(this.size + 1L);
        DoubleBigArrays.set(this.a, this.size++, k2);
        return true;
    }

    @Override
    public double getDouble(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return DoubleBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(double k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (Double.doubleToLongBits(k2) != Double.doubleToLongBits(DoubleBigArrays.get(this.a, i2))) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(double k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (Double.doubleToLongBits(k2) != Double.doubleToLongBits(DoubleBigArrays.get(this.a, i2))) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public double removeDouble(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        double old = DoubleBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            DoubleBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(double k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.removeDouble(index);
        return true;
    }

    @Override
    public double set(long index, double k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        double old = DoubleBigArrays.get(this.a, index);
        DoubleBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(DoubleCollection c2) {
        double[] s2 = null;
        double[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((double)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        double[] s2 = null;
        double[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((double)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > DoubleBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            DoubleBigArrays.fill(this.a, this.size, size, 0.0);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = DoubleBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = DoubleBigArrays.trim(this.a, Math.max(n2, this.size));
    }

    @Override
    public void getElements(long from, double[][] a2, long offset, long length) {
        DoubleBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        DoubleBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, double[][] a2, long offset, long length) {
        this.ensureIndex(index);
        DoubleBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        DoubleBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        DoubleBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public DoubleBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new AbstractDoubleBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < DoubleBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return DoubleBigArrays.get(DoubleBigArrayBigList.this.a, this.last);
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return DoubleBigArrays.get(DoubleBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(double k2) {
                DoubleBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(double k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                DoubleBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                DoubleBigArrayBigList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public DoubleBigArrayBigList clone() {
        DoubleBigArrayBigList c2 = new DoubleBigArrayBigList(this.size);
        DoubleBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(DoubleBigArrayBigList l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        double[][] a1 = this.a;
        double[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (DoubleBigArrays.get(a1, s2) == DoubleBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DoubleBigArrayBigList l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        double[][] a1 = this.a;
        double[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            double e2;
            double e1 = DoubleBigArrays.get(a1, i2);
            int r2 = Double.compare(e1, e2 = DoubleBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeDouble(DoubleBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = DoubleBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            DoubleBigArrays.set(this.a, i2, s2.readDouble());
            ++i2;
        }
    }
}

