/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.ints.AbstractIntBigList;
import it.unimi.dsi.fastutil.ints.AbstractIntBigListIterator;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntBigList;
import it.unimi.dsi.fastutil.ints.IntBigListIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class IntBigArrayBigList
extends AbstractIntBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient int[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected IntBigArrayBigList(int[][] a2, boolean dummy) {
        this.a = a2;
    }

    public IntBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = IntBigArrays.newBigArray(capacity);
    }

    public IntBigArrayBigList() {
        this(16L);
    }

    public IntBigArrayBigList(IntCollection c2) {
        this(c2.size());
        IntIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add(i2.nextInt());
        }
    }

    public IntBigArrayBigList(IntBigList l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public IntBigArrayBigList(int[][] a2) {
        this(a2, 0L, IntBigArrays.length(a2));
    }

    public IntBigArrayBigList(int[][] a2, long offset, long length) {
        this(length);
        IntBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public IntBigArrayBigList(Iterator<? extends Integer> i2) {
        this();
        while (i2.hasNext()) {
            this.add((int)i2.next());
        }
    }

    public IntBigArrayBigList(IntIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextInt());
        }
    }

    public int[][] elements() {
        return this.a;
    }

    public static IntBigArrayBigList wrap(int[][] a2, long length) {
        if (length > IntBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + IntBigArrays.length(a2) + ")");
        }
        IntBigArrayBigList l2 = new IntBigArrayBigList(a2, false);
        l2.size = length;
        return l2;
    }

    public static IntBigArrayBigList wrap(int[][] a2) {
        return IntBigArrayBigList.wrap(a2, IntBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        this.a = IntBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = IntBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index, int k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            IntBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        IntBigArrays.set(this.a, index, k2);
        ++this.size;
    }

    @Override
    public boolean add(int k2) {
        this.grow(this.size + 1L);
        IntBigArrays.set(this.a, this.size++, k2);
        return true;
    }

    @Override
    public int getInt(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return IntBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(int k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (k2 != IntBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(int k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (k2 != IntBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public int removeInt(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int old = IntBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            IntBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(int k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.removeInt(index);
        return true;
    }

    @Override
    public int set(long index, int k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        int old = IntBigArrays.get(this.a, index);
        IntBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(IntCollection c2) {
        int[] s2 = null;
        int[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((int)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        int[] s2 = null;
        int[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((int)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > IntBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            IntBigArrays.fill(this.a, this.size, size, 0);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = IntBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = IntBigArrays.trim(this.a, Math.max(n2, this.size));
    }

    @Override
    public void getElements(long from, int[][] a2, long offset, long length) {
        IntBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        IntBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, int[][] a2, long offset, long length) {
        this.ensureIndex(index);
        IntBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        IntBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        IntBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public IntBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new AbstractIntBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < IntBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return IntBigArrays.get(IntBigArrayBigList.this.a, this.last);
            }

            @Override
            public int previousInt() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return IntBigArrays.get(IntBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(int k2) {
                IntBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(int k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                IntBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                IntBigArrayBigList.this.removeInt(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public IntBigArrayBigList clone() {
        IntBigArrayBigList c2 = new IntBigArrayBigList(this.size);
        IntBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(IntBigArrayBigList l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        int[][] a1 = this.a;
        int[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (IntBigArrays.get(a1, s2) == IntBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(IntBigArrayBigList l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        int[][] a1 = this.a;
        int[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            int e2;
            int e1 = IntBigArrays.get(a1, i2);
            int r2 = Integer.compare(e1, e2 = IntBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeInt(IntBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = IntBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            IntBigArrays.set(this.a, i2, s2.readInt());
            ++i2;
        }
    }
}

