/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollections;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public class ObjectSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private ObjectSets() {
    }

    public static <K> ObjectSet<K> emptySet() {
        return EMPTY_SET;
    }

    public static <K> ObjectSet<K> singleton(K element) {
        return new Singleton<K>(element);
    }

    public static <K> ObjectSet<K> synchronize(ObjectSet<K> s2) {
        return new SynchronizedSet<K>(s2);
    }

    public static <K> ObjectSet<K> synchronize(ObjectSet<K> s2, Object sync) {
        return new SynchronizedSet<K>(s2, sync);
    }

    public static <K> ObjectSet<K> unmodifiable(ObjectSet<K> s2) {
        return new UnmodifiableSet<K>(s2);
    }

    public static class UnmodifiableSet<K>
    extends ObjectCollections.UnmodifiableCollection<K>
    implements ObjectSet<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(ObjectSet<K> s2) {
            super(s2);
        }

        @Override
        public boolean remove(Object k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }
    }

    public static class SynchronizedSet<K>
    extends ObjectCollections.SynchronizedCollection<K>
    implements ObjectSet<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(ObjectSet<K> s2, Object sync) {
            super(s2, sync);
        }

        protected SynchronizedSet(ObjectSet<K> s2) {
            super(s2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.remove(k2);
            }
        }
    }

    public static class Singleton<K>
    extends AbstractObjectSet<K>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final K element;

        protected Singleton(K element) {
            this.element = element;
        }

        @Override
        public boolean contains(Object k2) {
            return k2 == null ? this.element == null : k2.equals(this.element);
        }

        @Override
        public boolean remove(Object k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return ObjectIterators.singleton(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean addAll(Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptySet<K>
    extends ObjectCollections.EmptyCollection<K>
    implements ObjectSet<K>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof Set && ((Set)o2).isEmpty();
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

