/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.shorts.AbstractShortBigList;
import it.unimi.dsi.fastutil.shorts.AbstractShortBigListIterator;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigList;
import it.unimi.dsi.fastutil.shorts.ShortBigListIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ShortBigArrayBigList
extends AbstractShortBigList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient short[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected ShortBigArrayBigList(short[][] a2, boolean dummy) {
        this.a = a2;
    }

    public ShortBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = ShortBigArrays.newBigArray(capacity);
    }

    public ShortBigArrayBigList() {
        this(16L);
    }

    public ShortBigArrayBigList(ShortCollection c2) {
        this(c2.size());
        ShortIterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add(i2.nextShort());
        }
    }

    public ShortBigArrayBigList(ShortBigList l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public ShortBigArrayBigList(short[][] a2) {
        this(a2, 0L, ShortBigArrays.length(a2));
    }

    public ShortBigArrayBigList(short[][] a2, long offset, long length) {
        this(length);
        ShortBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public ShortBigArrayBigList(Iterator<? extends Short> i2) {
        this();
        while (i2.hasNext()) {
            this.add((short)i2.next());
        }
    }

    public ShortBigArrayBigList(ShortIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextShort());
        }
    }

    public short[][] elements() {
        return this.a;
    }

    public static ShortBigArrayBigList wrap(short[][] a2, long length) {
        if (length > ShortBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + ShortBigArrays.length(a2) + ")");
        }
        ShortBigArrayBigList l2 = new ShortBigArrayBigList(a2, false);
        l2.size = length;
        return l2;
    }

    public static ShortBigArrayBigList wrap(short[][] a2) {
        return ShortBigArrayBigList.wrap(a2, ShortBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        this.a = ShortBigArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(long capacity) {
        this.a = ShortBigArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(long index, short k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            ShortBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        ShortBigArrays.set(this.a, index, k2);
        ++this.size;
    }

    @Override
    public boolean add(short k2) {
        this.grow(this.size + 1L);
        ShortBigArrays.set(this.a, this.size++, k2);
        return true;
    }

    @Override
    public short getShort(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return ShortBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(short k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (k2 != ShortBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(short k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (k2 != ShortBigArrays.get(this.a, i2)) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public short removeShort(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        short old = ShortBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            ShortBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(short k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.removeShort(index);
        return true;
    }

    @Override
    public short set(long index, short k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        short old = ShortBigArrays.get(this.a, index);
        ShortBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(ShortCollection c2) {
        short[] s2 = null;
        short[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((short)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        short[] s2 = null;
        short[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains((short)s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > ShortBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            ShortBigArrays.fill(this.a, this.size, size, (short)0);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = ShortBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = ShortBigArrays.trim(this.a, Math.max(n2, this.size));
    }

    @Override
    public void getElements(long from, short[][] a2, long offset, long length) {
        ShortBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        ShortBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(long index, short[][] a2, long offset, long length) {
        this.ensureIndex(index);
        ShortBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        ShortBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        ShortBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public ShortBigListIterator listIterator(final long index) {
        this.ensureIndex(index);
        return new AbstractShortBigListIterator(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ShortBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ShortBigArrays.get(ShortBigArrayBigList.this.a, this.last);
            }

            @Override
            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ShortBigArrays.get(ShortBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(short k2) {
                ShortBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(short k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                ShortBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                ShortBigArrayBigList.this.removeShort(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public ShortBigArrayBigList clone() {
        ShortBigArrayBigList c2 = new ShortBigArrayBigList(this.size);
        ShortBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(ShortBigArrayBigList l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        short[][] a1 = this.a;
        short[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (ShortBigArrays.get(a1, s2) == ShortBigArrays.get(a2, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ShortBigArrayBigList l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        short[][] a1 = this.a;
        short[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            short e2;
            short e1 = ShortBigArrays.get(a1, i2);
            int r2 = Short.compare(e1, e2 = ShortBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeShort(ShortBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = ShortBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            ShortBigArrays.set(this.a, i2, s2.readShort());
            ++i2;
        }
    }
}

