/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

public class ShortSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private ShortSets() {
    }

    public static ShortSet singleton(short element) {
        return new Singleton(element);
    }

    public static ShortSet singleton(Short element) {
        return new Singleton(element);
    }

    public static ShortSet synchronize(ShortSet s2) {
        return new SynchronizedSet(s2);
    }

    public static ShortSet synchronize(ShortSet s2, Object sync) {
        return new SynchronizedSet(s2, sync);
    }

    public static ShortSet unmodifiable(ShortSet s2) {
        return new UnmodifiableSet(s2);
    }

    public static class UnmodifiableSet
    extends ShortCollections.UnmodifiableCollection
    implements ShortSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(ShortSet s2) {
            super(s2);
        }

        @Override
        public boolean remove(short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        @Deprecated
        public boolean rem(short k2) {
            return super.rem(k2);
        }
    }

    public static class SynchronizedSet
    extends ShortCollections.SynchronizedCollection
    implements ShortSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected SynchronizedSet(ShortSet s2, Object sync) {
            super(s2, sync);
        }

        protected SynchronizedSet(ShortSet s2) {
            super(s2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.rem(k2);
            }
        }

        @Override
        @Deprecated
        public boolean rem(short k2) {
            return super.rem(k2);
        }
    }

    public static class Singleton
    extends AbstractShortSet
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final short element;

        protected Singleton(short element) {
            this.element = element;
        }

        @Override
        public boolean contains(short k2) {
            return k2 == this.element;
        }

        @Override
        public boolean remove(short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShortListIterator iterator() {
            return ShortIterators.singleton(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean addAll(Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptySet
    extends ShortCollections.EmptyCollection
    implements ShortSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(short ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof Set && ((Set)o2).isEmpty();
        }

        @Override
        @Deprecated
        public boolean rem(short k2) {
            return super.rem(k2);
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

