/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatIterable;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class TextIO {
    public static final int BUFFER_SIZE = 8192;

    private TextIO() {
    }

    public static int loadBooleans(BufferedReader reader, boolean[] array, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Boolean.parseBoolean(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadBooleans(BufferedReader reader, boolean[] array) throws IOException {
        return TextIO.loadBooleans(reader, array, 0, array.length);
    }

    public static int loadBooleans(File file, boolean[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadBooleans(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array, int offset, int length) throws IOException {
        return TextIO.loadBooleans(new File(filename.toString()), array, offset, length);
    }

    public static int loadBooleans(File file, boolean[] array) throws IOException {
        return TextIO.loadBooleans(file, array, 0, array.length);
    }

    public static int loadBooleans(CharSequence filename, boolean[] array) throws IOException {
        return TextIO.loadBooleans(filename, array, 0, array.length);
    }

    public static void storeBooleans(boolean[] array, int offset, int length, PrintStream stream) {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeBooleans(boolean[] array, PrintStream stream) {
        TextIO.storeBooleans(array, 0, array.length, stream);
    }

    public static void storeBooleans(boolean[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBooleans(array, offset, length, stream);
        stream.close();
    }

    public static void storeBooleans(boolean[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[] array, File file) throws IOException {
        TextIO.storeBooleans(array, 0, array.length, file);
    }

    public static void storeBooleans(boolean[] array, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array, 0, array.length, filename);
    }

    public static void storeBooleans(BooleanIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextBoolean());
        }
    }

    public static void storeBooleans(BooleanIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBooleans(i2, stream);
        stream.close();
    }

    public static void storeBooleans(BooleanIterator i2, CharSequence filename) throws IOException {
        TextIO.storeBooleans(i2, new File(filename.toString()));
    }

    public static long loadBooleans(BufferedReader reader, boolean[][] array, long offset, long length) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                boolean[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Boolean.parseBoolean(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadBooleans(BufferedReader reader, boolean[][] array) throws IOException {
        return TextIO.loadBooleans(reader, array, 0L, BooleanBigArrays.length(array));
    }

    public static long loadBooleans(File file, boolean[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadBooleans(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array, long offset, long length) throws IOException {
        return TextIO.loadBooleans(new File(filename.toString()), array, offset, length);
    }

    public static long loadBooleans(File file, boolean[][] array) throws IOException {
        return TextIO.loadBooleans(file, array, 0L, BooleanBigArrays.length(array));
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array) throws IOException {
        return TextIO.loadBooleans(filename, array, 0L, BooleanBigArrays.length(array));
    }

    public static void storeBooleans(boolean[][] array, long offset, long length, PrintStream stream) {
        BooleanBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            boolean[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeBooleans(boolean[][] array, PrintStream stream) {
        TextIO.storeBooleans(array, 0L, BooleanBigArrays.length(array), stream);
    }

    public static void storeBooleans(boolean[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBooleans(array, offset, length, stream);
        stream.close();
    }

    public static void storeBooleans(boolean[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[][] array, File file) throws IOException {
        TextIO.storeBooleans(array, 0L, BooleanBigArrays.length(array), file);
    }

    public static void storeBooleans(boolean[][] array, CharSequence filename) throws IOException {
        TextIO.storeBooleans(array, 0L, BooleanBigArrays.length(array), filename);
    }

    public static BooleanIterator asBooleanIterator(BufferedReader reader) {
        return new BooleanReaderWrapper(reader);
    }

    public static BooleanIterator asBooleanIterator(File file) throws IOException {
        return new BooleanReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static BooleanIterator asBooleanIterator(CharSequence filename) throws IOException {
        return TextIO.asBooleanIterator(new File(filename.toString()));
    }

    public static BooleanIterable asBooleanIterable(final File file) {
        return new BooleanIterable(){

            @Override
            public BooleanIterator iterator() {
                try {
                    return TextIO.asBooleanIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static BooleanIterable asBooleanIterable(final CharSequence filename) {
        return new BooleanIterable(){

            @Override
            public BooleanIterator iterator() {
                try {
                    return TextIO.asBooleanIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadBytes(BufferedReader reader, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Byte.parseByte(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadBytes(BufferedReader reader, byte[] array) throws IOException {
        return TextIO.loadBytes(reader, array, 0, array.length);
    }

    public static int loadBytes(File file, byte[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadBytes(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadBytes(CharSequence filename, byte[] array, int offset, int length) throws IOException {
        return TextIO.loadBytes(new File(filename.toString()), array, offset, length);
    }

    public static int loadBytes(File file, byte[] array) throws IOException {
        return TextIO.loadBytes(file, array, 0, array.length);
    }

    public static int loadBytes(CharSequence filename, byte[] array) throws IOException {
        return TextIO.loadBytes(filename, array, 0, array.length);
    }

    public static void storeBytes(byte[] array, int offset, int length, PrintStream stream) {
        ByteArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeBytes(byte[] array, PrintStream stream) {
        TextIO.storeBytes(array, 0, array.length, stream);
    }

    public static void storeBytes(byte[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBytes(array, offset, length, stream);
        stream.close();
    }

    public static void storeBytes(byte[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeBytes(array, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[] array, File file) throws IOException {
        TextIO.storeBytes(array, 0, array.length, file);
    }

    public static void storeBytes(byte[] array, CharSequence filename) throws IOException {
        TextIO.storeBytes(array, 0, array.length, filename);
    }

    public static void storeBytes(ByteIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBytes(i2, stream);
        stream.close();
    }

    public static void storeBytes(ByteIterator i2, CharSequence filename) throws IOException {
        TextIO.storeBytes(i2, new File(filename.toString()));
    }

    public static long loadBytes(BufferedReader reader, byte[][] array, long offset, long length) throws IOException {
        ByteBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                byte[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Byte.parseByte(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadBytes(BufferedReader reader, byte[][] array) throws IOException {
        return TextIO.loadBytes(reader, array, 0L, ByteBigArrays.length(array));
    }

    public static long loadBytes(File file, byte[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadBytes(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadBytes(CharSequence filename, byte[][] array, long offset, long length) throws IOException {
        return TextIO.loadBytes(new File(filename.toString()), array, offset, length);
    }

    public static long loadBytes(File file, byte[][] array) throws IOException {
        return TextIO.loadBytes(file, array, 0L, ByteBigArrays.length(array));
    }

    public static long loadBytes(CharSequence filename, byte[][] array) throws IOException {
        return TextIO.loadBytes(filename, array, 0L, ByteBigArrays.length(array));
    }

    public static void storeBytes(byte[][] array, long offset, long length, PrintStream stream) {
        ByteBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            byte[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeBytes(byte[][] array, PrintStream stream) {
        TextIO.storeBytes(array, 0L, ByteBigArrays.length(array), stream);
    }

    public static void storeBytes(byte[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeBytes(array, offset, length, stream);
        stream.close();
    }

    public static void storeBytes(byte[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeBytes(array, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[][] array, File file) throws IOException {
        TextIO.storeBytes(array, 0L, ByteBigArrays.length(array), file);
    }

    public static void storeBytes(byte[][] array, CharSequence filename) throws IOException {
        TextIO.storeBytes(array, 0L, ByteBigArrays.length(array), filename);
    }

    public static ByteIterator asByteIterator(BufferedReader reader) {
        return new ByteReaderWrapper(reader);
    }

    public static ByteIterator asByteIterator(File file) throws IOException {
        return new ByteReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return TextIO.asByteIterator(new File(filename.toString()));
    }

    public static ByteIterable asByteIterable(final File file) {
        return new ByteIterable(){

            @Override
            public ByteIterator iterator() {
                try {
                    return TextIO.asByteIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ByteIterable asByteIterable(final CharSequence filename) {
        return new ByteIterable(){

            @Override
            public ByteIterator iterator() {
                try {
                    return TextIO.asByteIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadShorts(BufferedReader reader, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Short.parseShort(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadShorts(BufferedReader reader, short[] array) throws IOException {
        return TextIO.loadShorts(reader, array, 0, array.length);
    }

    public static int loadShorts(File file, short[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadShorts(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadShorts(CharSequence filename, short[] array, int offset, int length) throws IOException {
        return TextIO.loadShorts(new File(filename.toString()), array, offset, length);
    }

    public static int loadShorts(File file, short[] array) throws IOException {
        return TextIO.loadShorts(file, array, 0, array.length);
    }

    public static int loadShorts(CharSequence filename, short[] array) throws IOException {
        return TextIO.loadShorts(filename, array, 0, array.length);
    }

    public static void storeShorts(short[] array, int offset, int length, PrintStream stream) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeShorts(short[] array, PrintStream stream) {
        TextIO.storeShorts(array, 0, array.length, stream);
    }

    public static void storeShorts(short[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeShorts(array, offset, length, stream);
        stream.close();
    }

    public static void storeShorts(short[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeShorts(array, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[] array, File file) throws IOException {
        TextIO.storeShorts(array, 0, array.length, file);
    }

    public static void storeShorts(short[] array, CharSequence filename) throws IOException {
        TextIO.storeShorts(array, 0, array.length, filename);
    }

    public static void storeShorts(ShortIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeShorts(i2, stream);
        stream.close();
    }

    public static void storeShorts(ShortIterator i2, CharSequence filename) throws IOException {
        TextIO.storeShorts(i2, new File(filename.toString()));
    }

    public static long loadShorts(BufferedReader reader, short[][] array, long offset, long length) throws IOException {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                short[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Short.parseShort(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadShorts(BufferedReader reader, short[][] array) throws IOException {
        return TextIO.loadShorts(reader, array, 0L, ShortBigArrays.length(array));
    }

    public static long loadShorts(File file, short[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadShorts(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadShorts(CharSequence filename, short[][] array, long offset, long length) throws IOException {
        return TextIO.loadShorts(new File(filename.toString()), array, offset, length);
    }

    public static long loadShorts(File file, short[][] array) throws IOException {
        return TextIO.loadShorts(file, array, 0L, ShortBigArrays.length(array));
    }

    public static long loadShorts(CharSequence filename, short[][] array) throws IOException {
        return TextIO.loadShorts(filename, array, 0L, ShortBigArrays.length(array));
    }

    public static void storeShorts(short[][] array, long offset, long length, PrintStream stream) {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            short[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeShorts(short[][] array, PrintStream stream) {
        TextIO.storeShorts(array, 0L, ShortBigArrays.length(array), stream);
    }

    public static void storeShorts(short[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeShorts(array, offset, length, stream);
        stream.close();
    }

    public static void storeShorts(short[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeShorts(array, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[][] array, File file) throws IOException {
        TextIO.storeShorts(array, 0L, ShortBigArrays.length(array), file);
    }

    public static void storeShorts(short[][] array, CharSequence filename) throws IOException {
        TextIO.storeShorts(array, 0L, ShortBigArrays.length(array), filename);
    }

    public static ShortIterator asShortIterator(BufferedReader reader) {
        return new ShortReaderWrapper(reader);
    }

    public static ShortIterator asShortIterator(File file) throws IOException {
        return new ShortReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return TextIO.asShortIterator(new File(filename.toString()));
    }

    public static ShortIterable asShortIterable(final File file) {
        return new ShortIterable(){

            @Override
            public ShortIterator iterator() {
                try {
                    return TextIO.asShortIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ShortIterable asShortIterable(final CharSequence filename) {
        return new ShortIterable(){

            @Override
            public ShortIterator iterator() {
                try {
                    return TextIO.asShortIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadInts(BufferedReader reader, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Integer.parseInt(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadInts(BufferedReader reader, int[] array) throws IOException {
        return TextIO.loadInts(reader, array, 0, array.length);
    }

    public static int loadInts(File file, int[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadInts(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadInts(CharSequence filename, int[] array, int offset, int length) throws IOException {
        return TextIO.loadInts(new File(filename.toString()), array, offset, length);
    }

    public static int loadInts(File file, int[] array) throws IOException {
        return TextIO.loadInts(file, array, 0, array.length);
    }

    public static int loadInts(CharSequence filename, int[] array) throws IOException {
        return TextIO.loadInts(filename, array, 0, array.length);
    }

    public static void storeInts(int[] array, int offset, int length, PrintStream stream) {
        IntArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeInts(int[] array, PrintStream stream) {
        TextIO.storeInts(array, 0, array.length, stream);
    }

    public static void storeInts(int[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeInts(array, offset, length, stream);
        stream.close();
    }

    public static void storeInts(int[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeInts(array, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[] array, File file) throws IOException {
        TextIO.storeInts(array, 0, array.length, file);
    }

    public static void storeInts(int[] array, CharSequence filename) throws IOException {
        TextIO.storeInts(array, 0, array.length, filename);
    }

    public static void storeInts(IntIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextInt());
        }
    }

    public static void storeInts(IntIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeInts(i2, stream);
        stream.close();
    }

    public static void storeInts(IntIterator i2, CharSequence filename) throws IOException {
        TextIO.storeInts(i2, new File(filename.toString()));
    }

    public static long loadInts(BufferedReader reader, int[][] array, long offset, long length) throws IOException {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                int[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Integer.parseInt(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadInts(BufferedReader reader, int[][] array) throws IOException {
        return TextIO.loadInts(reader, array, 0L, IntBigArrays.length(array));
    }

    public static long loadInts(File file, int[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadInts(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadInts(CharSequence filename, int[][] array, long offset, long length) throws IOException {
        return TextIO.loadInts(new File(filename.toString()), array, offset, length);
    }

    public static long loadInts(File file, int[][] array) throws IOException {
        return TextIO.loadInts(file, array, 0L, IntBigArrays.length(array));
    }

    public static long loadInts(CharSequence filename, int[][] array) throws IOException {
        return TextIO.loadInts(filename, array, 0L, IntBigArrays.length(array));
    }

    public static void storeInts(int[][] array, long offset, long length, PrintStream stream) {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            int[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeInts(int[][] array, PrintStream stream) {
        TextIO.storeInts(array, 0L, IntBigArrays.length(array), stream);
    }

    public static void storeInts(int[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeInts(array, offset, length, stream);
        stream.close();
    }

    public static void storeInts(int[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeInts(array, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[][] array, File file) throws IOException {
        TextIO.storeInts(array, 0L, IntBigArrays.length(array), file);
    }

    public static void storeInts(int[][] array, CharSequence filename) throws IOException {
        TextIO.storeInts(array, 0L, IntBigArrays.length(array), filename);
    }

    public static IntIterator asIntIterator(BufferedReader reader) {
        return new IntReaderWrapper(reader);
    }

    public static IntIterator asIntIterator(File file) throws IOException {
        return new IntReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return TextIO.asIntIterator(new File(filename.toString()));
    }

    public static IntIterable asIntIterable(final File file) {
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                try {
                    return TextIO.asIntIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static IntIterable asIntIterable(final CharSequence filename) {
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                try {
                    return TextIO.asIntIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadLongs(BufferedReader reader, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Long.parseLong(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadLongs(BufferedReader reader, long[] array) throws IOException {
        return TextIO.loadLongs(reader, array, 0, array.length);
    }

    public static int loadLongs(File file, long[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadLongs(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadLongs(CharSequence filename, long[] array, int offset, int length) throws IOException {
        return TextIO.loadLongs(new File(filename.toString()), array, offset, length);
    }

    public static int loadLongs(File file, long[] array) throws IOException {
        return TextIO.loadLongs(file, array, 0, array.length);
    }

    public static int loadLongs(CharSequence filename, long[] array) throws IOException {
        return TextIO.loadLongs(filename, array, 0, array.length);
    }

    public static void storeLongs(long[] array, int offset, int length, PrintStream stream) {
        LongArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeLongs(long[] array, PrintStream stream) {
        TextIO.storeLongs(array, 0, array.length, stream);
    }

    public static void storeLongs(long[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeLongs(array, offset, length, stream);
        stream.close();
    }

    public static void storeLongs(long[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeLongs(array, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[] array, File file) throws IOException {
        TextIO.storeLongs(array, 0, array.length, file);
    }

    public static void storeLongs(long[] array, CharSequence filename) throws IOException {
        TextIO.storeLongs(array, 0, array.length, filename);
    }

    public static void storeLongs(LongIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextLong());
        }
    }

    public static void storeLongs(LongIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeLongs(i2, stream);
        stream.close();
    }

    public static void storeLongs(LongIterator i2, CharSequence filename) throws IOException {
        TextIO.storeLongs(i2, new File(filename.toString()));
    }

    public static long loadLongs(BufferedReader reader, long[][] array, long offset, long length) throws IOException {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                long[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Long.parseLong(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadLongs(BufferedReader reader, long[][] array) throws IOException {
        return TextIO.loadLongs(reader, array, 0L, LongBigArrays.length(array));
    }

    public static long loadLongs(File file, long[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadLongs(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadLongs(CharSequence filename, long[][] array, long offset, long length) throws IOException {
        return TextIO.loadLongs(new File(filename.toString()), array, offset, length);
    }

    public static long loadLongs(File file, long[][] array) throws IOException {
        return TextIO.loadLongs(file, array, 0L, LongBigArrays.length(array));
    }

    public static long loadLongs(CharSequence filename, long[][] array) throws IOException {
        return TextIO.loadLongs(filename, array, 0L, LongBigArrays.length(array));
    }

    public static void storeLongs(long[][] array, long offset, long length, PrintStream stream) {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            long[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeLongs(long[][] array, PrintStream stream) {
        TextIO.storeLongs(array, 0L, LongBigArrays.length(array), stream);
    }

    public static void storeLongs(long[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeLongs(array, offset, length, stream);
        stream.close();
    }

    public static void storeLongs(long[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeLongs(array, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[][] array, File file) throws IOException {
        TextIO.storeLongs(array, 0L, LongBigArrays.length(array), file);
    }

    public static void storeLongs(long[][] array, CharSequence filename) throws IOException {
        TextIO.storeLongs(array, 0L, LongBigArrays.length(array), filename);
    }

    public static LongIterator asLongIterator(BufferedReader reader) {
        return new LongReaderWrapper(reader);
    }

    public static LongIterator asLongIterator(File file) throws IOException {
        return new LongReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return TextIO.asLongIterator(new File(filename.toString()));
    }

    public static LongIterable asLongIterable(final File file) {
        return new LongIterable(){

            @Override
            public LongIterator iterator() {
                try {
                    return TextIO.asLongIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static LongIterable asLongIterable(final CharSequence filename) {
        return new LongIterable(){

            @Override
            public LongIterator iterator() {
                try {
                    return TextIO.asLongIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadFloats(BufferedReader reader, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Float.parseFloat(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadFloats(BufferedReader reader, float[] array) throws IOException {
        return TextIO.loadFloats(reader, array, 0, array.length);
    }

    public static int loadFloats(File file, float[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadFloats(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadFloats(CharSequence filename, float[] array, int offset, int length) throws IOException {
        return TextIO.loadFloats(new File(filename.toString()), array, offset, length);
    }

    public static int loadFloats(File file, float[] array) throws IOException {
        return TextIO.loadFloats(file, array, 0, array.length);
    }

    public static int loadFloats(CharSequence filename, float[] array) throws IOException {
        return TextIO.loadFloats(filename, array, 0, array.length);
    }

    public static void storeFloats(float[] array, int offset, int length, PrintStream stream) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeFloats(float[] array, PrintStream stream) {
        TextIO.storeFloats(array, 0, array.length, stream);
    }

    public static void storeFloats(float[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeFloats(array, offset, length, stream);
        stream.close();
    }

    public static void storeFloats(float[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeFloats(array, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[] array, File file) throws IOException {
        TextIO.storeFloats(array, 0, array.length, file);
    }

    public static void storeFloats(float[] array, CharSequence filename) throws IOException {
        TextIO.storeFloats(array, 0, array.length, filename);
    }

    public static void storeFloats(FloatIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeFloats(i2, stream);
        stream.close();
    }

    public static void storeFloats(FloatIterator i2, CharSequence filename) throws IOException {
        TextIO.storeFloats(i2, new File(filename.toString()));
    }

    public static long loadFloats(BufferedReader reader, float[][] array, long offset, long length) throws IOException {
        FloatBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                float[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Float.parseFloat(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadFloats(BufferedReader reader, float[][] array) throws IOException {
        return TextIO.loadFloats(reader, array, 0L, FloatBigArrays.length(array));
    }

    public static long loadFloats(File file, float[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadFloats(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadFloats(CharSequence filename, float[][] array, long offset, long length) throws IOException {
        return TextIO.loadFloats(new File(filename.toString()), array, offset, length);
    }

    public static long loadFloats(File file, float[][] array) throws IOException {
        return TextIO.loadFloats(file, array, 0L, FloatBigArrays.length(array));
    }

    public static long loadFloats(CharSequence filename, float[][] array) throws IOException {
        return TextIO.loadFloats(filename, array, 0L, FloatBigArrays.length(array));
    }

    public static void storeFloats(float[][] array, long offset, long length, PrintStream stream) {
        FloatBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            float[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeFloats(float[][] array, PrintStream stream) {
        TextIO.storeFloats(array, 0L, FloatBigArrays.length(array), stream);
    }

    public static void storeFloats(float[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeFloats(array, offset, length, stream);
        stream.close();
    }

    public static void storeFloats(float[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeFloats(array, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[][] array, File file) throws IOException {
        TextIO.storeFloats(array, 0L, FloatBigArrays.length(array), file);
    }

    public static void storeFloats(float[][] array, CharSequence filename) throws IOException {
        TextIO.storeFloats(array, 0L, FloatBigArrays.length(array), filename);
    }

    public static FloatIterator asFloatIterator(BufferedReader reader) {
        return new FloatReaderWrapper(reader);
    }

    public static FloatIterator asFloatIterator(File file) throws IOException {
        return new FloatReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return TextIO.asFloatIterator(new File(filename.toString()));
    }

    public static FloatIterable asFloatIterable(final File file) {
        return new FloatIterable(){

            @Override
            public FloatIterator iterator() {
                try {
                    return TextIO.asFloatIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static FloatIterable asFloatIterable(final CharSequence filename) {
        return new FloatIterable(){

            @Override
            public FloatIterator iterator() {
                try {
                    return TextIO.asFloatIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadDoubles(BufferedReader reader, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            String s2;
            for (i2 = 0; i2 < length && (s2 = reader.readLine()) != null; ++i2) {
                array[i2 + offset] = Double.parseDouble(s2.trim());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadDoubles(BufferedReader reader, double[] array) throws IOException {
        return TextIO.loadDoubles(reader, array, 0, array.length);
    }

    public static int loadDoubles(File file, double[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int result = TextIO.loadDoubles(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadDoubles(CharSequence filename, double[] array, int offset, int length) throws IOException {
        return TextIO.loadDoubles(new File(filename.toString()), array, offset, length);
    }

    public static int loadDoubles(File file, double[] array) throws IOException {
        return TextIO.loadDoubles(file, array, 0, array.length);
    }

    public static int loadDoubles(CharSequence filename, double[] array) throws IOException {
        return TextIO.loadDoubles(filename, array, 0, array.length);
    }

    public static void storeDoubles(double[] array, int offset, int length, PrintStream stream) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            stream.println(array[offset + i2]);
        }
    }

    public static void storeDoubles(double[] array, PrintStream stream) {
        TextIO.storeDoubles(array, 0, array.length, stream);
    }

    public static void storeDoubles(double[] array, int offset, int length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeDoubles(array, offset, length, stream);
        stream.close();
    }

    public static void storeDoubles(double[] array, int offset, int length, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[] array, File file) throws IOException {
        TextIO.storeDoubles(array, 0, array.length, file);
    }

    public static void storeDoubles(double[] array, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array, 0, array.length, filename);
    }

    public static void storeDoubles(DoubleIterator i2, PrintStream stream) {
        while (i2.hasNext()) {
            stream.println(i2.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i2, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeDoubles(i2, stream);
        stream.close();
    }

    public static void storeDoubles(DoubleIterator i2, CharSequence filename) throws IOException {
        TextIO.storeDoubles(i2, new File(filename.toString()));
    }

    public static long loadDoubles(BufferedReader reader, double[][] array, long offset, long length) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                double[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    String s2 = reader.readLine();
                    if (s2 == null) {
                        return c2;
                    }
                    t2[d2] = Double.parseDouble(s2.trim());
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadDoubles(BufferedReader reader, double[][] array) throws IOException {
        return TextIO.loadDoubles(reader, array, 0L, DoubleBigArrays.length(array));
    }

    public static long loadDoubles(File file, double[][] array, long offset, long length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long result = TextIO.loadDoubles(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static long loadDoubles(CharSequence filename, double[][] array, long offset, long length) throws IOException {
        return TextIO.loadDoubles(new File(filename.toString()), array, offset, length);
    }

    public static long loadDoubles(File file, double[][] array) throws IOException {
        return TextIO.loadDoubles(file, array, 0L, DoubleBigArrays.length(array));
    }

    public static long loadDoubles(CharSequence filename, double[][] array) throws IOException {
        return TextIO.loadDoubles(filename, array, 0L, DoubleBigArrays.length(array));
    }

    public static void storeDoubles(double[][] array, long offset, long length, PrintStream stream) {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            double[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                stream.println(t2[d2]);
            }
        }
    }

    public static void storeDoubles(double[][] array, PrintStream stream) {
        TextIO.storeDoubles(array, 0L, DoubleBigArrays.length(array), stream);
    }

    public static void storeDoubles(double[][] array, long offset, long length, File file) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        TextIO.storeDoubles(array, offset, length, stream);
        stream.close();
    }

    public static void storeDoubles(double[][] array, long offset, long length, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[][] array, File file) throws IOException {
        TextIO.storeDoubles(array, 0L, DoubleBigArrays.length(array), file);
    }

    public static void storeDoubles(double[][] array, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array, 0L, DoubleBigArrays.length(array), filename);
    }

    public static DoubleIterator asDoubleIterator(BufferedReader reader) {
        return new DoubleReaderWrapper(reader);
    }

    public static DoubleIterator asDoubleIterator(File file) throws IOException {
        return new DoubleReaderWrapper(new BufferedReader(new FileReader(file)));
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return TextIO.asDoubleIterator(new File(filename.toString()));
    }

    public static DoubleIterable asDoubleIterable(final File file) {
        return new DoubleIterable(){

            @Override
            public DoubleIterator iterator() {
                try {
                    return TextIO.asDoubleIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static DoubleIterable asDoubleIterable(final CharSequence filename) {
        return new DoubleIterable(){

            @Override
            public DoubleIterator iterator() {
                try {
                    return TextIO.asDoubleIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    private static final class DoubleReaderWrapper
    extends AbstractDoubleIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private double next;

        public DoubleReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Double.parseDouble(this.s.trim());
            return true;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class FloatReaderWrapper
    extends AbstractFloatIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private float next;

        public FloatReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Float.parseFloat(this.s.trim());
            return true;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongReaderWrapper
    extends AbstractLongIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private long next;

        public LongReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Long.parseLong(this.s.trim());
            return true;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntReaderWrapper
    extends AbstractIntIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private int next;

        public IntReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Integer.parseInt(this.s.trim());
            return true;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortReaderWrapper
    extends AbstractShortIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private short next;

        public ShortReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Short.parseShort(this.s.trim());
            return true;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteReaderWrapper
    extends AbstractByteIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private byte next;

        public ByteReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Byte.parseByte(this.s.trim());
            return true;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class BooleanReaderWrapper
    extends AbstractBooleanIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private boolean next;

        public BooleanReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Boolean.parseBoolean(this.s.trim());
            return true;
        }

        @Override
        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

