/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.AbstractLongPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeaps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongHeapPriorityQueue
extends AbstractLongPriorityQueue
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient long[] heap = LongArrays.EMPTY_ARRAY;
    protected int size;
    protected LongComparator c;

    public LongHeapPriorityQueue(int capacity, LongComparator c2) {
        if (capacity > 0) {
            this.heap = new long[capacity];
        }
        this.c = c2;
    }

    public LongHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public LongHeapPriorityQueue(LongComparator c2) {
        this(0, c2);
    }

    public LongHeapPriorityQueue() {
        this(0, null);
    }

    public LongHeapPriorityQueue(long[] a2, int size, LongComparator c2) {
        this(c2);
        this.heap = a2;
        this.size = size;
        LongHeaps.makeHeap(a2, size, c2);
    }

    public LongHeapPriorityQueue(long[] a2, LongComparator c2) {
        this(a2, a2.length, c2);
    }

    public LongHeapPriorityQueue(long[] a2, int size) {
        this(a2, size, null);
    }

    public LongHeapPriorityQueue(long[] a2) {
        this(a2, a2.length);
    }

    public LongHeapPriorityQueue(LongCollection collection, LongComparator c2) {
        this(collection.toLongArray(), c2);
    }

    public LongHeapPriorityQueue(LongCollection collection) {
        this(collection, (LongComparator)null);
    }

    public LongHeapPriorityQueue(Collection<? extends Long> collection, LongComparator c2) {
        this(collection.size(), c2);
        Iterator<? extends Long> iterator = collection.iterator();
        int size = collection.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.heap[i2] = iterator.next();
        }
    }

    public LongHeapPriorityQueue(Collection<? extends Long> collection) {
        this(collection, null);
    }

    @Override
    public void enqueue(long x2) {
        if (this.size == this.heap.length) {
            this.heap = LongArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x2;
        LongHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    @Override
    public long dequeueLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        long result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            LongHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    @Override
    public long firstLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.heap[0];
    }

    @Override
    public void changed() {
        LongHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = LongArrays.trim(this.heap, this.size);
    }

    @Override
    public LongComparator comparator() {
        return this.c;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.heap.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeLong(this.heap[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.heap = new long[s2.readInt()];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.heap[i2] = s2.readLong();
        }
    }
}

