/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;

public class ReferenceArraySet<K>
extends AbstractReferenceSet<K>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Object[] a;
    private int size;

    public ReferenceArraySet(Object[] a2) {
        this.a = a2;
        this.size = a2.length;
    }

    public ReferenceArraySet() {
        this.a = ObjectArrays.EMPTY_ARRAY;
    }

    public ReferenceArraySet(int capacity) {
        this.a = new Object[capacity];
    }

    public ReferenceArraySet(ReferenceCollection<K> c2) {
        this(c2.size());
        this.addAll(c2);
    }

    public ReferenceArraySet(Collection<? extends K> c2) {
        this(c2.size());
        this.addAll(c2);
    }

    public ReferenceArraySet(Object[] a2, int size) {
        this.a = a2;
        this.size = size;
        if (size > a2.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a2.length + ")");
        }
    }

    private int findKey(Object o2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (this.a[i2] != o2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return new AbstractObjectIterator<K>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < ReferenceArraySet.this.size;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ReferenceArraySet.this.a[this.next++];
            }

            @Override
            public void remove() {
                int tail = ReferenceArraySet.this.size-- - this.next--;
                System.arraycopy(ReferenceArraySet.this.a, this.next + 1, ReferenceArraySet.this.a, this.next, tail);
                ((ReferenceArraySet)ReferenceArraySet.this).a[((ReferenceArraySet)ReferenceArraySet.this).size] = null;
            }
        };
    }

    @Override
    public boolean contains(Object k2) {
        return this.findKey(k2) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object k2) {
        int pos = this.findKey(k2);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i2 = 0; i2 < tail; ++i2) {
            this.a[pos + i2] = this.a[pos + i2 + 1];
        }
        --this.size;
        this.a[this.size] = null;
        return true;
    }

    @Override
    public boolean add(K k2) {
        int pos = this.findKey(k2);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            Object[] b2 = new Object[this.size == 0 ? 2 : this.size * 2];
            int i2 = this.size;
            while (i2-- != 0) {
                b2[i2] = this.a[i2];
            }
            this.a = b2;
        }
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public ReferenceArraySet<K> clone() {
        ReferenceArraySet c2;
        try {
            c2 = (ReferenceArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.a = (Object[])this.a.clone();
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeObject(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readObject();
        }
    }
}

