/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortList;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;

public class ShortLists {
    public static final EmptyList EMPTY_LIST = new EmptyList();

    private ShortLists() {
    }

    public static ShortList shuffle(ShortList l2, Random random) {
        int i2 = l2.size();
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            short t2 = l2.getShort(i2);
            l2.set(i2, l2.getShort(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static ShortList singleton(short element) {
        return new Singleton(element);
    }

    public static ShortList singleton(Object element) {
        return new Singleton((Short)element);
    }

    public static ShortList synchronize(ShortList l2) {
        return l2 instanceof RandomAccess ? new SynchronizedRandomAccessList(l2) : new SynchronizedList(l2);
    }

    public static ShortList synchronize(ShortList l2, Object sync) {
        return l2 instanceof RandomAccess ? new SynchronizedRandomAccessList(l2, sync) : new SynchronizedList(l2, sync);
    }

    public static ShortList unmodifiable(ShortList l2) {
        return l2 instanceof RandomAccess ? new UnmodifiableRandomAccessList(l2) : new UnmodifiableList(l2);
    }

    public static class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected UnmodifiableRandomAccessList(ShortList l2) {
            super(l2);
        }

        @Override
        public ShortList subList(int from, int to) {
            return new UnmodifiableRandomAccessList(this.list.subList(from, to));
        }
    }

    public static class UnmodifiableList
    extends ShortCollections.UnmodifiableCollection
    implements ShortList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortList list;

        protected UnmodifiableList(ShortList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public short getShort(int i2) {
            return this.list.getShort(i2);
        }

        @Override
        public short set(int i2, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i2, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short removeShort(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(short k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public int lastIndexOf(short k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(int from, short[] a2, int offset, int length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, short[] a2, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, short[] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(int size) {
            this.list.size(size);
        }

        @Override
        public ShortListIterator listIterator() {
            return ShortIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public ShortListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public ShortListIterator listIterator(int i2) {
            return ShortIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        @Deprecated
        public ShortListIterator shortListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public ShortListIterator shortListIterator(int i2) {
            return this.listIterator(i2);
        }

        @Override
        public ShortList subList(int from, int to) {
            return new UnmodifiableList(this.list.subList(from, to));
        }

        @Override
        @Deprecated
        public ShortList shortSubList(int from, int to) {
            return this.subList(from, to);
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public int compareTo(List<? extends Short> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(int index, ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ShortList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short get(int i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(int i2, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short set(int index, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short remove(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public int indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public int lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected SynchronizedRandomAccessList(ShortList l2, Object sync) {
            super(l2, sync);
        }

        protected SynchronizedRandomAccessList(ShortList l2) {
            super(l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ShortList subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(from, to), this.sync);
            }
        }
    }

    public static class SynchronizedList
    extends ShortCollections.SynchronizedCollection
    implements ShortList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortList list;

        protected SynchronizedList(ShortList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedList(ShortList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getShort(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getShort(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short set(int i2, short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int i2, short k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short removeShort(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeShort(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends Short> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(int from, short[] a2, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int index, short[] a2, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int index, short[] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        @Override
        public ShortListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ShortListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public ShortListIterator listIterator(int i2) {
            return this.list.listIterator(i2);
        }

        @Override
        @Deprecated
        public ShortListIterator shortListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public ShortListIterator shortListIterator(int i2) {
            return this.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ShortList subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.subList(from, to), this.sync);
            }
        }

        @Override
        @Deprecated
        public ShortList shortSubList(int from, int to) {
            return this.subList(from, to);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(List<? extends Short> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, ShortCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, ShortList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(ShortList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short get(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(int i2, Short k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short set(int index, Short k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short remove(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public int indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public int lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s2) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s2.defaultWriteObject();
            }
        }
    }

    public static class Singleton
    extends AbstractShortList
    implements RandomAccess,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final short element;

        private Singleton(short element) {
            this.element = element;
        }

        @Override
        public short getShort(int i2) {
            if (i2 == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short removeShort(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(short k2) {
            return k2 == this.element;
        }

        @Override
        public short[] toShortArray() {
            short[] a2 = new short[]{this.element};
            return a2;
        }

        @Override
        public ShortListIterator listIterator() {
            return ShortIterators.singleton(this.element);
        }

        @Override
        public ShortListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public ShortListIterator listIterator(int i2) {
            if (i2 > 1 || i2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            ShortListIterator l2 = this.listIterator();
            if (i2 == 1) {
                l2.next();
            }
            return l2;
        }

        @Override
        public ShortList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return EMPTY_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, ShortList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyList
    extends ShortCollections.EmptyCollection
    implements ShortList,
    RandomAccess,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyList() {
        }

        @Override
        public short getShort(int i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short removeShort(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short set(int index, short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(short k2) {
            return -1;
        }

        @Override
        public int lastIndexOf(short k2) {
            return -1;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends Short> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ShortList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, ShortCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int i2, ShortList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(int index, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short set(int index, Short k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Short remove(int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public int indexOf(Object k2) {
            return -1;
        }

        @Override
        @Deprecated
        public int lastIndexOf(Object k2) {
            return -1;
        }

        @Override
        public ShortListIterator listIterator() {
            return ShortIterators.EMPTY_ITERATOR;
        }

        @Override
        public ShortListIterator iterator() {
            return ShortIterators.EMPTY_ITERATOR;
        }

        @Override
        public ShortListIterator listIterator(int i2) {
            if (i2 == 0) {
                return ShortIterators.EMPTY_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        @Deprecated
        public ShortListIterator shortListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public ShortListIterator shortListIterator(int i2) {
            return this.listIterator(i2);
        }

        @Override
        public ShortList subList(int from, int to) {
            if (from == 0 && to == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public ShortList shortSubList(int from, int to) {
            return this.subList(from, to);
        }

        @Override
        public void getElements(int from, short[] a2, int offset, int length) {
            if (from == 0 && length == 0 && offset >= 0 && offset <= a2.length) {
                return;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, short[] a2, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, short[] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(int s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(List<? extends Short> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof List && ((List)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }
}

