/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractDoubleList
extends AbstractDoubleCollection
implements DoubleList,
DoubleStack {
    protected AbstractDoubleList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index, double k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double k2) {
        this.add(this.size(), k2);
        return true;
    }

    @Override
    public double removeDouble(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double set(int index, double k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Double> c2) {
        this.ensureIndex(index);
        Iterator<? extends Double> i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index++, i2.next());
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    @Deprecated
    public DoubleListIterator doubleListIterator() {
        return this.listIterator();
    }

    @Override
    @Deprecated
    public DoubleListIterator doubleListIterator(int index) {
        return this.listIterator(index);
    }

    @Override
    public DoubleListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public DoubleListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractDoubleListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractDoubleList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractDoubleList.this.getDouble(this.last);
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractDoubleList.this.getDouble(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(double k2) {
                AbstractDoubleList.this.add(this.pos++, k2);
                this.last = -1;
            }

            @Override
            public void set(double k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(double k2) {
        return this.indexOf(k2) >= 0;
    }

    @Override
    public int indexOf(double k2) {
        DoubleListIterator i2 = this.listIterator();
        while (i2.hasNext()) {
            double e2 = i2.nextDouble();
            if (Double.doubleToLongBits(k2) != Double.doubleToLongBits(e2)) continue;
            return i2.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double k2) {
        DoubleListIterator i2 = this.listIterator(this.size());
        while (i2.hasPrevious()) {
            double e2 = i2.previousDouble();
            if (Double.doubleToLongBits(k2) != Double.doubleToLongBits(e2)) continue;
            return i2.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size) {
        int i2 = this.size();
        if (size > i2) {
            while (i2++ < size) {
                this.add(0.0);
            }
        } else {
            while (i2-- != size) {
                this.remove(i2);
            }
        }
    }

    @Override
    public DoubleList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new DoubleSubList(this, from, to);
    }

    @Override
    @Deprecated
    public DoubleList doubleSubList(int from, int to) {
        return this.subList(from, to);
    }

    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        DoubleListIterator i2 = this.listIterator(from);
        int n2 = to - from;
        if (n2 < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n2-- != 0) {
            i2.nextDouble();
            i2.remove();
        }
    }

    @Override
    public void addElements(int index, double[] a2, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a2[offset++]);
        }
    }

    @Override
    public void addElements(int index, double[] a2) {
        this.addElements(index, a2, 0, a2.length);
    }

    @Override
    public void getElements(int from, double[] a2, int offset, int length) {
        DoubleListIterator i2 = this.listIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a2.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a2.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a2[offset++] = i2.nextDouble();
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    private boolean valEquals(Object a2, Object b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    @Override
    public int hashCode() {
        DoubleListIterator i2 = this.iterator();
        int h2 = 1;
        int s2 = this.size();
        while (s2-- != 0) {
            double k2 = i2.nextDouble();
            h2 = 31 * h2 + HashCommon.double2int(k2);
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List l2 = (List)o2;
        int s2 = this.size();
        if (s2 != l2.size()) {
            return false;
        }
        if (l2 instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l2).listIterator();
            while (s2-- != 0) {
                if (i1.nextDouble() == i2.nextDouble()) continue;
                return false;
            }
            return true;
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator i2 = l2.listIterator();
        while (s2-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Double> l2) {
        if (l2 == this) {
            return 0;
        }
        if (l2 instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l2).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                double e2;
                double e1 = i1.nextDouble();
                int r2 = Double.compare(e1, e2 = i2.nextDouble());
                if (r2 == 0) continue;
                return r2;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator<? extends Double> i2 = l2.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r3 = ((Comparable)i1.next()).compareTo(i2.next());
            if (r3 == 0) continue;
            return r3;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public void push(double o2) {
        this.add(o2);
    }

    @Override
    public double popDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeDouble(this.size() - 1);
    }

    @Override
    public double topDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getDouble(this.size() - 1);
    }

    @Override
    public double peekDouble(int i2) {
        return this.getDouble(this.size() - 1 - i2);
    }

    @Override
    public boolean rem(double k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.removeDouble(index);
        return true;
    }

    @Override
    public boolean addAll(int index, DoubleCollection c2) {
        this.ensureIndex(index);
        DoubleIterator i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index++, i2.nextDouble());
        }
        return retVal;
    }

    @Override
    public boolean addAll(int index, DoubleList l2) {
        return this.addAll(index, (DoubleCollection)l2);
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        return this.addAll(this.size(), c2);
    }

    @Override
    public boolean addAll(DoubleList l2) {
        return this.addAll(this.size(), l2);
    }

    @Override
    @Deprecated
    public void add(int index, Double ok) {
        this.add(index, (double)ok);
    }

    @Override
    @Deprecated
    public Double set(int index, Double ok) {
        return this.set(index, (double)ok);
    }

    @Override
    @Deprecated
    public Double get(int index) {
        return this.getDouble(index);
    }

    @Override
    @Deprecated
    public int indexOf(Object ok) {
        return this.indexOf((Double)ok);
    }

    @Override
    @Deprecated
    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Double)ok);
    }

    @Override
    @Deprecated
    public Double remove(int index) {
        return this.removeDouble(index);
    }

    @Override
    @Deprecated
    public void push(Double o2) {
        this.push((double)o2);
    }

    @Override
    @Deprecated
    public Double pop() {
        return this.popDouble();
    }

    @Override
    @Deprecated
    public Double top() {
        return this.topDouble();
    }

    @Override
    @Deprecated
    public Double peek(int i2) {
        return this.peekDouble(i2);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        DoubleListIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("[");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            double k2 = i2.nextDouble();
            s2.append(String.valueOf(k2));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class DoubleSubList
    extends AbstractDoubleList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList l;
        protected final int from;
        protected int to;

        public DoubleSubList(DoubleList l2, int from, int to) {
            this.l = l2;
            this.from = from;
            this.to = to;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(double k2) {
            this.l.add(this.to, k2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int index, double k2) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c2) {
            this.ensureIndex(index);
            this.to += c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public double getDouble(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getDouble(this.from + index);
        }

        @Override
        public double removeDouble(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeDouble(this.from + index);
        }

        @Override
        public double set(int index, double k2) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, double[] a2, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
            assert (this.assertRange());
        }

        @Override
        public void addElements(int index, double[] a2, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a2, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public DoubleListIterator listIterator(final int index) {
            this.ensureIndex(index);
            return new AbstractDoubleListIterator(){
                int pos;
                int last;
                {
                    this.pos = index;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < DoubleSubList.this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public double nextDouble() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.last);
                }

                @Override
                public double previousDouble() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(double k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.add(this.pos++, k2);
                    this.last = -1;
                    assert (DoubleSubList.this.assertRange());
                }

                @Override
                public void set(double k2) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.set(this.last, k2);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.removeDouble(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                    assert (DoubleSubList.this.assertRange());
                }
            };
        }

        @Override
        public DoubleList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new DoubleSubList(this, from, to);
        }

        @Override
        public boolean rem(double k2) {
            int index = this.indexOf(k2);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeDouble(this.from + index);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int index, DoubleCollection c2) {
            this.ensureIndex(index);
            return super.addAll(index, c2);
        }

        @Override
        public boolean addAll(int index, DoubleList l2) {
            this.ensureIndex(index);
            return super.addAll(index, l2);
        }
    }
}

