/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class DoubleBigArrays {
    public static final double[][] EMPTY_BIG_ARRAY = new double[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy();
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;

    private DoubleBigArrays() {
    }

    public static double get(double[][] array, long index) {
        return array[BigArrays.segment(index)][BigArrays.displacement(index)];
    }

    public static void set(double[][] array, long index, double value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    public static void swap(double[][] array, long first, long second) {
        double t2 = array[BigArrays.segment(first)][BigArrays.displacement(first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment(second)][BigArrays.displacement(second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t2;
    }

    public static void add(double[][] array, long index, double incr) {
        double[] dArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        dArray[n2] = dArray[n2] + incr;
    }

    public static void mul(double[][] array, long index, double factor) {
        double[] dArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        dArray[n2] = dArray[n2] * factor;
    }

    public static void incr(double[][] array, long index) {
        double[] dArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        dArray[n2] = dArray[n2] + 1.0;
    }

    public static void decr(double[][] array, long index) {
        double[] dArray = array[BigArrays.segment(index)];
        int n2 = BigArrays.displacement(index);
        dArray[n2] = dArray[n2] - 1.0;
    }

    public static long length(double[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start(length - 1) + (long)array[length - 1].length;
    }

    public static void copy(double[][] srcArray, long srcPos, double[][] destArray, long destPos, long length) {
        if (destPos <= srcPos) {
            int srcSegment = BigArrays.segment(srcPos);
            int destSegment = BigArrays.segment(destPos);
            int srcDispl = BigArrays.displacement(srcPos);
            int destDispl = BigArrays.displacement(destPos);
            while (length > 0L) {
                int l2 = (int)Math.min(length, (long)Math.min(srcArray[srcSegment].length - srcDispl, destArray[destSegment].length - destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl, destArray[destSegment], destDispl, l2);
                if ((srcDispl += l2) == 0x8000000) {
                    srcDispl = 0;
                    ++srcSegment;
                }
                if ((destDispl += l2) == 0x8000000) {
                    destDispl = 0;
                    ++destSegment;
                }
                length -= (long)l2;
            }
        } else {
            int srcSegment = BigArrays.segment(srcPos + length);
            int destSegment = BigArrays.segment(destPos + length);
            int srcDispl = BigArrays.displacement(srcPos + length);
            int destDispl = BigArrays.displacement(destPos + length);
            while (length > 0L) {
                if (srcDispl == 0) {
                    srcDispl = 0x8000000;
                    --srcSegment;
                }
                if (destDispl == 0) {
                    destDispl = 0x8000000;
                    --destSegment;
                }
                int l3 = (int)Math.min(length, (long)Math.min(srcDispl, destDispl));
                System.arraycopy(srcArray[srcSegment], srcDispl - l3, destArray[destSegment], destDispl - l3, l3);
                srcDispl -= l3;
                destDispl -= l3;
                length -= (long)l3;
            }
        }
    }

    public static void copyFromBig(double[][] srcArray, long srcPos, double[] destArray, int destPos, int length) {
        int srcSegment = BigArrays.segment(srcPos);
        int srcDispl = BigArrays.displacement(srcPos);
        while (length > 0) {
            int l2 = Math.min(srcArray[srcSegment].length - srcDispl, length);
            System.arraycopy(srcArray[srcSegment], srcDispl, destArray, destPos, l2);
            if ((srcDispl += l2) == 0x8000000) {
                srcDispl = 0;
                ++srcSegment;
            }
            destPos += l2;
            length -= l2;
        }
    }

    public static void copyToBig(double[] srcArray, int srcPos, double[][] destArray, long destPos, long length) {
        int destSegment = BigArrays.segment(destPos);
        int destDispl = BigArrays.displacement(destPos);
        while (length > 0L) {
            int l2 = (int)Math.min((long)(destArray[destSegment].length - destDispl), length);
            System.arraycopy(srcArray, srcPos, destArray[destSegment], destDispl, l2);
            if ((destDispl += l2) == 0x8000000) {
                destDispl = 0;
                ++destSegment;
            }
            srcPos += l2;
            length -= (long)l2;
        }
    }

    public static double[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength(length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base = new double[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i2 = 0; i2 < baseLength - 1; ++i2) {
                base[i2] = new double[0x8000000];
            }
            base[baseLength - 1] = new double[residual];
        } else {
            for (int i3 = 0; i3 < baseLength; ++i3) {
                base[i3] = new double[0x8000000];
            }
        }
        return base;
    }

    public static double[][] wrap(double[] array) {
        if (array.length == 0) {
            return EMPTY_BIG_ARRAY;
        }
        if (array.length <= 0x8000000) {
            return new double[][]{array};
        }
        double[][] bigArray = DoubleBigArrays.newBigArray(array.length);
        for (int i2 = 0; i2 < bigArray.length; ++i2) {
            System.arraycopy(array, (int)BigArrays.start(i2), bigArray[i2], 0, bigArray[i2].length);
        }
        return bigArray;
    }

    public static double[][] ensureCapacity(double[][] array, long length) {
        return DoubleBigArrays.ensureCapacity(array, length, DoubleBigArrays.length(array));
    }

    public static double[][] ensureCapacity(double[][] array, long length, long preserve) {
        long oldLength = DoubleBigArrays.length(array);
        if (length > oldLength) {
            BigArrays.ensureLength(length);
            int valid = array.length - (array.length == 0 || array.length > 0 && array[array.length - 1].length == 0x8000000 ? 0 : 1);
            int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
            double[][] base = (double[][])Arrays.copyOf(array, baseLength);
            int residual = (int)(length & 0x7FFFFFFL);
            if (residual != 0) {
                for (int i2 = valid; i2 < baseLength - 1; ++i2) {
                    base[i2] = new double[0x8000000];
                }
                base[baseLength - 1] = new double[residual];
            } else {
                for (int i3 = valid; i3 < baseLength; ++i3) {
                    base[i3] = new double[0x8000000];
                }
            }
            if (preserve - (long)valid * 0x8000000L > 0L) {
                DoubleBigArrays.copy(array, (long)valid * 0x8000000L, base, (long)valid * 0x8000000L, preserve - (long)valid * 0x8000000L);
            }
            return base;
        }
        return array;
    }

    public static double[][] grow(double[][] array, long length) {
        long oldLength = DoubleBigArrays.length(array);
        return length > oldLength ? DoubleBigArrays.grow(array, length, oldLength) : array;
    }

    public static double[][] grow(double[][] array, long length, long preserve) {
        long oldLength = DoubleBigArrays.length(array);
        return length > oldLength ? DoubleBigArrays.ensureCapacity(array, Math.max(2L * oldLength, length), preserve) : array;
    }

    public static double[][] trim(double[][] array, long length) {
        BigArrays.ensureLength(length);
        long oldLength = DoubleBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        double[][] base = (double[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = DoubleArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    public static double[][] setLength(double[][] array, long length) {
        long oldLength = DoubleBigArrays.length(array);
        if (length == oldLength) {
            return array;
        }
        if (length < oldLength) {
            return DoubleBigArrays.trim(array, length);
        }
        return DoubleBigArrays.ensureCapacity(array, length);
    }

    public static double[][] copy(double[][] array, long offset, long length) {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        double[][] a2 = DoubleBigArrays.newBigArray(length);
        DoubleBigArrays.copy(array, offset, a2, 0L, length);
        return a2;
    }

    public static double[][] copy(double[][] array) {
        double[][] base = (double[][])array.clone();
        int i2 = base.length;
        while (i2-- != 0) {
            base[i2] = (double[])array[i2].clone();
        }
        return base;
    }

    public static void fill(double[][] array, double value) {
        int i2 = array.length;
        while (i2-- != 0) {
            Arrays.fill(array[i2], value);
        }
    }

    public static void fill(double[][] array, long from, long to, double value) {
        long length = DoubleBigArrays.length(array);
        BigArrays.ensureFromTo(length, from, to);
        int fromSegment = BigArrays.segment(from);
        int toSegment = BigArrays.segment(to);
        int fromDispl = BigArrays.displacement(from);
        int toDispl = BigArrays.displacement(to);
        if (fromSegment == toSegment) {
            Arrays.fill(array[fromSegment], fromDispl, toDispl, value);
            return;
        }
        if (toDispl != 0) {
            Arrays.fill(array[toSegment], 0, toDispl, value);
        }
        while (--toSegment > fromSegment) {
            Arrays.fill(array[toSegment], value);
        }
        Arrays.fill(array[fromSegment], fromDispl, 0x8000000, value);
    }

    public static boolean equals(double[][] a1, double[][] a2) {
        if (DoubleBigArrays.length(a1) != DoubleBigArrays.length(a2)) {
            return false;
        }
        int i2 = a1.length;
        while (i2-- != 0) {
            double[] t2 = a1[i2];
            double[] u2 = a2[i2];
            int j2 = t2.length;
            while (j2-- != 0) {
                if (Double.doubleToLongBits(t2[j2]) == Double.doubleToLongBits(u2[j2])) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(double[][] a2) {
        if (a2 == null) {
            return "null";
        }
        long last = DoubleBigArrays.length(a2) - 1L;
        if (last == -1L) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        long i2 = 0L;
        while (true) {
            b2.append(String.valueOf(DoubleBigArrays.get(a2, i2)));
            if (i2 == last) {
                return b2.append(']').toString();
            }
            b2.append(", ");
            ++i2;
        }
    }

    public static void ensureFromTo(double[][] a2, long from, long to) {
        BigArrays.ensureFromTo(DoubleBigArrays.length(a2), from, to);
    }

    public static void ensureOffsetLength(double[][] a2, long offset, long length) {
        BigArrays.ensureOffsetLength(DoubleBigArrays.length(a2), offset, length);
    }

    private static void vecSwap(double[][] x2, long a2, long b2, long n2) {
        int i2 = 0;
        while ((long)i2 < n2) {
            DoubleBigArrays.swap(x2, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static long med3(double[][] x2, long a2, long b2, long c2, DoubleComparator comp) {
        int ab2 = comp.compare(DoubleBigArrays.get(x2, a2), DoubleBigArrays.get(x2, b2));
        int ac2 = comp.compare(DoubleBigArrays.get(x2, a2), DoubleBigArrays.get(x2, c2));
        int bc = comp.compare(DoubleBigArrays.get(x2, b2), DoubleBigArrays.get(x2, c2));
        return ab2 < 0 ? (bc < 0 ? b2 : (ac2 < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac2 > 0 ? c2 : a2));
    }

    private static void selectionSort(double[][] a2, long from, long to, DoubleComparator comp) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m2 = i2;
            for (long j2 = i2 + 1L; j2 < to; ++j2) {
                if (comp.compare(DoubleBigArrays.get(a2, j2), DoubleBigArrays.get(a2, m2)) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            DoubleBigArrays.swap(a2, i2, m2);
        }
    }

    public static void quickSort(double[][] x2, long from, long to, DoubleComparator comp) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            DoubleBigArrays.selectionSort(x2, from, to, comp);
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l2 = DoubleBigArrays.med3(x2, l2, l2 + s2, l2 + 2L * s2, comp);
                m2 = DoubleBigArrays.med3(x2, m2 - s2, m2, m2 + s2, comp);
                n2 = DoubleBigArrays.med3(x2, n2 - 2L * s2, n2 - s2, n2, comp);
            }
            m2 = DoubleBigArrays.med3(x2, l2, m2, n2, comp);
        }
        double v2 = DoubleBigArrays.get(x2, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(DoubleBigArrays.get(x2, b2), v2)) <= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x2, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(DoubleBigArrays.get(x2, c2), v2)) >= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x2, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            DoubleBigArrays.swap(x2, b2++, c2--);
        }
        long n3 = to;
        long s3 = Math.min(a2 - from, b2 - a2);
        DoubleBigArrays.vecSwap(x2, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1L);
        DoubleBigArrays.vecSwap(x2, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1L) {
            DoubleBigArrays.quickSort(x2, from, from + s3, comp);
        }
        if ((s3 = d2 - c2) > 1L) {
            DoubleBigArrays.quickSort(x2, n3 - s3, n3, comp);
        }
    }

    private static long med3(double[][] x2, long a2, long b2, long c2) {
        int ab2 = Double.compare(DoubleBigArrays.get(x2, a2), DoubleBigArrays.get(x2, b2));
        int ac2 = Double.compare(DoubleBigArrays.get(x2, a2), DoubleBigArrays.get(x2, c2));
        int bc = Double.compare(DoubleBigArrays.get(x2, b2), DoubleBigArrays.get(x2, c2));
        return ab2 < 0 ? (bc < 0 ? b2 : (ac2 < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac2 > 0 ? c2 : a2));
    }

    private static void selectionSort(double[][] a2, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m2 = i2;
            for (long j2 = i2 + 1L; j2 < to; ++j2) {
                if (Double.compare(DoubleBigArrays.get(a2, j2), DoubleBigArrays.get(a2, m2)) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            DoubleBigArrays.swap(a2, i2, m2);
        }
    }

    public static void quickSort(double[][] x2, DoubleComparator comp) {
        DoubleBigArrays.quickSort(x2, 0L, DoubleBigArrays.length(x2), comp);
    }

    public static void quickSort(double[][] x2, long from, long to) {
        long c2;
        long a2;
        long len = to - from;
        if (len < 7L) {
            DoubleBigArrays.selectionSort(x2, from, to);
            return;
        }
        long m2 = from + len / 2L;
        if (len > 7L) {
            long l2 = from;
            long n2 = to - 1L;
            if (len > 40L) {
                long s2 = len / 8L;
                l2 = DoubleBigArrays.med3(x2, l2, l2 + s2, l2 + 2L * s2);
                m2 = DoubleBigArrays.med3(x2, m2 - s2, m2, m2 + s2);
                n2 = DoubleBigArrays.med3(x2, n2 - 2L * s2, n2 - s2, n2);
            }
            m2 = DoubleBigArrays.med3(x2, l2, m2, n2);
        }
        double v2 = DoubleBigArrays.get(x2, m2);
        long b2 = a2 = from;
        long d2 = c2 = to - 1L;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = Double.compare(DoubleBigArrays.get(x2, b2), v2)) <= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x2, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = Double.compare(DoubleBigArrays.get(x2, c2), v2)) >= 0) {
                if (comparison == 0) {
                    DoubleBigArrays.swap(x2, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            DoubleBigArrays.swap(x2, b2++, c2--);
        }
        long n3 = to;
        long s3 = Math.min(a2 - from, b2 - a2);
        DoubleBigArrays.vecSwap(x2, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1L);
        DoubleBigArrays.vecSwap(x2, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1L) {
            DoubleBigArrays.quickSort(x2, from, from + s3);
        }
        if ((s3 = d2 - c2) > 1L) {
            DoubleBigArrays.quickSort(x2, n3 - s3, n3);
        }
    }

    public static void quickSort(double[][] x2) {
        DoubleBigArrays.quickSort(x2, 0L, DoubleBigArrays.length(x2));
    }

    public static long binarySearch(double[][] a2, long from, long to, double key) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            double midVal = DoubleBigArrays.get(a2, mid);
            if (midVal < key) {
                from = mid + 1L;
                continue;
            }
            if (midVal > key) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(double[][] a2, double key) {
        return DoubleBigArrays.binarySearch(a2, 0L, DoubleBigArrays.length(a2), key);
    }

    public static long binarySearch(double[][] a2, long from, long to, double key, DoubleComparator c2) {
        --to;
        while (from <= to) {
            long mid = from + to >>> 1;
            double midVal = DoubleBigArrays.get(a2, mid);
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(from + 1L);
    }

    public static long binarySearch(double[][] a2, double key, DoubleComparator c2) {
        return DoubleBigArrays.binarySearch(a2, 0L, DoubleBigArrays.length(a2), key, c2);
    }

    private static final long fixDouble(double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        return l2 >= 0L ? l2 : l2 ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[][] a2) {
        DoubleBigArrays.radixSort(a2, 0L, DoubleBigArrays.length(a2));
    }

    public static void radixSort(double[][] a2, long from, long to) {
        int maxLevel = 7;
        int stackSize = 1786;
        long[] offsetStack = new long[1786];
        int offsetPos = 0;
        long[] lengthStack = new long[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                DoubleBigArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                ByteBigArrays.set(digit, i2, (byte)(DoubleBigArrays.fixDouble(DoubleBigArrays.get(a2, first + i2)) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n3 = ByteBigArrays.get(digit, i2) & 0xFF;
                count[n3] = count[n3] + 1L;
            }
            int lastUsed = -1;
            long p2 = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 7 && count[i3] > 1L) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c2 = -1;
            for (long i4 = 0L; i4 < end; i4 += count[c2]) {
                double t2 = DoubleBigArrays.get(a2, i4 + first);
                c2 = ByteBigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n4 = c2;
                    long l2 = pos[n4] - 1L;
                    pos[n4] = l2;
                    long d2 = l2;
                    if (l2 <= i4) break;
                    double z2 = t2;
                    int zz = c2;
                    t2 = DoubleBigArrays.get(a2, d2 + first);
                    c2 = ByteBigArrays.get(digit, d2) & 0xFF;
                    DoubleBigArrays.set(a2, d2 + first, z2);
                    ByteBigArrays.set(digit, d2, (byte)zz);
                }
                DoubleBigArrays.set(a2, i4 + first, t2);
                count[c2] = 0L;
            }
        }
    }

    private static void selectionSort(double[][] a2, double[][] b2, long from, long to) {
        for (long i2 = from; i2 < to - 1L; ++i2) {
            long m2 = i2;
            for (long j2 = i2 + 1L; j2 < to; ++j2) {
                if (Double.compare(DoubleBigArrays.get(a2, j2), DoubleBigArrays.get(a2, m2)) >= 0 && (Double.compare(DoubleBigArrays.get(a2, j2), DoubleBigArrays.get(a2, m2)) != 0 || Double.compare(DoubleBigArrays.get(b2, j2), DoubleBigArrays.get(b2, m2)) >= 0)) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            double t2 = DoubleBigArrays.get(a2, i2);
            DoubleBigArrays.set(a2, i2, DoubleBigArrays.get(a2, m2));
            DoubleBigArrays.set(a2, m2, t2);
            t2 = DoubleBigArrays.get(b2, i2);
            DoubleBigArrays.set(b2, i2, DoubleBigArrays.get(b2, m2));
            DoubleBigArrays.set(b2, m2, t2);
        }
    }

    public static void radixSort(double[][] a2, double[][] b2) {
        DoubleBigArrays.radixSort(a2, b2, 0L, DoubleBigArrays.length(a2));
    }

    public static void radixSort(double[][] a2, double[][] b2, long from, long to) {
        int layers = 2;
        if (DoubleBigArrays.length(a2) != DoubleBigArrays.length(b2)) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        long[] offsetStack = new long[3826];
        int offsetPos = 0;
        long[] lengthStack = new long[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        long[] count = new long[256];
        long[] pos = new long[256];
        byte[][] digit = ByteBigArrays.newBigArray(to - from);
        while (offsetPos > 0) {
            int level;
            int signMask;
            long first = offsetStack[--offsetPos];
            long length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 40L) {
                DoubleBigArrays.selectionSort(a2, b2, first, first + length);
                continue;
            }
            double[][] k2 = level < 8 ? a2 : b2;
            int shift = (7 - level % 8) * 8;
            long i2 = length;
            while (i2-- != 0L) {
                ByteBigArrays.set(digit, i2, (byte)(DoubleBigArrays.fixDouble(DoubleBigArrays.get(k2, first + i2)) >>> shift & 0xFFL ^ (long)signMask));
            }
            i2 = length;
            while (i2-- != 0L) {
                int n3 = ByteBigArrays.get(digit, i2) & 0xFF;
                count[n3] = count[n3] + 1L;
            }
            int lastUsed = -1;
            long p2 = 0L;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0L) {
                    lastUsed = i3;
                    if (level < 15 && count[i3] > 1L) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            long end = length - count[lastUsed];
            count[lastUsed] = 0L;
            int c2 = -1;
            for (long i4 = 0L; i4 < end; i4 += count[c2]) {
                double t2 = DoubleBigArrays.get(a2, i4 + first);
                double u2 = DoubleBigArrays.get(b2, i4 + first);
                c2 = ByteBigArrays.get(digit, i4) & 0xFF;
                while (true) {
                    int n4 = c2;
                    long l2 = pos[n4] - 1L;
                    pos[n4] = l2;
                    long d2 = l2;
                    if (l2 <= i4) break;
                    double z2 = t2;
                    int zz = c2;
                    t2 = DoubleBigArrays.get(a2, d2 + first);
                    DoubleBigArrays.set(a2, d2 + first, z2);
                    z2 = u2;
                    u2 = DoubleBigArrays.get(b2, d2 + first);
                    DoubleBigArrays.set(b2, d2 + first, z2);
                    c2 = ByteBigArrays.get(digit, d2) & 0xFF;
                    ByteBigArrays.set(digit, d2, (byte)zz);
                }
                DoubleBigArrays.set(a2, i4 + first, t2);
                DoubleBigArrays.set(b2, i4 + first, u2);
                count[c2] = 0L;
            }
        }
    }

    public static double[][] shuffle(double[][] a2, long from, long to, Random random) {
        long i2 = to - from;
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            double t2 = DoubleBigArrays.get(a2, from + i2);
            DoubleBigArrays.set(a2, from + i2, DoubleBigArrays.get(a2, from + p2));
            DoubleBigArrays.set(a2, from + p2, t2);
        }
        return a2;
    }

    public static double[][] shuffle(double[][] a2, Random random) {
        long i2 = DoubleBigArrays.length(a2);
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            double t2 = DoubleBigArrays.get(a2, i2);
            DoubleBigArrays.set(a2, i2, DoubleBigArrays.get(a2, p2));
            DoubleBigArrays.set(a2, p2, t2);
        }
        return a2;
    }

    private static final class BigArrayHashStrategy
    implements Hash.Strategy<double[][]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private BigArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[][] o2) {
            return Arrays.deepHashCode((Object[])o2);
        }

        @Override
        public boolean equals(double[][] a2, double[][] b2) {
            return DoubleBigArrays.equals(a2, b2);
        }
    }
}

