/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.AbstractInt2LongMap;
import it.unimi.dsi.fastutil.ints.AbstractInt2LongSortedMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongSortedMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class Int2LongRBTreeMap
extends AbstractInt2LongSortedMap
implements Serializable,
Cloneable {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected transient ObjectSortedSet<Int2LongMap.Entry> entries;
    protected transient IntSortedSet keys;
    protected transient LongCollection values;
    protected transient boolean modified;
    protected Comparator<? super Integer> storedComparator;
    protected transient IntComparator actualComparator;
    private static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public Int2LongRBTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof IntComparator ? (IntComparator)this.storedComparator : new IntComparator(){

            @Override
            public int compare(int k1, int k2) {
                return Int2LongRBTreeMap.this.storedComparator.compare((Integer)k1, (Integer)k2);
            }

            @Override
            public int compare(Integer ok1, Integer ok2) {
                return Int2LongRBTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Int2LongRBTreeMap(Comparator<? super Integer> c2) {
        this();
        this.storedComparator = c2;
        this.setActualComparator();
    }

    public Int2LongRBTreeMap(Map<? extends Integer, ? extends Long> m2) {
        this();
        this.putAll(m2);
    }

    public Int2LongRBTreeMap(SortedMap<Integer, Long> m2) {
        this(m2.comparator());
        this.putAll((Map<? extends Integer, ? extends Long>)m2);
    }

    public Int2LongRBTreeMap(Int2LongMap m2) {
        this();
        this.putAll(m2);
    }

    public Int2LongRBTreeMap(Int2LongSortedMap m2) {
        this(m2.comparator());
        this.putAll(m2);
    }

    public Int2LongRBTreeMap(int[] k2, long[] v2, Comparator<? super Integer> c2) {
        this(c2);
        if (k2.length != v2.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v2.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v2[i2]);
        }
    }

    public Int2LongRBTreeMap(int[] k2, long[] v2) {
        this(k2, v2, null);
    }

    final int compare(int k1, int k2) {
        return this.actualComparator == null ? Integer.compare(k1, k2) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(int k2) {
        int cmp;
        Entry e2 = this.tree;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return e2;
    }

    final Entry locateKey(int k2) {
        Entry e2 = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            last = e2;
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return cmp == 0 ? e2 : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    public long addTo(int k2, long incr) {
        Entry e2 = this.add(k2);
        long oldValue = e2.value;
        e2.value += incr;
        return oldValue;
    }

    @Override
    public long put(int k2, long v2) {
        Entry e2 = this.add(k2);
        long oldValue = e2.value;
        e2.value = v2;
        return oldValue;
    }

    private Entry add(int k2) {
        Entry e2;
        this.modified = false;
        int maxDepth = 0;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k2, this.defRetValue);
            this.tree = this.firstEntry;
            e2 = this.firstEntry;
        } else {
            Entry p2 = this.tree;
            int i2 = 0;
            while (true) {
                int cmp;
                if ((cmp = this.compare(k2, p2.key)) == 0) {
                    while (i2-- != 0) {
                        this.nodePath[i2] = null;
                    }
                    return p2;
                }
                this.nodePath[i2] = p2;
                this.dirPath[i2++] = cmp > 0;
                if (this.dirPath[i2++]) {
                    if (p2.succ()) {
                        ++this.count;
                        e2 = new Entry(k2, this.defRetValue);
                        if (p2.right == null) {
                            this.lastEntry = e2;
                        }
                        e2.left = p2;
                        e2.right = p2.right;
                        p2.right(e2);
                        break;
                    }
                    p2 = p2.right;
                    continue;
                }
                if (p2.pred()) {
                    ++this.count;
                    e2 = new Entry(k2, this.defRetValue);
                    if (p2.left == null) {
                        this.firstEntry = e2;
                    }
                    e2.right = p2;
                    e2.left = p2.left;
                    p2.left(e2);
                    break;
                }
                p2 = p2.left;
            }
            this.modified = true;
            maxDepth = i2--;
            while (i2 > 0 && !this.nodePath[i2].black()) {
                Entry x2;
                Entry y2;
                if (!this.dirPath[i2 - 1]) {
                    y2 = this.nodePath[i2 - 1].right;
                    if (!this.nodePath[i2 - 1].succ() && !y2.black()) {
                        this.nodePath[i2].black(true);
                        y2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        i2 -= 2;
                        continue;
                    }
                    if (!this.dirPath[i2]) {
                        y2 = this.nodePath[i2];
                    } else {
                        x2 = this.nodePath[i2];
                        y2 = x2.right;
                        x2.right = y2.left;
                        y2.left = x2;
                        this.nodePath[i2 - 1].left = y2;
                        if (y2.pred()) {
                            y2.pred(false);
                            x2.succ(y2);
                        }
                    }
                    x2 = this.nodePath[i2 - 1];
                    x2.black(false);
                    y2.black(true);
                    x2.left = y2.right;
                    y2.right = x2;
                    if (i2 < 2) {
                        this.tree = y2;
                    } else if (this.dirPath[i2 - 2]) {
                        this.nodePath[i2 - 2].right = y2;
                    } else {
                        this.nodePath[i2 - 2].left = y2;
                    }
                    if (!y2.succ()) break;
                    y2.succ(false);
                    x2.pred(y2);
                    break;
                }
                y2 = this.nodePath[i2 - 1].left;
                if (!this.nodePath[i2 - 1].pred() && !y2.black()) {
                    this.nodePath[i2].black(true);
                    y2.black(true);
                    this.nodePath[i2 - 1].black(false);
                    i2 -= 2;
                    continue;
                }
                if (this.dirPath[i2]) {
                    y2 = this.nodePath[i2];
                } else {
                    x2 = this.nodePath[i2];
                    y2 = x2.left;
                    x2.left = y2.right;
                    y2.right = x2;
                    this.nodePath[i2 - 1].right = y2;
                    if (y2.succ()) {
                        y2.succ(false);
                        x2.pred(y2);
                    }
                }
                x2 = this.nodePath[i2 - 1];
                x2.black(false);
                y2.black(true);
                x2.right = y2.left;
                y2.left = x2;
                if (i2 < 2) {
                    this.tree = y2;
                } else if (this.dirPath[i2 - 2]) {
                    this.nodePath[i2 - 2].right = y2;
                } else {
                    this.nodePath[i2 - 2].left = y2;
                }
                if (!y2.pred()) break;
                y2.pred(false);
                x2.succ(y2);
                break;
            }
        }
        this.tree.black(true);
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long remove(int k2) {
        int i2;
        Entry p2;
        block68: {
            Entry s2;
            int j2;
            boolean color;
            block74: {
                block69: {
                    Entry r2;
                    block73: {
                        block71: {
                            block72: {
                                block66: {
                                    block67: {
                                        this.modified = false;
                                        if (this.tree == null) {
                                            return this.defRetValue;
                                        }
                                        p2 = this.tree;
                                        i2 = 0;
                                        int kk = k2;
                                        while (true) {
                                            int cmp;
                                            if ((cmp = this.compare(kk, p2.key)) == 0) {
                                                if (p2.left != null) break block66;
                                                break block67;
                                            }
                                            this.dirPath[i2] = cmp > 0;
                                            this.nodePath[i2] = p2;
                                            if (this.dirPath[i2++]) {
                                                if ((p2 = p2.right()) != null) continue;
                                                while (true) {
                                                    if (i2-- == 0) {
                                                        return this.defRetValue;
                                                    }
                                                    this.nodePath[i2] = null;
                                                }
                                            }
                                            if ((p2 = p2.left()) == null) break;
                                        }
                                        while (true) {
                                            if (i2-- == 0) {
                                                return this.defRetValue;
                                            }
                                            this.nodePath[i2] = null;
                                        }
                                    }
                                    this.firstEntry = p2.next();
                                }
                                if (p2.right == null) {
                                    this.lastEntry = p2.prev();
                                }
                                if (!p2.succ()) break block71;
                                if (!p2.pred()) break block72;
                                if (i2 == 0) {
                                    this.tree = p2.left;
                                    break block68;
                                } else if (this.dirPath[i2 - 1]) {
                                    this.nodePath[i2 - 1].succ(p2.right);
                                    break block68;
                                } else {
                                    this.nodePath[i2 - 1].pred(p2.left);
                                }
                                break block68;
                            }
                            p2.prev().right = p2.right;
                            if (i2 == 0) {
                                this.tree = p2.left;
                                break block68;
                            } else if (this.dirPath[i2 - 1]) {
                                this.nodePath[i2 - 1].right = p2.left;
                                break block68;
                            } else {
                                this.nodePath[i2 - 1].left = p2.left;
                            }
                            break block68;
                        }
                        r2 = p2.right;
                        if (!r2.pred()) break block73;
                        r2.left = p2.left;
                        r2.pred(p2.pred());
                        if (!r2.pred()) {
                            r2.prev().right = r2;
                        }
                        if (i2 == 0) {
                            this.tree = r2;
                        } else if (this.dirPath[i2 - 1]) {
                            this.nodePath[i2 - 1].right = r2;
                        } else {
                            this.nodePath[i2 - 1].left = r2;
                        }
                        color = r2.black();
                        r2.black(p2.black());
                        p2.black(color);
                        this.dirPath[i2] = true;
                        this.nodePath[i2++] = r2;
                        break block68;
                    }
                    j2 = i2++;
                    while (true) {
                        this.dirPath[i2] = false;
                        this.nodePath[i2++] = r2;
                        s2 = r2.left;
                        if (s2.pred()) {
                            this.dirPath[j2] = true;
                            this.nodePath[j2] = s2;
                            if (s2.succ()) {
                                break;
                            }
                            break block69;
                        }
                        r2 = s2;
                    }
                    r2.pred(s2);
                    break block74;
                }
                r2.left = s2.right;
            }
            s2.left = p2.left;
            if (!p2.pred()) {
                p2.prev().right = s2;
                s2.pred(false);
            }
            s2.right(p2.right);
            color = s2.black();
            s2.black(p2.black());
            p2.black(color);
            if (j2 == 0) {
                this.tree = s2;
            } else if (this.dirPath[j2 - 1]) {
                this.nodePath[j2 - 1].right = s2;
            } else {
                this.nodePath[j2 - 1].left = s2;
            }
        }
        int maxDepth = i2;
        if (p2.black()) {
            while (i2 > 0) {
                block70: {
                    Entry y2;
                    Entry w2;
                    if (this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].succ() || !this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].pred()) {
                        Entry x2;
                        Entry entry = x2 = this.dirPath[i2 - 1] ? this.nodePath[i2 - 1].right : this.nodePath[i2 - 1].left;
                        if (!x2.black()) {
                            x2.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[i2 - 1]) {
                        w2 = this.nodePath[i2 - 1].right;
                        if (!w2.black()) {
                            w2.black(true);
                            this.nodePath[i2 - 1].black(false);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            this.nodePath[i2] = this.nodePath[i2 - 1];
                            this.dirPath[i2] = false;
                            this.nodePath[i2 - 1] = w2;
                            if (maxDepth == i2++) {
                                ++maxDepth;
                            }
                            w2 = this.nodePath[i2 - 1].right;
                        }
                        if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                            w2.black(false);
                            break block70;
                        } else {
                            if (w2.succ() || w2.right.black()) {
                                y2 = w2.left;
                                y2.black(true);
                                w2.black(false);
                                w2.left = y2.right;
                                y2.right = w2;
                                w2 = this.nodePath[i2 - 1].right = y2;
                                if (w2.succ()) {
                                    w2.succ(false);
                                    w2.right.pred(w2);
                                }
                            }
                            w2.black(this.nodePath[i2 - 1].black());
                            this.nodePath[i2 - 1].black(true);
                            w2.right.black(true);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            if (!w2.pred()) break;
                            w2.pred(false);
                            this.nodePath[i2 - 1].succ(w2);
                            break;
                        }
                    }
                    w2 = this.nodePath[i2 - 1].left;
                    if (!w2.black()) {
                        w2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        this.nodePath[i2] = this.nodePath[i2 - 1];
                        this.dirPath[i2] = true;
                        this.nodePath[i2 - 1] = w2;
                        if (maxDepth == i2++) {
                            ++maxDepth;
                        }
                        w2 = this.nodePath[i2 - 1].left;
                    }
                    if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                        w2.black(false);
                    } else {
                        if (w2.pred() || w2.left.black()) {
                            y2 = w2.right;
                            y2.black(true);
                            w2.black(false);
                            w2.right = y2.left;
                            y2.left = w2;
                            w2 = this.nodePath[i2 - 1].left = y2;
                            if (w2.pred()) {
                                w2.pred(false);
                                w2.left.succ(w2);
                            }
                        }
                        w2.black(this.nodePath[i2 - 1].black());
                        this.nodePath[i2 - 1].black(true);
                        w2.left.black(true);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        if (!w2.succ()) break;
                        w2.succ(false);
                        this.nodePath[i2 - 1].pred(w2);
                        break;
                    }
                }
                --i2;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        this.modified = true;
        --this.count;
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return p2.value;
    }

    @Override
    public boolean containsValue(long v2) {
        ValueIterator i2 = new ValueIterator();
        int j2 = this.count;
        while (j2-- != 0) {
            long ev = i2.nextLong();
            if (ev != v2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    @Override
    public boolean containsKey(int k2) {
        return this.findKey(k2) != null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public long get(int k2) {
        Entry e2 = this.findKey(k2);
        return e2 == null ? this.defRetValue : e2.value;
    }

    @Override
    public int firstIntKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    @Override
    public int lastIntKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    @Override
    public ObjectSortedSet<Int2LongMap.Entry> int2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSortedSet<Int2LongMap.Entry>(){
                final Comparator<? super Int2LongMap.Entry> comparator = new Comparator<Int2LongMap.Entry>(){

                    @Override
                    public int compare(Int2LongMap.Entry x2, Int2LongMap.Entry y2) {
                        return Int2LongRBTreeMap.this.actualComparator.compare(x2.getIntKey(), y2.getIntKey());
                    }
                };

                @Override
                public Comparator<? super Int2LongMap.Entry> comparator() {
                    return this.comparator;
                }

                @Override
                public ObjectBidirectionalIterator<Int2LongMap.Entry> iterator() {
                    return new EntryIterator();
                }

                @Override
                public ObjectBidirectionalIterator<Int2LongMap.Entry> iterator(Int2LongMap.Entry from) {
                    return new EntryIterator(from.getIntKey());
                }

                @Override
                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)o2;
                    if (e2.getKey() == null || !(e2.getKey() instanceof Integer)) {
                        return false;
                    }
                    if (e2.getValue() == null || !(e2.getValue() instanceof Long)) {
                        return false;
                    }
                    Entry f2 = Int2LongRBTreeMap.this.findKey((Integer)e2.getKey());
                    return e2.equals(f2);
                }

                @Override
                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e2 = (Map.Entry)o2;
                    if (e2.getKey() == null || !(e2.getKey() instanceof Integer)) {
                        return false;
                    }
                    if (e2.getValue() == null || !(e2.getValue() instanceof Long)) {
                        return false;
                    }
                    Entry f2 = Int2LongRBTreeMap.this.findKey((Integer)e2.getKey());
                    if (f2 != null) {
                        Int2LongRBTreeMap.this.remove(f2.key);
                    }
                    return f2 != null;
                }

                @Override
                public int size() {
                    return Int2LongRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Int2LongRBTreeMap.this.clear();
                }

                @Override
                public Int2LongMap.Entry first() {
                    return Int2LongRBTreeMap.this.firstEntry;
                }

                @Override
                public Int2LongMap.Entry last() {
                    return Int2LongRBTreeMap.this.lastEntry;
                }

                @Override
                public ObjectSortedSet<Int2LongMap.Entry> subSet(Int2LongMap.Entry from, Int2LongMap.Entry to) {
                    return Int2LongRBTreeMap.this.subMap(from.getIntKey(), to.getIntKey()).int2LongEntrySet();
                }

                @Override
                public ObjectSortedSet<Int2LongMap.Entry> headSet(Int2LongMap.Entry to) {
                    return Int2LongRBTreeMap.this.headMap(to.getIntKey()).int2LongEntrySet();
                }

                @Override
                public ObjectSortedSet<Int2LongMap.Entry> tailSet(Int2LongMap.Entry from) {
                    return Int2LongRBTreeMap.this.tailMap(from.getIntKey()).int2LongEntrySet();
                }
            };
        }
        return this.entries;
    }

    @Override
    public IntSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                @Override
                public LongIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public boolean contains(long k2) {
                    return Int2LongRBTreeMap.this.containsValue(k2);
                }

                @Override
                public int size() {
                    return Int2LongRBTreeMap.this.count;
                }

                @Override
                public void clear() {
                    Int2LongRBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public IntComparator comparator() {
        return this.actualComparator;
    }

    @Override
    public Int2LongSortedMap headMap(int to) {
        return new Submap(0, true, to, false);
    }

    @Override
    public Int2LongSortedMap tailMap(int from) {
        return new Submap(from, false, 0, true);
    }

    @Override
    public Int2LongSortedMap subMap(int from, int to) {
        return new Submap(from, false, to, false);
    }

    public Int2LongRBTreeMap clone() {
        Int2LongRBTreeMap c2;
        try {
            c2 = (Int2LongRBTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.allocatePaths();
        if (this.count != 0) {
            Entry rp = new Entry();
            Entry rq = new Entry();
            Entry p2 = rp;
            rp.left(this.tree);
            Entry q2 = rq;
            rq.pred(null);
            while (true) {
                Entry e2;
                if (!p2.pred()) {
                    e2 = p2.left.clone();
                    e2.pred(q2.left);
                    e2.succ(q2);
                    q2.left(e2);
                    p2 = p2.left;
                    q2 = q2.left;
                } else {
                    while (p2.succ()) {
                        p2 = p2.right;
                        if (p2 == null) {
                            q2.right = null;
                            c2.firstEntry = c2.tree = rq.left;
                            while (c2.firstEntry.left != null) {
                                c2.firstEntry = c2.firstEntry.left;
                            }
                            c2.lastEntry = c2.tree;
                            while (c2.lastEntry.right != null) {
                                c2.lastEntry = c2.lastEntry.right;
                            }
                            return c2;
                        }
                        q2 = q2.right;
                    }
                    p2 = p2.right;
                    q2 = q2.right;
                }
                if (p2.succ()) continue;
                e2 = p2.right.clone();
                e2.succ(q2.right);
                e2.pred(q2);
                q2.right(e2);
            }
        }
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int n2 = this.count;
        EntryIterator i2 = new EntryIterator();
        s2.defaultWriteObject();
        while (n2-- != 0) {
            Entry e2 = i2.nextEntry();
            s2.writeInt(e2.key);
            s2.writeLong(e2.value);
        }
    }

    private Entry readTree(ObjectInputStream s2, int n2, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n2 == 1) {
            Entry top = new Entry(s2.readInt(), s2.readLong());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n2 == 2) {
            Entry top = new Entry(s2.readInt(), s2.readLong());
            top.black(true);
            top.right(new Entry(s2.readInt(), s2.readLong()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n2 / 2;
        int leftN = n2 - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s2, leftN, pred, top));
        top.key = s2.readInt();
        top.value = s2.readLong();
        top.black(true);
        top.right(this.readTree(s2, rightN, top, succ));
        if (n2 + 2 == (n2 + 2 & -(n2 + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e2 = this.tree = this.readTree(s2, this.count, null, null);
            while (e2.left() != null) {
                e2 = e2.left();
            }
            this.firstEntry = e2;
            e2 = this.tree;
            while (e2.right() != null) {
                e2 = e2.right();
            }
            this.lastEntry = e2;
        }
    }

    private void checkNodePath() {
    }

    private static int checkTree(Entry e2, int d2, int D2) {
        return 0;
    }

    private final class Submap
    extends AbstractInt2LongSortedMap
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        int from;
        int to;
        boolean bottom;
        boolean top;
        protected transient ObjectSortedSet<Int2LongMap.Entry> entries;
        protected transient IntSortedSet keys;
        protected transient LongCollection values;

        public Submap(int from, boolean bottom, int to, boolean top) {
            if (!bottom && !top && Int2LongRBTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Int2LongRBTreeMap.this.defRetValue;
        }

        @Override
        public void clear() {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                i2.nextEntry();
                i2.remove();
            }
        }

        final boolean in(int k2) {
            return !(!this.bottom && Int2LongRBTreeMap.this.compare(k2, this.from) < 0 || !this.top && Int2LongRBTreeMap.this.compare(k2, this.to) >= 0);
        }

        @Override
        public ObjectSortedSet<Int2LongMap.Entry> int2LongEntrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSortedSet<Int2LongMap.Entry>(){

                    @Override
                    public ObjectBidirectionalIterator<Int2LongMap.Entry> iterator() {
                        return new SubmapEntryIterator();
                    }

                    @Override
                    public ObjectBidirectionalIterator<Int2LongMap.Entry> iterator(Int2LongMap.Entry from) {
                        return new SubmapEntryIterator(from.getIntKey());
                    }

                    @Override
                    public Comparator<? super Int2LongMap.Entry> comparator() {
                        return Int2LongRBTreeMap.this.int2LongEntrySet().comparator();
                    }

                    @Override
                    public boolean contains(Object o2) {
                        if (!(o2 instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e2 = (Map.Entry)o2;
                        if (e2.getKey() == null || !(e2.getKey() instanceof Integer)) {
                            return false;
                        }
                        if (e2.getValue() == null || !(e2.getValue() instanceof Long)) {
                            return false;
                        }
                        Entry f2 = Int2LongRBTreeMap.this.findKey((Integer)e2.getKey());
                        return f2 != null && Submap.this.in(f2.key) && e2.equals(f2);
                    }

                    @Override
                    public boolean remove(Object o2) {
                        if (!(o2 instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e2 = (Map.Entry)o2;
                        if (e2.getKey() == null || !(e2.getKey() instanceof Integer)) {
                            return false;
                        }
                        if (e2.getValue() == null || !(e2.getValue() instanceof Long)) {
                            return false;
                        }
                        Entry f2 = Int2LongRBTreeMap.this.findKey((Integer)e2.getKey());
                        if (f2 != null && Submap.this.in(f2.key)) {
                            Submap.this.remove(f2.key);
                        }
                        return f2 != null;
                    }

                    @Override
                    public int size() {
                        int c2 = 0;
                        ObjectIterator i2 = this.iterator();
                        while (i2.hasNext()) {
                            ++c2;
                            i2.next();
                        }
                        return c2;
                    }

                    @Override
                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }

                    @Override
                    public Int2LongMap.Entry first() {
                        return Submap.this.firstEntry();
                    }

                    @Override
                    public Int2LongMap.Entry last() {
                        return Submap.this.lastEntry();
                    }

                    @Override
                    public ObjectSortedSet<Int2LongMap.Entry> subSet(Int2LongMap.Entry from, Int2LongMap.Entry to) {
                        return Submap.this.subMap(from.getIntKey(), to.getIntKey()).int2LongEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Int2LongMap.Entry> headSet(Int2LongMap.Entry to) {
                        return Submap.this.headMap(to.getIntKey()).int2LongEntrySet();
                    }

                    @Override
                    public ObjectSortedSet<Int2LongMap.Entry> tailSet(Int2LongMap.Entry from) {
                        return Submap.this.tailMap(from.getIntKey()).int2LongEntrySet();
                    }
                };
            }
            return this.entries;
        }

        @Override
        public IntSortedSet keySet() {
            if (this.keys == null) {
                this.keys = new KeySet();
            }
            return this.keys;
        }

        @Override
        public LongCollection values() {
            if (this.values == null) {
                this.values = new AbstractLongCollection(){

                    @Override
                    public LongIterator iterator() {
                        return new SubmapValueIterator();
                    }

                    @Override
                    public boolean contains(long k2) {
                        return Submap.this.containsValue(k2);
                    }

                    @Override
                    public int size() {
                        return Submap.this.size();
                    }

                    @Override
                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        @Override
        public boolean containsKey(int k2) {
            return this.in(k2) && Int2LongRBTreeMap.this.containsKey(k2);
        }

        @Override
        public boolean containsValue(long v2) {
            SubmapIterator i2 = new SubmapIterator();
            while (i2.hasNext()) {
                long ev = i2.nextEntry().value;
                if (ev != v2) continue;
                return true;
            }
            return false;
        }

        @Override
        public long get(int k2) {
            Entry e2;
            int kk = k2;
            return this.in(kk) && (e2 = Int2LongRBTreeMap.this.findKey(kk)) != null ? e2.value : this.defRetValue;
        }

        @Override
        public long put(int k2, long v2) {
            Int2LongRBTreeMap.this.modified = false;
            if (!this.in(k2)) {
                throw new IllegalArgumentException("Key (" + k2 + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            long oldValue = Int2LongRBTreeMap.this.put(k2, v2);
            return Int2LongRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        @Override
        public long remove(int k2) {
            Int2LongRBTreeMap.this.modified = false;
            if (!this.in(k2)) {
                return this.defRetValue;
            }
            long oldValue = Int2LongRBTreeMap.this.remove(k2);
            return Int2LongRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        @Override
        public int size() {
            SubmapIterator i2 = new SubmapIterator();
            int n2 = 0;
            while (i2.hasNext()) {
                ++n2;
                i2.nextEntry();
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        @Override
        public IntComparator comparator() {
            return Int2LongRBTreeMap.this.actualComparator;
        }

        @Override
        public Int2LongSortedMap headMap(int to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Int2LongRBTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        @Override
        public Int2LongSortedMap tailMap(int from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Int2LongRBTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        @Override
        public Int2LongSortedMap subMap(int from, int to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                int n2 = to = Int2LongRBTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                int n3 = from = Int2LongRBTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e2;
            if (Int2LongRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e2 = Int2LongRBTreeMap.this.firstEntry;
            } else {
                e2 = Int2LongRBTreeMap.this.locateKey(this.from);
                if (Int2LongRBTreeMap.this.compare(e2.key, this.from) < 0) {
                    e2 = e2.next();
                }
            }
            if (e2 == null || !this.top && Int2LongRBTreeMap.this.compare(e2.key, this.to) >= 0) {
                return null;
            }
            return e2;
        }

        public Entry lastEntry() {
            Entry e2;
            if (Int2LongRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e2 = Int2LongRBTreeMap.this.lastEntry;
            } else {
                e2 = Int2LongRBTreeMap.this.locateKey(this.to);
                if (Int2LongRBTreeMap.this.compare(e2.key, this.to) >= 0) {
                    e2 = e2.prev();
                }
            }
            if (e2 == null || !this.bottom && Int2LongRBTreeMap.this.compare(e2.key, this.from) < 0) {
                return null;
            }
            return e2;
        }

        @Override
        public int firstIntKey() {
            Entry e2 = this.firstEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        @Override
        public int lastIntKey() {
            Entry e2 = this.lastEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements LongListIterator {
            private SubmapValueIterator() {
            }

            @Override
            public long nextLong() {
                return this.nextEntry().value;
            }

            @Override
            public long previousLong() {
                return this.previousEntry().value;
            }

            @Override
            public void set(long v2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(long v2) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public Long next() {
                return this.nextEntry().value;
            }

            @Override
            @Deprecated
            public Long previous() {
                return this.previousEntry().value;
            }

            @Override
            @Deprecated
            public void set(Long ok) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public void add(Long ok) {
                throw new UnsupportedOperationException();
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements IntListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(int from) {
                super(from);
            }

            @Override
            public int nextInt() {
                return this.nextEntry().key;
            }

            @Override
            public int previousInt() {
                return this.previousEntry().key;
            }

            @Override
            public void set(int k2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(int k2) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public Integer next() {
                return this.nextEntry().key;
            }

            @Override
            @Deprecated
            public Integer previous() {
                return this.previousEntry().key;
            }

            @Override
            @Deprecated
            public void set(Integer ok) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public void add(Integer ok) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapEntryIterator
        extends SubmapIterator
        implements ObjectListIterator<Int2LongMap.Entry> {
            SubmapEntryIterator() {
            }

            SubmapEntryIterator(int k2) {
                super(k2);
            }

            @Override
            public Int2LongMap.Entry next() {
                return this.nextEntry();
            }

            @Override
            public Int2LongMap.Entry previous() {
                return this.previousEntry();
            }

            @Override
            public void set(Int2LongMap.Entry ok) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Int2LongMap.Entry ok) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(int k2) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Int2LongRBTreeMap.this.compare(k2, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Int2LongRBTreeMap.this.compare(k2, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Int2LongRBTreeMap.this.locateKey(k2);
                if (submap.Int2LongRBTreeMap.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            @Override
            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Int2LongRBTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            @Override
            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Int2LongRBTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }

        private class KeySet
        extends AbstractInt2LongSortedMap.KeySet {
            private KeySet() {
            }

            @Override
            public IntBidirectionalIterator iterator() {
                return new SubmapKeyIterator();
            }

            @Override
            public IntBidirectionalIterator iterator(int from) {
                return new SubmapKeyIterator(from);
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements LongListIterator {
        private ValueIterator() {
        }

        @Override
        public long nextLong() {
            return this.nextEntry().value;
        }

        @Override
        public long previousLong() {
            return this.previousEntry().value;
        }

        @Override
        public void set(long v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Long next() {
            return this.nextEntry().value;
        }

        @Override
        @Deprecated
        public Long previous() {
            return this.previousEntry().value;
        }

        @Override
        @Deprecated
        public void set(Long ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(Long ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractInt2LongSortedMap.KeySet {
        private KeySet() {
        }

        @Override
        public IntBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int from) {
            return new KeyIterator(from);
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements IntListIterator {
        public KeyIterator() {
        }

        public KeyIterator(int k2) {
            super(k2);
        }

        @Override
        public int nextInt() {
            return this.nextEntry().key;
        }

        @Override
        public int previousInt() {
            return this.previousEntry().key;
        }

        @Override
        public void set(int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Integer next() {
            return this.nextEntry().key;
        }

        @Override
        @Deprecated
        public Integer previous() {
            return this.previousEntry().key;
        }

        @Override
        @Deprecated
        public void set(Integer ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(Integer ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends TreeIterator
    implements ObjectListIterator<Int2LongMap.Entry> {
        EntryIterator() {
        }

        EntryIterator(int k2) {
            super(k2);
        }

        @Override
        public Int2LongMap.Entry next() {
            return this.nextEntry();
        }

        @Override
        public Int2LongMap.Entry previous() {
            return this.previousEntry();
        }

        @Override
        public void set(Int2LongMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Int2LongMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Int2LongRBTreeMap.this.firstEntry;
        }

        TreeIterator(int k2) {
            this.next = Int2LongRBTreeMap.this.locateKey(k2);
            if (this.next != null) {
                if (Int2LongRBTreeMap.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Int2LongRBTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }

        public int back(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n2 - i2 - 1;
        }
    }

    private static final class Entry
    extends AbstractInt2LongMap.BasicEntry
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        Entry left;
        Entry right;
        int info;

        Entry() {
            super(0, 0L);
        }

        Entry(int k2, long v2) {
            super(k2, v2);
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        @Override
        public long setValue(long value) {
            long oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Entry clone() {
            Entry c2;
            try {
                c2 = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c2.key = this.key;
            c2.value = this.value;
            c2.info = this.info;
            return c2;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this.key == (Integer)e2.getKey() && this.value == (Long)e2.getValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.long2int(this.value);
        }

        @Override
        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

