/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;

public class IntComparators {
    public static final IntComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final IntComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private IntComparators() {
    }

    public static IntComparator oppositeComparator(IntComparator c2) {
        return new OppositeComparator(c2);
    }

    protected static class OppositeComparator
    extends AbstractIntComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IntComparator comparator;

        protected OppositeComparator(IntComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(int a2, int b2) {
            return this.comparator.compare(b2, a2);
        }
    }

    protected static class OppositeImplicitComparator
    extends AbstractIntComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(int a2, int b2) {
            return -Integer.compare(a2, b2);
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class NaturalImplicitComparator
    extends AbstractIntComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(int a2, int b2) {
            return Integer.compare(a2, b2);
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }
}

