/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharBigArrays;
import it.unimi.dsi.fastutil.chars.CharIterable;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.floats.FloatIterable;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortBigArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public class BinIO {
    private static final int MAX_IO_LENGTH = 0x100000;

    private BinIO() {
    }

    public static void storeObject(Object o2, File file) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        oos.writeObject(o2);
        oos.close();
    }

    public static void storeObject(Object o2, CharSequence filename) throws IOException {
        BinIO.storeObject(o2, new File(filename.toString()));
    }

    public static Object loadObject(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(new FileInputStream(file)));
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public static Object loadObject(CharSequence filename) throws IOException, ClassNotFoundException {
        return BinIO.loadObject(new File(filename.toString()));
    }

    public static void storeObject(Object o2, OutputStream s2) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(s2));
        oos.writeObject(o2);
        oos.flush();
    }

    public static Object loadObject(InputStream s2) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(s2));
        Object result = ois.readObject();
        return result;
    }

    public static int loadBooleans(DataInput dataInput, boolean[] array, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadBooleans(DataInput dataInput, boolean[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadBooleans(File file, boolean[] array, int offset, int length) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array, int offset, int length) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array, offset, length);
    }

    public static int loadBooleans(File file, boolean[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readBoolean();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadBooleans(CharSequence filename, boolean[] array) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array);
    }

    public static boolean[] loadBooleans(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size();
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        boolean[] array = new boolean[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readBoolean();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static boolean[] loadBooleans(CharSequence filename) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()));
    }

    public static void storeBooleans(boolean[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeBoolean(array[offset + i2]);
        }
    }

    public static void storeBooleans(boolean[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeBoolean(array[i2]);
        }
    }

    public static void storeBooleans(boolean[] array, int offset, int length, File file) throws IOException {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeBoolean(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeBooleans(boolean[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeBoolean(array[i2]);
        }
        dos.close();
    }

    public static void storeBooleans(boolean[] array, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array, new File(filename.toString()));
    }

    public static long loadBooleans(DataInput dataInput, boolean[][] array, long offset, long length) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                boolean[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readBoolean();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadBooleans(DataInput dataInput, boolean[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                boolean[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readBoolean();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadBooleans(File file, boolean[][] array, long offset, long length) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                boolean[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readBoolean();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array, long offset, long length) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array, offset, length);
    }

    public static long loadBooleans(File file, boolean[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                boolean[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readBoolean();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadBooleans(CharSequence filename, boolean[][] array) throws IOException {
        return BinIO.loadBooleans(new File(filename.toString()), array);
    }

    public static boolean[][] loadBooleansBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size();
        boolean[][] array = BooleanBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            boolean[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readBoolean();
            }
        }
        dis.close();
        return array;
    }

    public static boolean[][] loadBooleansBig(CharSequence filename) throws IOException {
        return BinIO.loadBooleansBig(new File(filename.toString()));
    }

    public static void storeBooleans(boolean[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            boolean[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeBoolean(t2[d2]);
            }
        }
    }

    public static void storeBooleans(boolean[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            boolean[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeBoolean(t2[d2]);
            }
        }
    }

    public static void storeBooleans(boolean[][] array, long offset, long length, File file) throws IOException {
        BooleanBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            boolean[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeBoolean(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeBooleans(boolean[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array, offset, length, new File(filename.toString()));
    }

    public static void storeBooleans(boolean[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            boolean[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeBoolean(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeBooleans(boolean[][] array, CharSequence filename) throws IOException {
        BinIO.storeBooleans(array, new File(filename.toString()));
    }

    public static void storeBooleans(BooleanIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeBoolean(i2.nextBoolean());
        }
    }

    public static void storeBooleans(BooleanIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeBoolean(i2.nextBoolean());
        }
        dos.close();
    }

    public static void storeBooleans(BooleanIterator i2, CharSequence filename) throws IOException {
        BinIO.storeBooleans(i2, new File(filename.toString()));
    }

    public static BooleanIterator asBooleanIterator(DataInput dataInput) {
        return new BooleanDataInputWrapper(dataInput);
    }

    public static BooleanIterator asBooleanIterator(File file) throws IOException {
        return new BooleanDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static BooleanIterator asBooleanIterator(CharSequence filename) throws IOException {
        return BinIO.asBooleanIterator(new File(filename.toString()));
    }

    public static BooleanIterable asBooleanIterable(final File file) {
        return new BooleanIterable(){

            @Override
            public BooleanIterator iterator() {
                try {
                    return BinIO.asBooleanIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static BooleanIterable asBooleanIterable(final CharSequence filename) {
        return new BooleanIterable(){

            @Override
            public BooleanIterator iterator() {
                try {
                    return BinIO.asBooleanIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    private static int read(InputStream is, byte[] a2, int offset, int length) throws IOException {
        int result;
        if (length == 0) {
            return 0;
        }
        int read = 0;
        do {
            if ((result = is.read(a2, offset + read, Math.min(length - read, 0x100000))) >= 0) continue;
            return read;
        } while ((read += result) < length);
        return read;
    }

    private static void write(OutputStream outputStream, byte[] a2, int offset, int length) throws IOException {
        for (int written = 0; written < length; written += Math.min(length - written, 0x100000)) {
            outputStream.write(a2, offset + written, Math.min(length - written, 0x100000));
        }
    }

    private static void write(DataOutput dataOutput, byte[] a2, int offset, int length) throws IOException {
        for (int written = 0; written < length; written += Math.min(length - written, 0x100000)) {
            dataOutput.write(a2, offset + written, Math.min(length - written, 0x100000));
        }
    }

    public static int loadBytes(InputStream inputStream, byte[] array, int offset, int length) throws IOException {
        return BinIO.read(inputStream, array, offset, length);
    }

    public static int loadBytes(InputStream inputStream, byte[] array) throws IOException {
        return BinIO.read(inputStream, array, 0, array.length);
    }

    public static void storeBytes(byte[] array, int offset, int length, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array, offset, length);
    }

    public static void storeBytes(byte[] array, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array, 0, array.length);
    }

    private static long read(InputStream is, byte[][] a2, long offset, long length) throws IOException {
        if (length == 0L) {
            return 0L;
        }
        long read = 0L;
        int segment = BigArrays.segment(offset);
        int displacement = BigArrays.displacement(offset);
        do {
            int result;
            if ((result = is.read(a2[segment], displacement, (int)Math.min((long)(a2[segment].length - displacement), Math.min(length - read, 0x100000L)))) < 0) {
                return read;
            }
            read += (long)result;
            if ((displacement += result) != a2[segment].length) continue;
            ++segment;
            displacement = 0;
        } while (read < length);
        return read;
    }

    private static void write(OutputStream outputStream, byte[][] a2, long offset, long length) throws IOException {
        if (length == 0L) {
            return;
        }
        long written = 0L;
        int segment = BigArrays.segment(offset);
        int displacement = BigArrays.displacement(offset);
        do {
            int toWrite = (int)Math.min((long)(a2[segment].length - displacement), Math.min(length - written, 0x100000L));
            outputStream.write(a2[segment], displacement, toWrite);
            written += (long)toWrite;
            if ((displacement += toWrite) != a2[segment].length) continue;
            ++segment;
            displacement = 0;
        } while (written < length);
    }

    private static void write(DataOutput dataOutput, byte[][] a2, long offset, long length) throws IOException {
        if (length == 0L) {
            return;
        }
        long written = 0L;
        int segment = BigArrays.segment(offset);
        int displacement = BigArrays.displacement(offset);
        do {
            int toWrite = (int)Math.min((long)(a2[segment].length - displacement), Math.min(length - written, 0x100000L));
            dataOutput.write(a2[segment], displacement, toWrite);
            written += (long)toWrite;
            if ((displacement += toWrite) != a2[segment].length) continue;
            ++segment;
            displacement = 0;
        } while (written < length);
    }

    public static long loadBytes(InputStream inputStream, byte[][] array, long offset, long length) throws IOException {
        return BinIO.read(inputStream, array, offset, length);
    }

    public static long loadBytes(InputStream inputStream, byte[][] array) throws IOException {
        return BinIO.read(inputStream, array, 0L, ByteBigArrays.length(array));
    }

    public static void storeBytes(byte[][] array, long offset, long length, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array, offset, length);
    }

    public static void storeBytes(byte[][] array, OutputStream outputStream) throws IOException {
        BinIO.write(outputStream, array, 0L, ByteBigArrays.length(array));
    }

    public static int loadBytes(DataInput dataInput, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadBytes(DataInput dataInput, byte[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadBytes(File file, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        int result = BinIO.read((InputStream)fis, array, offset, length);
        fis.close();
        return result;
    }

    public static int loadBytes(CharSequence filename, byte[] array, int offset, int length) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array, offset, length);
    }

    public static int loadBytes(File file, byte[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        int result = BinIO.read((InputStream)fis, array, 0, array.length);
        fis.close();
        return result;
    }

    public static int loadBytes(CharSequence filename, byte[] array) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array);
    }

    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 1L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        byte[] array = new byte[(int)length];
        if ((long)BinIO.read((InputStream)fis, array, 0, (int)length) < length) {
            throw new EOFException();
        }
        fis.close();
        return array;
    }

    public static byte[] loadBytes(CharSequence filename) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()));
    }

    public static void storeBytes(byte[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        BinIO.write(dataOutput, array, offset, length);
    }

    public static void storeBytes(byte[] array, DataOutput dataOutput) throws IOException {
        BinIO.write(dataOutput, array, 0, array.length);
    }

    public static void storeBytes(byte[] array, int offset, int length, File file) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        FastBufferedOutputStream os2 = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os2, array, offset, length);
        ((OutputStream)os2).close();
    }

    public static void storeBytes(byte[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeBytes(array, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[] array, File file) throws IOException {
        FastBufferedOutputStream os2 = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os2, array, 0, array.length);
        ((OutputStream)os2).close();
    }

    public static void storeBytes(byte[] array, CharSequence filename) throws IOException {
        BinIO.storeBytes(array, new File(filename.toString()));
    }

    public static long loadBytes(DataInput dataInput, byte[][] array, long offset, long length) throws IOException {
        ByteBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                byte[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readByte();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadBytes(DataInput dataInput, byte[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                byte[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readByte();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadBytes(File file, byte[][] array, long offset, long length) throws IOException {
        ByteBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        long result = BinIO.read((InputStream)fis, array, offset, length);
        fis.close();
        return result;
    }

    public static long loadBytes(CharSequence filename, byte[][] array, long offset, long length) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array, offset, length);
    }

    public static long loadBytes(File file, byte[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long result = BinIO.read((InputStream)fis, array, 0L, ByteBigArrays.length(array));
        fis.close();
        return result;
    }

    public static long loadBytes(CharSequence filename, byte[][] array) throws IOException {
        return BinIO.loadBytes(new File(filename.toString()), array);
    }

    public static byte[][] loadBytesBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 1L;
        byte[][] array = ByteBigArrays.newBigArray(length);
        if (BinIO.read((InputStream)fis, array, 0L, length) < length) {
            throw new EOFException();
        }
        fis.close();
        return array;
    }

    public static byte[][] loadBytesBig(CharSequence filename) throws IOException {
        return BinIO.loadBytesBig(new File(filename.toString()));
    }

    public static void storeBytes(byte[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        ByteBigArrays.ensureOffsetLength(array, offset, length);
        BinIO.write(dataOutput, array, offset, length);
    }

    public static void storeBytes(byte[][] array, DataOutput dataOutput) throws IOException {
        BinIO.write(dataOutput, array, 0L, ByteBigArrays.length(array));
    }

    public static void storeBytes(byte[][] array, long offset, long length, File file) throws IOException {
        ByteBigArrays.ensureOffsetLength(array, offset, length);
        FastBufferedOutputStream os2 = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os2, array, offset, length);
        ((OutputStream)os2).close();
    }

    public static void storeBytes(byte[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeBytes(array, offset, length, new File(filename.toString()));
    }

    public static void storeBytes(byte[][] array, File file) throws IOException {
        FastBufferedOutputStream os2 = new FastBufferedOutputStream(new FileOutputStream(file));
        BinIO.write((OutputStream)os2, array, 0L, ByteBigArrays.length(array));
        ((OutputStream)os2).close();
    }

    public static void storeBytes(byte[][] array, CharSequence filename) throws IOException {
        BinIO.storeBytes(array, new File(filename.toString()));
    }

    public static void storeBytes(ByteIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeByte(i2.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeByte(i2.nextByte());
        }
        dos.close();
    }

    public static void storeBytes(ByteIterator i2, CharSequence filename) throws IOException {
        BinIO.storeBytes(i2, new File(filename.toString()));
    }

    public static ByteIterator asByteIterator(DataInput dataInput) {
        return new ByteDataInputWrapper(dataInput);
    }

    public static ByteIterator asByteIterator(File file) throws IOException {
        return new ByteDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return BinIO.asByteIterator(new File(filename.toString()));
    }

    public static ByteIterable asByteIterable(final File file) {
        return new ByteIterable(){

            @Override
            public ByteIterator iterator() {
                try {
                    return BinIO.asByteIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ByteIterable asByteIterable(final CharSequence filename) {
        return new ByteIterable(){

            @Override
            public ByteIterator iterator() {
                try {
                    return BinIO.asByteIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadShorts(DataInput dataInput, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadShorts(DataInput dataInput, short[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadShorts(File file, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadShorts(CharSequence filename, short[] array, int offset, int length) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array, offset, length);
    }

    public static int loadShorts(File file, short[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadShorts(CharSequence filename, short[] array) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array);
    }

    public static short[] loadShorts(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        short[] array = new short[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readShort();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static short[] loadShorts(CharSequence filename) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()));
    }

    public static void storeShorts(short[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeShort(array[offset + i2]);
        }
    }

    public static void storeShorts(short[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeShort(array[i2]);
        }
    }

    public static void storeShorts(short[] array, int offset, int length, File file) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeShort(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeShorts(array, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeShort(array[i2]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array, CharSequence filename) throws IOException {
        BinIO.storeShorts(array, new File(filename.toString()));
    }

    public static long loadShorts(DataInput dataInput, short[][] array, long offset, long length) throws IOException {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                short[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readShort();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadShorts(DataInput dataInput, short[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                short[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readShort();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadShorts(File file, short[][] array, long offset, long length) throws IOException {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                short[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readShort();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadShorts(CharSequence filename, short[][] array, long offset, long length) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array, offset, length);
    }

    public static long loadShorts(File file, short[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                short[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readShort();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadShorts(CharSequence filename, short[][] array) throws IOException {
        return BinIO.loadShorts(new File(filename.toString()), array);
    }

    public static short[][] loadShortsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        short[][] array = ShortBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            short[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readShort();
            }
        }
        dis.close();
        return array;
    }

    public static short[][] loadShortsBig(CharSequence filename) throws IOException {
        return BinIO.loadShortsBig(new File(filename.toString()));
    }

    public static void storeShorts(short[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            short[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeShort(t2[d2]);
            }
        }
    }

    public static void storeShorts(short[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            short[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeShort(t2[d2]);
            }
        }
    }

    public static void storeShorts(short[][] array, long offset, long length, File file) throws IOException {
        ShortBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            short[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeShort(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeShorts(short[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeShorts(array, offset, length, new File(filename.toString()));
    }

    public static void storeShorts(short[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            short[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeShort(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeShorts(short[][] array, CharSequence filename) throws IOException {
        BinIO.storeShorts(array, new File(filename.toString()));
    }

    public static void storeShorts(ShortIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeShort(i2.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeShort(i2.nextShort());
        }
        dos.close();
    }

    public static void storeShorts(ShortIterator i2, CharSequence filename) throws IOException {
        BinIO.storeShorts(i2, new File(filename.toString()));
    }

    public static ShortIterator asShortIterator(DataInput dataInput) {
        return new ShortDataInputWrapper(dataInput);
    }

    public static ShortIterator asShortIterator(File file) throws IOException {
        return new ShortDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return BinIO.asShortIterator(new File(filename.toString()));
    }

    public static ShortIterable asShortIterable(final File file) {
        return new ShortIterable(){

            @Override
            public ShortIterator iterator() {
                try {
                    return BinIO.asShortIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static ShortIterable asShortIterable(final CharSequence filename) {
        return new ShortIterable(){

            @Override
            public ShortIterator iterator() {
                try {
                    return BinIO.asShortIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadChars(DataInput dataInput, char[] array, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadChars(DataInput dataInput, char[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadChars(File file, char[] array, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadChars(CharSequence filename, char[] array, int offset, int length) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array, offset, length);
    }

    public static int loadChars(File file, char[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadChars(CharSequence filename, char[] array) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array);
    }

    public static char[] loadChars(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        char[] array = new char[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readChar();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static char[] loadChars(CharSequence filename) throws IOException {
        return BinIO.loadChars(new File(filename.toString()));
    }

    public static void storeChars(char[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeChar(array[offset + i2]);
        }
    }

    public static void storeChars(char[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeChar(array[i2]);
        }
    }

    public static void storeChars(char[] array, int offset, int length, File file) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeChar(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeChars(char[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeChars(array, offset, length, new File(filename.toString()));
    }

    public static void storeChars(char[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeChar(array[i2]);
        }
        dos.close();
    }

    public static void storeChars(char[] array, CharSequence filename) throws IOException {
        BinIO.storeChars(array, new File(filename.toString()));
    }

    public static long loadChars(DataInput dataInput, char[][] array, long offset, long length) throws IOException {
        CharBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                char[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readChar();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadChars(DataInput dataInput, char[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                char[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readChar();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadChars(File file, char[][] array, long offset, long length) throws IOException {
        CharBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                char[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readChar();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadChars(CharSequence filename, char[][] array, long offset, long length) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array, offset, length);
    }

    public static long loadChars(File file, char[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                char[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readChar();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadChars(CharSequence filename, char[][] array) throws IOException {
        return BinIO.loadChars(new File(filename.toString()), array);
    }

    public static char[][] loadCharsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 2L;
        char[][] array = CharBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            char[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readChar();
            }
        }
        dis.close();
        return array;
    }

    public static char[][] loadCharsBig(CharSequence filename) throws IOException {
        return BinIO.loadCharsBig(new File(filename.toString()));
    }

    public static void storeChars(char[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        CharBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            char[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeChar(t2[d2]);
            }
        }
    }

    public static void storeChars(char[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            char[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeChar(t2[d2]);
            }
        }
    }

    public static void storeChars(char[][] array, long offset, long length, File file) throws IOException {
        CharBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            char[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeChar(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeChars(char[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeChars(array, offset, length, new File(filename.toString()));
    }

    public static void storeChars(char[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            char[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeChar(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeChars(char[][] array, CharSequence filename) throws IOException {
        BinIO.storeChars(array, new File(filename.toString()));
    }

    public static void storeChars(CharIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeChar(i2.nextChar());
        }
    }

    public static void storeChars(CharIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeChar(i2.nextChar());
        }
        dos.close();
    }

    public static void storeChars(CharIterator i2, CharSequence filename) throws IOException {
        BinIO.storeChars(i2, new File(filename.toString()));
    }

    public static CharIterator asCharIterator(DataInput dataInput) {
        return new CharDataInputWrapper(dataInput);
    }

    public static CharIterator asCharIterator(File file) throws IOException {
        return new CharDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static CharIterator asCharIterator(CharSequence filename) throws IOException {
        return BinIO.asCharIterator(new File(filename.toString()));
    }

    public static CharIterable asCharIterable(final File file) {
        return new CharIterable(){

            @Override
            public CharIterator iterator() {
                try {
                    return BinIO.asCharIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static CharIterable asCharIterable(final CharSequence filename) {
        return new CharIterable(){

            @Override
            public CharIterator iterator() {
                try {
                    return BinIO.asCharIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadInts(DataInput dataInput, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadInts(DataInput dataInput, int[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadInts(File file, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadInts(CharSequence filename, int[] array, int offset, int length) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array, offset, length);
    }

    public static int loadInts(File file, int[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadInts(CharSequence filename, int[] array) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array);
    }

    public static int[] loadInts(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        int[] array = new int[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readInt();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static int[] loadInts(CharSequence filename) throws IOException {
        return BinIO.loadInts(new File(filename.toString()));
    }

    public static void storeInts(int[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeInt(array[offset + i2]);
        }
    }

    public static void storeInts(int[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeInt(array[i2]);
        }
    }

    public static void storeInts(int[] array, int offset, int length, File file) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeInt(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeInts(int[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeInts(array, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeInt(array[i2]);
        }
        dos.close();
    }

    public static void storeInts(int[] array, CharSequence filename) throws IOException {
        BinIO.storeInts(array, new File(filename.toString()));
    }

    public static long loadInts(DataInput dataInput, int[][] array, long offset, long length) throws IOException {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                int[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readInt();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadInts(DataInput dataInput, int[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                int[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readInt();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadInts(File file, int[][] array, long offset, long length) throws IOException {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                int[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readInt();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadInts(CharSequence filename, int[][] array, long offset, long length) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array, offset, length);
    }

    public static long loadInts(File file, int[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                int[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readInt();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadInts(CharSequence filename, int[][] array) throws IOException {
        return BinIO.loadInts(new File(filename.toString()), array);
    }

    public static int[][] loadIntsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        int[][] array = IntBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            int[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readInt();
            }
        }
        dis.close();
        return array;
    }

    public static int[][] loadIntsBig(CharSequence filename) throws IOException {
        return BinIO.loadIntsBig(new File(filename.toString()));
    }

    public static void storeInts(int[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            int[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeInt(t2[d2]);
            }
        }
    }

    public static void storeInts(int[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            int[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeInt(t2[d2]);
            }
        }
    }

    public static void storeInts(int[][] array, long offset, long length, File file) throws IOException {
        IntBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            int[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeInt(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeInts(int[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeInts(array, offset, length, new File(filename.toString()));
    }

    public static void storeInts(int[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            int[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeInt(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeInts(int[][] array, CharSequence filename) throws IOException {
        BinIO.storeInts(array, new File(filename.toString()));
    }

    public static void storeInts(IntIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeInt(i2.nextInt());
        }
    }

    public static void storeInts(IntIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeInt(i2.nextInt());
        }
        dos.close();
    }

    public static void storeInts(IntIterator i2, CharSequence filename) throws IOException {
        BinIO.storeInts(i2, new File(filename.toString()));
    }

    public static IntIterator asIntIterator(DataInput dataInput) {
        return new IntDataInputWrapper(dataInput);
    }

    public static IntIterator asIntIterator(File file) throws IOException {
        return new IntDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return BinIO.asIntIterator(new File(filename.toString()));
    }

    public static IntIterable asIntIterable(final File file) {
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                try {
                    return BinIO.asIntIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static IntIterable asIntIterable(final CharSequence filename) {
        return new IntIterable(){

            @Override
            public IntIterator iterator() {
                try {
                    return BinIO.asIntIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadLongs(DataInput dataInput, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadLongs(DataInput dataInput, long[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadLongs(File file, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadLongs(CharSequence filename, long[] array, int offset, int length) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array, offset, length);
    }

    public static int loadLongs(File file, long[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadLongs(CharSequence filename, long[] array) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array);
    }

    public static long[] loadLongs(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        long[] array = new long[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readLong();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static long[] loadLongs(CharSequence filename) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()));
    }

    public static void storeLongs(long[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeLong(array[offset + i2]);
        }
    }

    public static void storeLongs(long[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeLong(array[i2]);
        }
    }

    public static void storeLongs(long[] array, int offset, int length, File file) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeLong(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeLongs(array, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeLong(array[i2]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array, CharSequence filename) throws IOException {
        BinIO.storeLongs(array, new File(filename.toString()));
    }

    public static long loadLongs(DataInput dataInput, long[][] array, long offset, long length) throws IOException {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                long[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readLong();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadLongs(DataInput dataInput, long[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                long[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readLong();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadLongs(File file, long[][] array, long offset, long length) throws IOException {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                long[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readLong();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadLongs(CharSequence filename, long[][] array, long offset, long length) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array, offset, length);
    }

    public static long loadLongs(File file, long[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                long[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readLong();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadLongs(CharSequence filename, long[][] array) throws IOException {
        return BinIO.loadLongs(new File(filename.toString()), array);
    }

    public static long[][] loadLongsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        long[][] array = LongBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            long[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readLong();
            }
        }
        dis.close();
        return array;
    }

    public static long[][] loadLongsBig(CharSequence filename) throws IOException {
        return BinIO.loadLongsBig(new File(filename.toString()));
    }

    public static void storeLongs(long[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            long[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeLong(t2[d2]);
            }
        }
    }

    public static void storeLongs(long[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            long[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeLong(t2[d2]);
            }
        }
    }

    public static void storeLongs(long[][] array, long offset, long length, File file) throws IOException {
        LongBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            long[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeLong(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeLongs(long[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeLongs(array, offset, length, new File(filename.toString()));
    }

    public static void storeLongs(long[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            long[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeLong(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeLongs(long[][] array, CharSequence filename) throws IOException {
        BinIO.storeLongs(array, new File(filename.toString()));
    }

    public static void storeLongs(LongIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeLong(i2.nextLong());
        }
    }

    public static void storeLongs(LongIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeLong(i2.nextLong());
        }
        dos.close();
    }

    public static void storeLongs(LongIterator i2, CharSequence filename) throws IOException {
        BinIO.storeLongs(i2, new File(filename.toString()));
    }

    public static LongIterator asLongIterator(DataInput dataInput) {
        return new LongDataInputWrapper(dataInput);
    }

    public static LongIterator asLongIterator(File file) throws IOException {
        return new LongDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return BinIO.asLongIterator(new File(filename.toString()));
    }

    public static LongIterable asLongIterable(final File file) {
        return new LongIterable(){

            @Override
            public LongIterator iterator() {
                try {
                    return BinIO.asLongIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static LongIterable asLongIterable(final CharSequence filename) {
        return new LongIterable(){

            @Override
            public LongIterator iterator() {
                try {
                    return BinIO.asLongIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadFloats(DataInput dataInput, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadFloats(DataInput dataInput, float[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadFloats(File file, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadFloats(CharSequence filename, float[] array, int offset, int length) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array, offset, length);
    }

    public static int loadFloats(File file, float[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadFloats(CharSequence filename, float[] array) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array);
    }

    public static float[] loadFloats(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        float[] array = new float[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readFloat();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static float[] loadFloats(CharSequence filename) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()));
    }

    public static void storeFloats(float[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeFloat(array[offset + i2]);
        }
    }

    public static void storeFloats(float[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeFloat(array[i2]);
        }
    }

    public static void storeFloats(float[] array, int offset, int length, File file) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeFloat(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeFloats(array, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeFloat(array[i2]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array, CharSequence filename) throws IOException {
        BinIO.storeFloats(array, new File(filename.toString()));
    }

    public static long loadFloats(DataInput dataInput, float[][] array, long offset, long length) throws IOException {
        FloatBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                float[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readFloat();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadFloats(DataInput dataInput, float[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                float[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readFloat();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadFloats(File file, float[][] array, long offset, long length) throws IOException {
        FloatBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                float[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readFloat();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadFloats(CharSequence filename, float[][] array, long offset, long length) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array, offset, length);
    }

    public static long loadFloats(File file, float[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                float[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readFloat();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadFloats(CharSequence filename, float[][] array) throws IOException {
        return BinIO.loadFloats(new File(filename.toString()), array);
    }

    public static float[][] loadFloatsBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 4L;
        float[][] array = FloatBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            float[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readFloat();
            }
        }
        dis.close();
        return array;
    }

    public static float[][] loadFloatsBig(CharSequence filename) throws IOException {
        return BinIO.loadFloatsBig(new File(filename.toString()));
    }

    public static void storeFloats(float[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        FloatBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            float[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeFloat(t2[d2]);
            }
        }
    }

    public static void storeFloats(float[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            float[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeFloat(t2[d2]);
            }
        }
    }

    public static void storeFloats(float[][] array, long offset, long length, File file) throws IOException {
        FloatBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            float[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeFloat(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeFloats(float[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeFloats(array, offset, length, new File(filename.toString()));
    }

    public static void storeFloats(float[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            float[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeFloat(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeFloats(float[][] array, CharSequence filename) throws IOException {
        BinIO.storeFloats(array, new File(filename.toString()));
    }

    public static void storeFloats(FloatIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeFloat(i2.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeFloat(i2.nextFloat());
        }
        dos.close();
    }

    public static void storeFloats(FloatIterator i2, CharSequence filename) throws IOException {
        BinIO.storeFloats(i2, new File(filename.toString()));
    }

    public static FloatIterator asFloatIterator(DataInput dataInput) {
        return new FloatDataInputWrapper(dataInput);
    }

    public static FloatIterator asFloatIterator(File file) throws IOException {
        return new FloatDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return BinIO.asFloatIterator(new File(filename.toString()));
    }

    public static FloatIterable asFloatIterable(final File file) {
        return new FloatIterable(){

            @Override
            public FloatIterator iterator() {
                try {
                    return BinIO.asFloatIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static FloatIterable asFloatIterable(final CharSequence filename) {
        return new FloatIterable(){

            @Override
            public FloatIterator iterator() {
                try {
                    return BinIO.asFloatIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static int loadDoubles(DataInput dataInput, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dataInput.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadDoubles(DataInput dataInput, double[] array) throws IOException {
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dataInput.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i2;
    }

    public static int loadDoubles(File file, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            for (i2 = 0; i2 < length; ++i2) {
                array[i2 + offset] = dis.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadDoubles(CharSequence filename, double[] array, int offset, int length) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array, offset, length);
    }

    public static int loadDoubles(File file, double[] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        try {
            int length = array.length;
            for (i2 = 0; i2 < length; ++i2) {
                array[i2] = dis.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return i2;
    }

    public static int loadDoubles(CharSequence filename, double[] array) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array);
    }

    public static double[] loadDoubles(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        if (length > Integer.MAX_VALUE) {
            fis.close();
            throw new IllegalArgumentException("File too long: " + fis.getChannel().size() + " bytes (" + length + " elements)");
        }
        double[] array = new double[(int)length];
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        int i2 = 0;
        while ((long)i2 < length) {
            array[i2] = dis.readDouble();
            ++i2;
        }
        dis.close();
        return array;
    }

    public static double[] loadDoubles(CharSequence filename) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()));
    }

    public static void storeDoubles(double[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeDouble(array[offset + i2]);
        }
    }

    public static void storeDoubles(double[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i2 = 0; i2 < length; ++i2) {
            dataOutput.writeDouble(array[i2]);
        }
    }

    public static void storeDoubles(double[] array, int offset, int length, File file) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeDouble(array[offset + i2]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array, int offset, int length, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[] array, File file) throws IOException {
        int length = array.length;
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < length; ++i2) {
            dos.writeDouble(array[i2]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array, new File(filename.toString()));
    }

    public static long loadDoubles(DataInput dataInput, double[][] array, long offset, long length) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                double[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dataInput.readDouble();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadDoubles(DataInput dataInput, double[][] array) throws IOException {
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                double[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dataInput.readDouble();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return c2;
    }

    public static long loadDoubles(File file, double[][] array, long offset, long length) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
                double[] t2 = array[i2];
                int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
                for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                    t2[d2] = dis.readDouble();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadDoubles(CharSequence filename, double[][] array, long offset, long length) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array, offset, length);
    }

    public static long loadDoubles(File file, double[][] array) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        long c2 = 0L;
        try {
            for (int i2 = 0; i2 < array.length; ++i2) {
                double[] t2 = array[i2];
                int l2 = t2.length;
                for (int d2 = 0; d2 < l2; ++d2) {
                    t2[d2] = dis.readDouble();
                    ++c2;
                }
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
        return c2;
    }

    public static long loadDoubles(CharSequence filename, double[][] array) throws IOException {
        return BinIO.loadDoubles(new File(filename.toString()), array);
    }

    public static double[][] loadDoublesBig(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = fis.getChannel().size() / 8L;
        double[][] array = DoubleBigArrays.newBigArray(length);
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis));
        for (int i2 = 0; i2 < array.length; ++i2) {
            double[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                t2[d2] = dis.readDouble();
            }
        }
        dis.close();
        return array;
    }

    public static double[][] loadDoublesBig(CharSequence filename) throws IOException {
        return BinIO.loadDoublesBig(new File(filename.toString()));
    }

    public static void storeDoubles(double[][] array, long offset, long length, DataOutput dataOutput) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            double[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dataOutput.writeDouble(t2[d2]);
            }
        }
    }

    public static void storeDoubles(double[][] array, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < array.length; ++i2) {
            double[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dataOutput.writeDouble(t2[d2]);
            }
        }
    }

    public static void storeDoubles(double[][] array, long offset, long length, File file) throws IOException {
        DoubleBigArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = BigArrays.segment(offset); i2 < BigArrays.segment(offset + length + 0x7FFFFFFL); ++i2) {
            double[] t2 = array[i2];
            int l2 = (int)Math.min((long)t2.length, offset + length - BigArrays.start(i2));
            for (int d2 = (int)Math.max(0L, offset - BigArrays.start(i2)); d2 < l2; ++d2) {
                dos.writeDouble(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeDoubles(double[][] array, long offset, long length, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array, offset, length, new File(filename.toString()));
    }

    public static void storeDoubles(double[][] array, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        for (int i2 = 0; i2 < array.length; ++i2) {
            double[] t2 = array[i2];
            int l2 = t2.length;
            for (int d2 = 0; d2 < l2; ++d2) {
                dos.writeDouble(t2[d2]);
            }
        }
        dos.close();
    }

    public static void storeDoubles(double[][] array, CharSequence filename) throws IOException {
        BinIO.storeDoubles(array, new File(filename.toString()));
    }

    public static void storeDoubles(DoubleIterator i2, DataOutput dataOutput) throws IOException {
        while (i2.hasNext()) {
            dataOutput.writeDouble(i2.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i2, File file) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(file)));
        while (i2.hasNext()) {
            dos.writeDouble(i2.nextDouble());
        }
        dos.close();
    }

    public static void storeDoubles(DoubleIterator i2, CharSequence filename) throws IOException {
        BinIO.storeDoubles(i2, new File(filename.toString()));
    }

    public static DoubleIterator asDoubleIterator(DataInput dataInput) {
        return new DoubleDataInputWrapper(dataInput);
    }

    public static DoubleIterator asDoubleIterator(File file) throws IOException {
        return new DoubleDataInputWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(file))));
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return BinIO.asDoubleIterator(new File(filename.toString()));
    }

    public static DoubleIterable asDoubleIterable(final File file) {
        return new DoubleIterable(){

            @Override
            public DoubleIterator iterator() {
                try {
                    return BinIO.asDoubleIterator(file);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static DoubleIterable asDoubleIterable(final CharSequence filename) {
        return new DoubleIterable(){

            @Override
            public DoubleIterator iterator() {
                try {
                    return BinIO.asDoubleIterator(filename);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    private static final class DoubleDataInputWrapper
    extends AbstractDoubleIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private double next;

        public DoubleDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readDouble();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class FloatDataInputWrapper
    extends AbstractFloatIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private float next;

        public FloatDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readFloat();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongDataInputWrapper
    extends AbstractLongIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private long next;

        public LongDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readLong();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntDataInputWrapper
    extends AbstractIntIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private int next;

        public IntDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readInt();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class CharDataInputWrapper
    extends AbstractCharIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private char next;

        public CharDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readChar();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortDataInputWrapper
    extends AbstractShortIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private short next;

        public ShortDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readShort();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteDataInputWrapper
    extends AbstractByteIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private byte next;

        public ByteDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readByte();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class BooleanDataInputWrapper
    extends AbstractBooleanIterator {
        private final DataInput dataInput;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private boolean next;

        public BooleanDataInputWrapper(DataInput dataInput) {
            this.dataInput = dataInput;
        }

        @Override
        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.dataInput.readBoolean();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        @Override
        public boolean nextBoolean() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

