/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ObjectRBTreeSet<K>
extends AbstractObjectSortedSet<K>
implements Serializable,
Cloneable,
ObjectSortedSet<K> {
    protected transient Entry<K> tree;
    protected int count;
    protected transient Entry<K> firstEntry;
    protected transient Entry<K> lastEntry;
    protected Comparator<? super K> storedComparator;
    protected transient Comparator<? super K> actualComparator;
    private static final long serialVersionUID = -7046029254386353130L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry<K>[] nodePath;

    public ObjectRBTreeSet() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator;
    }

    public ObjectRBTreeSet(Comparator<? super K> c2) {
        this();
        this.storedComparator = c2;
    }

    public ObjectRBTreeSet(Collection<? extends K> c2) {
        this();
        this.addAll(c2);
    }

    public ObjectRBTreeSet(SortedSet<K> s2) {
        this(s2.comparator());
        this.addAll(s2);
    }

    public ObjectRBTreeSet(ObjectCollection<? extends K> c2) {
        this();
        this.addAll(c2);
    }

    public ObjectRBTreeSet(ObjectSortedSet<K> s2) {
        this(s2.comparator());
        this.addAll(s2);
    }

    public ObjectRBTreeSet(Iterator<? extends K> i2) {
        this.allocatePaths();
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public ObjectRBTreeSet(K[] a2, int offset, int length, Comparator<? super K> c2) {
        this(c2);
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2[offset + i2]);
        }
    }

    public ObjectRBTreeSet(K[] a2, int offset, int length) {
        this(a2, offset, length, null);
    }

    public ObjectRBTreeSet(K[] a2) {
        this();
        int i2 = a2.length;
        while (i2-- != 0) {
            this.add(a2[i2]);
        }
    }

    public ObjectRBTreeSet(K[] a2, Comparator<? super K> c2) {
        this(c2);
        int i2 = a2.length;
        while (i2-- != 0) {
            this.add(a2[i2]);
        }
    }

    final int compare(K k1, K k2) {
        return this.actualComparator == null ? ((Comparable)k1).compareTo(k2) : this.actualComparator.compare(k1, k2);
    }

    private Entry<K> findKey(K k2) {
        int cmp;
        Entry<K> e2 = this.tree;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return e2;
    }

    final Entry<K> locateKey(K k2) {
        Entry<K> e2 = this.tree;
        Entry<K> last = this.tree;
        int cmp = 0;
        while (e2 != null && (cmp = this.compare(k2, e2.key)) != 0) {
            last = e2;
            e2 = cmp < 0 ? e2.left() : e2.right();
        }
        return cmp == 0 ? e2 : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    @Override
    public boolean add(K k2) {
        int maxDepth = 0;
        if (this.tree == null) {
            ++this.count;
            this.firstEntry = new Entry<K>(k2);
            this.lastEntry = this.firstEntry;
            this.tree = this.firstEntry;
        } else {
            Entry<K> p2 = this.tree;
            int i2 = 0;
            while (true) {
                Entry<K> e2;
                int cmp;
                if ((cmp = this.compare(k2, p2.key)) == 0) {
                    while (i2-- != 0) {
                        this.nodePath[i2] = null;
                    }
                    return false;
                }
                this.nodePath[i2] = p2;
                this.dirPath[i2++] = cmp > 0;
                if (this.dirPath[i2++]) {
                    if (p2.succ()) {
                        ++this.count;
                        e2 = new Entry<K>(k2);
                        if (p2.right == null) {
                            this.lastEntry = e2;
                        }
                        e2.left = p2;
                        e2.right = p2.right;
                        p2.right(e2);
                        break;
                    }
                    p2 = p2.right;
                    continue;
                }
                if (p2.pred()) {
                    ++this.count;
                    e2 = new Entry<K>(k2);
                    if (p2.left == null) {
                        this.firstEntry = e2;
                    }
                    e2.right = p2;
                    e2.left = p2.left;
                    p2.left(e2);
                    break;
                }
                p2 = p2.left;
            }
            maxDepth = i2--;
            while (i2 > 0 && !this.nodePath[i2].black()) {
                Entry x2;
                Entry y2;
                if (!this.dirPath[i2 - 1]) {
                    y2 = this.nodePath[i2 - 1].right;
                    if (!this.nodePath[i2 - 1].succ() && !y2.black()) {
                        this.nodePath[i2].black(true);
                        y2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        i2 -= 2;
                        continue;
                    }
                    if (!this.dirPath[i2]) {
                        y2 = this.nodePath[i2];
                    } else {
                        x2 = this.nodePath[i2];
                        y2 = x2.right;
                        x2.right = y2.left;
                        y2.left = x2;
                        this.nodePath[i2 - 1].left = y2;
                        if (y2.pred()) {
                            y2.pred(false);
                            x2.succ(y2);
                        }
                    }
                    x2 = this.nodePath[i2 - 1];
                    x2.black(false);
                    y2.black(true);
                    x2.left = y2.right;
                    y2.right = x2;
                    if (i2 < 2) {
                        this.tree = y2;
                    } else if (this.dirPath[i2 - 2]) {
                        this.nodePath[i2 - 2].right = y2;
                    } else {
                        this.nodePath[i2 - 2].left = y2;
                    }
                    if (!y2.succ()) break;
                    y2.succ(false);
                    x2.pred(y2);
                    break;
                }
                y2 = this.nodePath[i2 - 1].left;
                if (!this.nodePath[i2 - 1].pred() && !y2.black()) {
                    this.nodePath[i2].black(true);
                    y2.black(true);
                    this.nodePath[i2 - 1].black(false);
                    i2 -= 2;
                    continue;
                }
                if (this.dirPath[i2]) {
                    y2 = this.nodePath[i2];
                } else {
                    x2 = this.nodePath[i2];
                    y2 = x2.left;
                    x2.left = y2.right;
                    y2.right = x2;
                    this.nodePath[i2 - 1].right = y2;
                    if (y2.succ()) {
                        y2.succ(false);
                        x2.pred(y2);
                    }
                }
                x2 = this.nodePath[i2 - 1];
                x2.black(false);
                y2.black(true);
                x2.right = y2.left;
                y2.left = x2;
                if (i2 < 2) {
                    this.tree = y2;
                } else if (this.dirPath[i2 - 2]) {
                    this.nodePath[i2 - 2].right = y2;
                } else {
                    this.nodePath[i2 - 2].left = y2;
                }
                if (!y2.pred()) break;
                y2.pred(false);
                x2.succ(y2);
                break;
            }
        }
        this.tree.black(true);
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean remove(Object k2) {
        int i2;
        Entry<K> p2;
        block68: {
            Entry s2;
            int j2;
            boolean color;
            block74: {
                block69: {
                    Entry r2;
                    block73: {
                        block71: {
                            block72: {
                                block66: {
                                    block67: {
                                        if (this.tree == null) {
                                            return false;
                                        }
                                        p2 = this.tree;
                                        i2 = 0;
                                        Object kk = k2;
                                        while (true) {
                                            int cmp;
                                            if ((cmp = this.compare(kk, p2.key)) == 0) {
                                                if (p2.left != null) break block66;
                                                break block67;
                                            }
                                            this.dirPath[i2] = cmp > 0;
                                            this.nodePath[i2] = p2;
                                            if (this.dirPath[i2++]) {
                                                if ((p2 = p2.right()) != null) continue;
                                                while (true) {
                                                    if (i2-- == 0) {
                                                        return false;
                                                    }
                                                    this.nodePath[i2] = null;
                                                }
                                            }
                                            if ((p2 = p2.left()) == null) break;
                                        }
                                        while (true) {
                                            if (i2-- == 0) {
                                                return false;
                                            }
                                            this.nodePath[i2] = null;
                                        }
                                    }
                                    this.firstEntry = p2.next();
                                }
                                if (p2.right == null) {
                                    this.lastEntry = p2.prev();
                                }
                                if (!p2.succ()) break block71;
                                if (!p2.pred()) break block72;
                                if (i2 == 0) {
                                    this.tree = p2.left;
                                    break block68;
                                } else if (this.dirPath[i2 - 1]) {
                                    this.nodePath[i2 - 1].succ(p2.right);
                                    break block68;
                                } else {
                                    this.nodePath[i2 - 1].pred(p2.left);
                                }
                                break block68;
                            }
                            p2.prev().right = p2.right;
                            if (i2 == 0) {
                                this.tree = p2.left;
                                break block68;
                            } else if (this.dirPath[i2 - 1]) {
                                this.nodePath[i2 - 1].right = p2.left;
                                break block68;
                            } else {
                                this.nodePath[i2 - 1].left = p2.left;
                            }
                            break block68;
                        }
                        r2 = p2.right;
                        if (!r2.pred()) break block73;
                        r2.left = p2.left;
                        r2.pred(p2.pred());
                        if (!r2.pred()) {
                            r2.prev().right = r2;
                        }
                        if (i2 == 0) {
                            this.tree = r2;
                        } else if (this.dirPath[i2 - 1]) {
                            this.nodePath[i2 - 1].right = r2;
                        } else {
                            this.nodePath[i2 - 1].left = r2;
                        }
                        color = r2.black();
                        r2.black(p2.black());
                        p2.black(color);
                        this.dirPath[i2] = true;
                        this.nodePath[i2++] = r2;
                        break block68;
                    }
                    j2 = i2++;
                    while (true) {
                        this.dirPath[i2] = false;
                        this.nodePath[i2++] = r2;
                        s2 = r2.left;
                        if (s2.pred()) {
                            this.dirPath[j2] = true;
                            this.nodePath[j2] = s2;
                            if (s2.succ()) {
                                break;
                            }
                            break block69;
                        }
                        r2 = s2;
                    }
                    r2.pred(s2);
                    break block74;
                }
                r2.left = s2.right;
            }
            s2.left = p2.left;
            if (!p2.pred()) {
                p2.prev().right = s2;
                s2.pred(false);
            }
            s2.right(p2.right);
            color = s2.black();
            s2.black(p2.black());
            p2.black(color);
            if (j2 == 0) {
                this.tree = s2;
            } else if (this.dirPath[j2 - 1]) {
                this.nodePath[j2 - 1].right = s2;
            } else {
                this.nodePath[j2 - 1].left = s2;
            }
        }
        int maxDepth = i2;
        if (p2.black()) {
            while (i2 > 0) {
                block70: {
                    Entry y2;
                    Entry w2;
                    if (this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].succ() || !this.dirPath[i2 - 1] && !this.nodePath[i2 - 1].pred()) {
                        Entry x2;
                        Entry entry = x2 = this.dirPath[i2 - 1] ? this.nodePath[i2 - 1].right : this.nodePath[i2 - 1].left;
                        if (!x2.black()) {
                            x2.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[i2 - 1]) {
                        w2 = this.nodePath[i2 - 1].right;
                        if (!w2.black()) {
                            w2.black(true);
                            this.nodePath[i2 - 1].black(false);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            this.nodePath[i2] = this.nodePath[i2 - 1];
                            this.dirPath[i2] = false;
                            this.nodePath[i2 - 1] = w2;
                            if (maxDepth == i2++) {
                                ++maxDepth;
                            }
                            w2 = this.nodePath[i2 - 1].right;
                        }
                        if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                            w2.black(false);
                            break block70;
                        } else {
                            if (w2.succ() || w2.right.black()) {
                                y2 = w2.left;
                                y2.black(true);
                                w2.black(false);
                                w2.left = y2.right;
                                y2.right = w2;
                                this.nodePath[i2 - 1].right = y2;
                                w2 = this.nodePath[i2 - 1].right;
                                if (w2.succ()) {
                                    w2.succ(false);
                                    w2.right.pred(w2);
                                }
                            }
                            w2.black(this.nodePath[i2 - 1].black());
                            this.nodePath[i2 - 1].black(true);
                            w2.right.black(true);
                            this.nodePath[i2 - 1].right = w2.left;
                            w2.left = this.nodePath[i2 - 1];
                            if (i2 < 2) {
                                this.tree = w2;
                            } else if (this.dirPath[i2 - 2]) {
                                this.nodePath[i2 - 2].right = w2;
                            } else {
                                this.nodePath[i2 - 2].left = w2;
                            }
                            if (!w2.pred()) break;
                            w2.pred(false);
                            this.nodePath[i2 - 1].succ(w2);
                            break;
                        }
                    }
                    w2 = this.nodePath[i2 - 1].left;
                    if (!w2.black()) {
                        w2.black(true);
                        this.nodePath[i2 - 1].black(false);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        this.nodePath[i2] = this.nodePath[i2 - 1];
                        this.dirPath[i2] = true;
                        this.nodePath[i2 - 1] = w2;
                        if (maxDepth == i2++) {
                            ++maxDepth;
                        }
                        w2 = this.nodePath[i2 - 1].left;
                    }
                    if ((w2.pred() || w2.left.black()) && (w2.succ() || w2.right.black())) {
                        w2.black(false);
                    } else {
                        if (w2.pred() || w2.left.black()) {
                            y2 = w2.right;
                            y2.black(true);
                            w2.black(false);
                            w2.right = y2.left;
                            y2.left = w2;
                            this.nodePath[i2 - 1].left = y2;
                            w2 = this.nodePath[i2 - 1].left;
                            if (w2.pred()) {
                                w2.pred(false);
                                w2.left.succ(w2);
                            }
                        }
                        w2.black(this.nodePath[i2 - 1].black());
                        this.nodePath[i2 - 1].black(true);
                        w2.left.black(true);
                        this.nodePath[i2 - 1].left = w2.right;
                        w2.right = this.nodePath[i2 - 1];
                        if (i2 < 2) {
                            this.tree = w2;
                        } else if (this.dirPath[i2 - 2]) {
                            this.nodePath[i2 - 2].right = w2;
                        } else {
                            this.nodePath[i2 - 2].left = w2;
                        }
                        if (!w2.succ()) break;
                        w2.succ(false);
                        this.nodePath[i2 - 1].pred(w2);
                        break;
                    }
                }
                --i2;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        --this.count;
        while (maxDepth-- != 0) {
            this.nodePath[maxDepth] = null;
        }
        return true;
    }

    @Override
    public boolean contains(Object k2) {
        return this.findKey(k2) != null;
    }

    public K get(Object k2) {
        Entry<Object> entry = this.findKey(k2);
        return entry == null ? null : (K)entry.key;
    }

    @Override
    public void clear() {
        this.count = 0;
        this.tree = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public K first() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    @Override
    public K last() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    @Override
    public ObjectBidirectionalIterator<K> iterator() {
        return new SetIterator();
    }

    @Override
    public ObjectBidirectionalIterator<K> iterator(K from) {
        return new SetIterator(from);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.actualComparator;
    }

    @Override
    public ObjectSortedSet<K> headSet(K to) {
        return new Subset(null, true, to, false);
    }

    @Override
    public ObjectSortedSet<K> tailSet(K from) {
        return new Subset(from, false, null, true);
    }

    @Override
    public ObjectSortedSet<K> subSet(K from, K to) {
        return new Subset(from, false, to, false);
    }

    public Object clone() {
        ObjectRBTreeSet c2;
        try {
            c2 = (ObjectRBTreeSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.allocatePaths();
        if (this.count != 0) {
            Entry<K> rp = new Entry<K>();
            Entry rq = new Entry();
            Entry<K> p2 = rp;
            rp.left(this.tree);
            Entry q2 = rq;
            rq.pred(null);
            while (true) {
                Object e2;
                if (!p2.pred()) {
                    e2 = p2.left.clone();
                    ((Entry)e2).pred(q2.left);
                    ((Entry)e2).succ(q2);
                    q2.left(e2);
                    p2 = p2.left;
                    q2 = q2.left;
                } else {
                    while (p2.succ()) {
                        p2 = p2.right;
                        if (p2 == null) {
                            q2.right = null;
                            c2.tree = rq.left;
                            c2.firstEntry = c2.tree;
                            while (c2.firstEntry.left != null) {
                                c2.firstEntry = c2.firstEntry.left;
                            }
                            c2.lastEntry = c2.tree;
                            while (c2.lastEntry.right != null) {
                                c2.lastEntry = c2.lastEntry.right;
                            }
                            return c2;
                        }
                        q2 = q2.right;
                    }
                    p2 = p2.right;
                    q2 = q2.right;
                }
                if (p2.succ()) continue;
                e2 = p2.right.clone();
                ((Entry)e2).succ(q2.right);
                ((Entry)e2).pred(q2);
                q2.right(e2);
            }
        }
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int n2 = this.count;
        SetIterator i2 = new SetIterator();
        s2.defaultWriteObject();
        while (n2-- != 0) {
            s2.writeObject(i2.next());
        }
    }

    private Entry<K> readTree(ObjectInputStream s2, int n2, Entry<K> pred, Entry<K> succ) throws IOException, ClassNotFoundException {
        if (n2 == 1) {
            Entry<Object> top = new Entry<Object>(s2.readObject());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n2 == 2) {
            Entry<Object> top = new Entry<Object>(s2.readObject());
            top.black(true);
            top.right(new Entry<Object>(s2.readObject()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n2 / 2;
        int leftN = n2 - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s2, leftN, pred, top));
        top.key = s2.readObject();
        top.black(true);
        top.right(this.readTree(s2, rightN, top, succ));
        if (n2 + 2 == (n2 + 2 & -(n2 + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            this.tree = this.readTree(s2, this.count, null, null);
            Entry<K> e2 = this.tree;
            while (e2.left() != null) {
                e2 = e2.left();
            }
            this.firstEntry = e2;
            e2 = this.tree;
            while (e2.right() != null) {
                e2 = e2.right();
            }
            this.lastEntry = e2;
        }
    }

    private void checkNodePath() {
    }

    private int checkTree(Entry<K> e2, int d2, int D2) {
        return 0;
    }

    private final class Subset
    extends AbstractObjectSortedSet<K>
    implements Serializable,
    ObjectSortedSet<K> {
        private static final long serialVersionUID = -7046029254386353129L;
        K from;
        K to;
        boolean bottom;
        boolean top;

        public Subset(K from, boolean bottom, K to, boolean top) {
            if (!bottom && !top && ObjectRBTreeSet.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start element (" + from + ") is larger than end element (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
        }

        @Override
        public void clear() {
            SubsetIterator i2 = new SubsetIterator();
            while (i2.hasNext()) {
                i2.next();
                i2.remove();
            }
        }

        final boolean in(K k2) {
            return !(!this.bottom && ObjectRBTreeSet.this.compare(k2, this.from) < 0 || !this.top && ObjectRBTreeSet.this.compare(k2, this.to) >= 0);
        }

        @Override
        public boolean contains(Object k2) {
            return this.in(k2) && ObjectRBTreeSet.this.contains(k2);
        }

        @Override
        public boolean add(K k2) {
            if (!this.in(k2)) {
                throw new IllegalArgumentException("Element (" + k2 + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            return ObjectRBTreeSet.this.add(k2);
        }

        @Override
        public boolean remove(Object k2) {
            if (!this.in(k2)) {
                return false;
            }
            return ObjectRBTreeSet.this.remove(k2);
        }

        @Override
        public int size() {
            SubsetIterator i2 = new SubsetIterator();
            int n2 = 0;
            while (i2.hasNext()) {
                ++n2;
                i2.next();
            }
            return n2;
        }

        @Override
        public boolean isEmpty() {
            return !new SubsetIterator().hasNext();
        }

        @Override
        public Comparator<? super K> comparator() {
            return ObjectRBTreeSet.this.actualComparator;
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator() {
            return new SubsetIterator();
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator(K from) {
            return new SubsetIterator(from);
        }

        @Override
        public ObjectSortedSet<K> headSet(K to) {
            if (this.top) {
                return new Subset(this.from, this.bottom, to, false);
            }
            return ObjectRBTreeSet.this.compare(to, this.to) < 0 ? new Subset(this.from, this.bottom, to, false) : this;
        }

        @Override
        public ObjectSortedSet<K> tailSet(K from) {
            if (this.bottom) {
                return new Subset(from, false, this.to, this.top);
            }
            return ObjectRBTreeSet.this.compare(from, this.from) > 0 ? new Subset(from, false, this.to, this.top) : this;
        }

        @Override
        public ObjectSortedSet<K> subSet(K from, K to) {
            if (this.top && this.bottom) {
                return new Subset(from, false, to, false);
            }
            if (!this.top) {
                Object k2 = to = ObjectRBTreeSet.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                Object k3 = from = ObjectRBTreeSet.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Subset(from, false, to, false);
        }

        public Entry<K> firstEntry() {
            Entry e2;
            if (ObjectRBTreeSet.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e2 = ObjectRBTreeSet.this.firstEntry;
            } else {
                e2 = ObjectRBTreeSet.this.locateKey(this.from);
                if (ObjectRBTreeSet.this.compare(e2.key, this.from) < 0) {
                    e2 = e2.next();
                }
            }
            if (e2 == null || !this.top && ObjectRBTreeSet.this.compare(e2.key, this.to) >= 0) {
                return null;
            }
            return e2;
        }

        public Entry<K> lastEntry() {
            Entry e2;
            if (ObjectRBTreeSet.this.tree == null) {
                return null;
            }
            if (this.top) {
                e2 = ObjectRBTreeSet.this.lastEntry;
            } else {
                e2 = ObjectRBTreeSet.this.locateKey(this.to);
                if (ObjectRBTreeSet.this.compare(e2.key, this.to) >= 0) {
                    e2 = e2.prev();
                }
            }
            if (e2 == null || !this.bottom && ObjectRBTreeSet.this.compare(e2.key, this.from) < 0) {
                return null;
            }
            return e2;
        }

        @Override
        public K first() {
            Entry e2 = this.firstEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        @Override
        public K last() {
            Entry e2 = this.lastEntry();
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            return e2.key;
        }

        private final class SubsetIterator
        extends SetIterator {
            SubsetIterator() {
                this.next = Subset.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubsetIterator(K k2) {
                this();
                if (this.next == null) return;
                if (!subset.bottom && subset.ObjectRBTreeSet.this.compare(k2, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!subset.top) {
                    this.prev = subset.lastEntry();
                    if (subset.ObjectRBTreeSet.this.compare(k2, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = subset.ObjectRBTreeSet.this.locateKey(k2);
                if (subset.ObjectRBTreeSet.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            @Override
            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Subset.this.bottom && this.prev != null && ObjectRBTreeSet.this.compare(this.prev.key, Subset.this.from) < 0) {
                    this.prev = null;
                }
            }

            @Override
            void updateNext() {
                this.next = this.next.next();
                if (!Subset.this.top && this.next != null && ObjectRBTreeSet.this.compare(this.next.key, Subset.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private class SetIterator
    extends AbstractObjectListIterator<K> {
        Entry<K> prev;
        Entry<K> next;
        Entry<K> curr;
        int index = 0;

        SetIterator() {
            this.next = ObjectRBTreeSet.this.firstEntry;
        }

        SetIterator(K k2) {
            this.next = ObjectRBTreeSet.this.locateKey(k2);
            if (this.next != null) {
                if (ObjectRBTreeSet.this.compare(this.next.key, k2) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry<K> nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.curr = this.prev;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }

        @Override
        public K previous() {
            return this.previousEntry().key;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry<K> previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.prev;
            this.curr = this.next;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.prev = this.curr;
            this.next = this.prev;
            this.updatePrevious();
            this.updateNext();
            ObjectRBTreeSet.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry<K>
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        K key;
        Entry<K> left;
        Entry<K> right;
        int info;

        Entry() {
        }

        Entry(K k2) {
            this.key = k2;
            this.info = -1073741824;
        }

        Entry<K> left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry<K> right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry<K> pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry<K> succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry<K> left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry<K> right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry<K> next() {
            Entry<K> next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry<K> prev() {
            Entry<K> prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Entry<K> clone() {
            Entry c2;
            try {
                c2 = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c2.key = this.key;
            c2.info = this.info;
            return c2;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Entry)) {
                return false;
            }
            Entry e2 = (Entry)o2;
            return this.key == null ? e2.key == null : this.key.equals(e2.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return String.valueOf(this.key);
        }
    }
}

