/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers.deobf;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.asm.transformers.deobf.LZMAInputSupplier;
import cpw.mods.fml.common.patcher.ClassPatchManager;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class FMLDeobfuscatingRemapper
extends Remapper {
    public static final FMLDeobfuscatingRemapper INSTANCE = new FMLDeobfuscatingRemapper();
    private BiMap<String, String> classNameBiMap;
    private BiMap<String, String> mcpNameBiMap;
    private Map<String, Map<String, String>> rawFieldMaps;
    private Map<String, Map<String, String>> rawMethodMaps;
    private Map<String, Map<String, String>> fieldNameMaps;
    private Map<String, Map<String, String>> methodNameMaps;
    private LaunchClassLoader classLoader;
    private static final boolean DEBUG_REMAPPING = Boolean.parseBoolean(System.getProperty("fml.remappingDebug", "false"));
    private static final boolean DUMP_FIELD_MAPS = Boolean.parseBoolean(System.getProperty("fml.remappingDebug.dumpFieldMaps", "false")) && DEBUG_REMAPPING;
    private static final boolean DUMP_METHOD_MAPS = Boolean.parseBoolean(System.getProperty("fml.remappingDebug.dumpMethodMaps", "false")) && DEBUG_REMAPPING;
    private Map<String, Map<String, String>> fieldDescriptions = Maps.newHashMap();
    private Set<String> negativeCacheMethods = Sets.newHashSet();
    private Set<String> negativeCacheFields = Sets.newHashSet();

    private FMLDeobfuscatingRemapper() {
        this.classNameBiMap = ImmutableBiMap.of();
        this.mcpNameBiMap = ImmutableBiMap.of();
    }

    public void setupLoadOnly(String deobfFileName, boolean loadAll) {
        try {
            File mapData = new File(deobfFileName);
            LZMAInputSupplier zis = new LZMAInputSupplier(new FileInputStream(mapData));
            InputSupplier srgSupplier = CharStreams.newReaderSupplier((InputSupplier)zis, (Charset)Charsets.UTF_8);
            List srgList = CharStreams.readLines((InputSupplier)srgSupplier);
            this.rawMethodMaps = Maps.newHashMap();
            this.rawFieldMaps = Maps.newHashMap();
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            ImmutableBiMap.Builder mcpBuilder = ImmutableBiMap.builder();
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ")).omitEmptyStrings().trimResults();
            for (String line : srgList) {
                String[] parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class);
                String typ = parts[0];
                if ("CL".equals(typ)) {
                    this.parseClass((ImmutableBiMap.Builder<String, String>)builder, parts);
                    this.parseMCPClass((ImmutableBiMap.Builder<String, String>)mcpBuilder, parts);
                    continue;
                }
                if ("MD".equals(typ) && loadAll) {
                    this.parseMethod(parts);
                    continue;
                }
                if (!"FD".equals(typ) || !loadAll) continue;
                this.parseField(parts);
            }
            this.classNameBiMap = builder.build();
            mcpBuilder.put((Object)"BaseMod", (Object)"net/minecraft/src/BaseMod");
            mcpBuilder.put((Object)"ModLoader", (Object)"net/minecraft/src/ModLoader");
            mcpBuilder.put((Object)"EntityRendererProxy", (Object)"net/minecraft/src/EntityRendererProxy");
            mcpBuilder.put((Object)"MLProp", (Object)"net/minecraft/src/MLProp");
            mcpBuilder.put((Object)"TradeEntry", (Object)"net/minecraft/src/TradeEntry");
            this.mcpNameBiMap = mcpBuilder.build();
        }
        catch (IOException ioe) {
            Logger.getLogger("FML").log(Level.SEVERE, "An error occurred loading the deobfuscation map data", ioe);
        }
        this.methodNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawMethodMaps.size());
        this.fieldNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawFieldMaps.size());
    }

    public void setup(File mcDir, LaunchClassLoader classLoader, String deobfFileName) {
        this.classLoader = classLoader;
        try {
            InputStream classData = ((Object)((Object)this)).getClass().getResourceAsStream(deobfFileName);
            LZMAInputSupplier zis = new LZMAInputSupplier(classData);
            InputSupplier srgSupplier = CharStreams.newReaderSupplier((InputSupplier)zis, (Charset)Charsets.UTF_8);
            List srgList = CharStreams.readLines((InputSupplier)srgSupplier);
            this.rawMethodMaps = Maps.newHashMap();
            this.rawFieldMaps = Maps.newHashMap();
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            ImmutableBiMap.Builder mcpBuilder = ImmutableBiMap.builder();
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)": ")).omitEmptyStrings().trimResults();
            for (String line : srgList) {
                String[] parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class);
                String typ = parts[0];
                if ("CL".equals(typ)) {
                    this.parseClass((ImmutableBiMap.Builder<String, String>)builder, parts);
                    this.parseMCPClass((ImmutableBiMap.Builder<String, String>)mcpBuilder, parts);
                    continue;
                }
                if ("MD".equals(typ)) {
                    this.parseMethod(parts);
                    continue;
                }
                if (!"FD".equals(typ)) continue;
                this.parseField(parts);
            }
            this.classNameBiMap = builder.build();
            mcpBuilder.put((Object)"BaseMod", (Object)"net/minecraft/src/BaseMod");
            mcpBuilder.put((Object)"ModLoader", (Object)"net/minecraft/src/ModLoader");
            mcpBuilder.put((Object)"EntityRendererProxy", (Object)"net/minecraft/src/EntityRendererProxy");
            mcpBuilder.put((Object)"MLProp", (Object)"net/minecraft/src/MLProp");
            mcpBuilder.put((Object)"TradeEntry", (Object)"net/minecraft/src/TradeEntry");
            this.mcpNameBiMap = mcpBuilder.build();
        }
        catch (IOException ioe) {
            FMLRelaunchLog.log(Level.SEVERE, ioe, "An error occurred loading the deobfuscation map data", new Object[0]);
        }
        this.methodNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawMethodMaps.size());
        this.fieldNameMaps = Maps.newHashMapWithExpectedSize((int)this.rawFieldMaps.size());
    }

    public boolean isRemappedClass(String className) {
        return this.classNameBiMap.containsKey((Object)(className = className.replace('.', '/'))) || this.mcpNameBiMap.containsKey((Object)className) || !this.classNameBiMap.isEmpty() && className.indexOf(47) == -1;
    }

    private void parseField(String[] parts) {
        String oldSrg = parts[1];
        int lastOld = oldSrg.lastIndexOf(47);
        String cl2 = oldSrg.substring(0, lastOld);
        String oldName = oldSrg.substring(lastOld + 1);
        String newSrg = parts[2];
        int lastNew = newSrg.lastIndexOf(47);
        String newName = newSrg.substring(lastNew + 1);
        if (!this.rawFieldMaps.containsKey(cl2)) {
            this.rawFieldMaps.put(cl2, Maps.newHashMap());
        }
        this.rawFieldMaps.get(cl2).put(oldName + ":" + this.getFieldType(cl2, oldName), newName);
        this.rawFieldMaps.get(cl2).put(oldName + ":null", newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFieldType(String owner, String name) {
        if (this.fieldDescriptions.containsKey(owner)) {
            return this.fieldDescriptions.get(owner).get(name);
        }
        Map<String, Map<String, String>> map = this.fieldDescriptions;
        synchronized (map) {
            try {
                byte[] classBytes = ClassPatchManager.INSTANCE.getPatchedResource(owner, this.map(owner).replace('/', '.'), this.classLoader);
                if (classBytes == null) {
                    return null;
                }
                ClassReader cr2 = new ClassReader(classBytes);
                ClassNode classNode = new ClassNode();
                cr2.accept((ClassVisitor)classNode, 7);
                HashMap resMap = Maps.newHashMap();
                for (FieldNode fieldNode : classNode.fields) {
                    resMap.put(fieldNode.name, fieldNode.desc);
                }
                this.fieldDescriptions.put(owner, resMap);
                return (String)resMap.get(name);
            }
            catch (IOException e2) {
                FMLLog.log(Level.SEVERE, e2, "A critical exception occured reading a class file %s", owner);
                return null;
            }
        }
    }

    private void parseClass(ImmutableBiMap.Builder<String, String> builder, String[] parts) {
        builder.put((Object)parts[1], (Object)parts[2]);
    }

    private void parseMCPClass(ImmutableBiMap.Builder<String, String> builder, String[] parts) {
        int clIdx = parts[2].lastIndexOf(47);
        builder.put((Object)("net/minecraft/src/" + parts[2].substring(clIdx + 1)), (Object)parts[2]);
    }

    private void parseMethod(String[] parts) {
        String oldSrg = parts[1];
        int lastOld = oldSrg.lastIndexOf(47);
        String cl2 = oldSrg.substring(0, lastOld);
        String oldName = oldSrg.substring(lastOld + 1);
        String sig = parts[2];
        String newSrg = parts[3];
        int lastNew = newSrg.lastIndexOf(47);
        String newName = newSrg.substring(lastNew + 1);
        if (!this.rawMethodMaps.containsKey(cl2)) {
            this.rawMethodMaps.put(cl2, Maps.newHashMap());
        }
        this.rawMethodMaps.get(cl2).put(oldName + sig, newName);
    }

    public String mapFieldName(String owner, String name, String desc) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return name;
        }
        Map<String, String> fieldMap = this.getFieldMap(owner);
        return fieldMap != null && fieldMap.containsKey(name + ":" + desc) ? fieldMap.get(name + ":" + desc) : name;
    }

    public String map(String typeName) {
        String subType;
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return typeName;
        }
        int dollarIdx = typeName.indexOf(36);
        String realType = dollarIdx > -1 ? typeName.substring(0, dollarIdx) : typeName;
        String string = subType = dollarIdx > -1 ? typeName.substring(dollarIdx + 1) : "";
        String result = this.classNameBiMap.containsKey((Object)realType) ? (String)this.classNameBiMap.get((Object)realType) : (this.mcpNameBiMap.containsKey((Object)realType) ? (String)this.mcpNameBiMap.get((Object)realType) : realType);
        result = dollarIdx > -1 ? result + "$" + subType : result;
        return result;
    }

    public String unmap(String typeName) {
        String subType;
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return typeName;
        }
        int dollarIdx = typeName.indexOf(36);
        String realType = dollarIdx > -1 ? typeName.substring(0, dollarIdx) : typeName;
        String string = subType = dollarIdx > -1 ? typeName.substring(dollarIdx + 1) : "";
        String result = this.classNameBiMap.containsValue((Object)realType) ? (String)this.classNameBiMap.inverse().get((Object)realType) : (this.mcpNameBiMap.containsValue((Object)realType) ? (String)this.mcpNameBiMap.inverse().get((Object)realType) : realType);
        result = dollarIdx > -1 ? result + "$" + subType : result;
        return result;
    }

    public String mapMethodName(String owner, String name, String desc) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return name;
        }
        Map<String, String> methodMap = this.getMethodMap(owner);
        String methodDescriptor = name + desc;
        return methodMap != null && methodMap.containsKey(methodDescriptor) ? methodMap.get(methodDescriptor) : name;
    }

    private Map<String, String> getFieldMap(String className) {
        if (!this.fieldNameMaps.containsKey(className) && !this.negativeCacheFields.contains(className)) {
            this.findAndMergeSuperMaps(className);
            if (!this.fieldNameMaps.containsKey(className)) {
                this.negativeCacheFields.add(className);
            }
            if (DUMP_FIELD_MAPS) {
                FMLRelaunchLog.finest("Field map for %s : %s", className, this.fieldNameMaps.get(className));
            }
        }
        return this.fieldNameMaps.get(className);
    }

    private Map<String, String> getMethodMap(String className) {
        if (!this.methodNameMaps.containsKey(className) && !this.negativeCacheMethods.contains(className)) {
            this.findAndMergeSuperMaps(className);
            if (!this.methodNameMaps.containsKey(className)) {
                this.negativeCacheMethods.add(className);
            }
            if (DUMP_METHOD_MAPS) {
                FMLRelaunchLog.finest("Method map for %s : %s", className, this.methodNameMaps.get(className));
            }
        }
        return this.methodNameMaps.get(className);
    }

    private void findAndMergeSuperMaps(String name) {
        try {
            String superName = null;
            String[] interfaces = new String[]{};
            byte[] classBytes = ClassPatchManager.INSTANCE.getPatchedResource(name, this.map(name), this.classLoader);
            if (classBytes != null) {
                ClassReader cr2 = new ClassReader(classBytes);
                superName = cr2.getSuperName();
                interfaces = cr2.getInterfaces();
            }
            this.mergeSuperMaps(name, superName, interfaces);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void mergeSuperMaps(String name, String superName, String[] interfaces) {
        if (this.classNameBiMap == null || this.classNameBiMap.isEmpty()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)superName)) {
            return;
        }
        ImmutableList allParents = ImmutableList.builder().add((Object)superName).addAll(Arrays.asList(interfaces)).build();
        for (String parentThing : allParents) {
            if (this.methodNameMaps.containsKey(parentThing)) continue;
            this.findAndMergeSuperMaps(parentThing);
        }
        HashMap methodMap = Maps.newHashMap();
        HashMap fieldMap = Maps.newHashMap();
        for (String parentThing : allParents) {
            if (this.methodNameMaps.containsKey(parentThing)) {
                methodMap.putAll(this.methodNameMaps.get(parentThing));
            }
            if (!this.fieldNameMaps.containsKey(parentThing)) continue;
            fieldMap.putAll(this.fieldNameMaps.get(parentThing));
        }
        if (this.rawMethodMaps.containsKey(name)) {
            methodMap.putAll(this.rawMethodMaps.get(name));
        }
        if (this.rawFieldMaps.containsKey(name)) {
            fieldMap.putAll(this.rawFieldMaps.get(name));
        }
        this.methodNameMaps.put(name, (Map<String, String>)ImmutableMap.copyOf((Map)methodMap));
        this.fieldNameMaps.put(name, (Map<String, String>)ImmutableMap.copyOf((Map)fieldMap));
    }

    public Set<String> getObfedClasses() {
        return ImmutableSet.copyOf((Collection)this.classNameBiMap.keySet());
    }
}

