/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.CharComparator;

public class CharHeaps {
    private CharHeaps() {
    }

    public static int downHeap(char[] heap, int size, int i2, CharComparator c2) {
        assert (i2 < size);
        char e2 = heap[i2];
        if (c2 == null) {
            int child;
            while ((child = (i2 << 1) + 1) < size) {
                char t2 = heap[child];
                int right = child + 1;
                if (right < size && heap[right] < t2) {
                    child = right;
                    t2 = heap[child];
                }
                if (e2 > t2) {
                    heap[i2] = t2;
                    i2 = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = (i2 << 1) + 1) < size) {
                char t3 = heap[child];
                int right = child + 1;
                if (right < size && c2.compare(heap[right], t3) < 0) {
                    child = right;
                    t3 = heap[child];
                }
                if (c2.compare(e2, t3) > 0) {
                    heap[i2] = t3;
                    i2 = child;
                    continue;
                }
                break;
            }
        }
        heap[i2] = e2;
        return i2;
    }

    public static int upHeap(char[] heap, int size, int i2, CharComparator c2) {
        assert (i2 < size);
        char e2 = heap[i2];
        if (c2 == null) {
            int parent;
            char t2;
            while (i2 != 0 && (t2 = heap[parent = i2 - 1 >>> 1]) > e2) {
                heap[i2] = t2;
                i2 = parent;
            }
        } else {
            int parent;
            char t3;
            while (i2 != 0 && c2.compare(t3 = heap[parent = i2 - 1 >>> 1], e2) > 0) {
                heap[i2] = t3;
                i2 = parent;
            }
        }
        heap[i2] = e2;
        return i2;
    }

    public static void makeHeap(char[] heap, int size, CharComparator c2) {
        int i2 = size >>> 1;
        while (i2-- != 0) {
            CharHeaps.downHeap(heap, size, i2, c2);
        }
    }
}

