/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;

public class DoubleArraySet
extends AbstractDoubleSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient double[] a;
    private int size;

    public DoubleArraySet(double[] a2) {
        this.a = a2;
        this.size = a2.length;
    }

    public DoubleArraySet() {
        this.a = DoubleArrays.EMPTY_ARRAY;
    }

    public DoubleArraySet(int capacity) {
        this.a = new double[capacity];
    }

    public DoubleArraySet(DoubleCollection c2) {
        this(c2.size());
        this.addAll(c2);
    }

    public DoubleArraySet(Collection<? extends Double> c2) {
        this(c2.size());
        this.addAll(c2);
    }

    public DoubleArraySet(double[] a2, int size) {
        this.a = a2;
        this.size = size;
        if (size > a2.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a2.length + ")");
        }
    }

    private int findKey(double o2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (Double.doubleToLongBits(this.a[i2]) != Double.doubleToLongBits(o2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public DoubleIterator iterator() {
        return new AbstractDoubleIterator(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < DoubleArraySet.this.size;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DoubleArraySet.this.a[this.next++];
            }

            @Override
            public void remove() {
                int tail = DoubleArraySet.this.size-- - this.next--;
                System.arraycopy(DoubleArraySet.this.a, this.next + 1, DoubleArraySet.this.a, this.next, tail);
            }
        };
    }

    @Override
    public boolean contains(double k2) {
        return this.findKey(k2) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(double k2) {
        int pos = this.findKey(k2);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i2 = 0; i2 < tail; ++i2) {
            this.a[pos + i2] = this.a[pos + i2 + 1];
        }
        --this.size;
        return true;
    }

    @Override
    public boolean add(double k2) {
        int pos = this.findKey(k2);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            double[] b2 = new double[this.size == 0 ? 2 : this.size * 2];
            int i2 = this.size;
            while (i2-- != 0) {
                b2[i2] = this.a[i2];
            }
            this.a = b2;
        }
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public DoubleArraySet clone() {
        DoubleArraySet c2;
        try {
            c2 = (DoubleArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.a = (double[])this.a.clone();
        return c2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeDouble(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new double[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readDouble();
        }
    }
}

