/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleBigList;
import it.unimi.dsi.fastutil.doubles.DoubleBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleBigList;
import it.unimi.dsi.fastutil.doubles.DoubleBigListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleBigListIterators;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollections;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;

public class DoubleBigLists {
    public static final EmptyBigList EMPTY_BIG_LIST = new EmptyBigList();

    private DoubleBigLists() {
    }

    public static DoubleBigList shuffle(DoubleBigList l2, Random random) {
        long i2 = l2.size64();
        while (i2-- != 0L) {
            long p2 = (random.nextLong() & Long.MAX_VALUE) % (i2 + 1L);
            double t2 = l2.getDouble(i2);
            l2.set(i2, l2.getDouble(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static DoubleBigList singleton(double element) {
        return new Singleton(element);
    }

    public static DoubleBigList singleton(Object element) {
        return new Singleton((Double)element);
    }

    public static DoubleBigList synchronize(DoubleBigList l2) {
        return new SynchronizedBigList(l2);
    }

    public static DoubleBigList synchronize(DoubleBigList l2, Object sync) {
        return new SynchronizedBigList(l2, sync);
    }

    public static DoubleBigList unmodifiable(DoubleBigList l2) {
        return new UnmodifiableBigList(l2);
    }

    public static DoubleBigList asBigList(DoubleList list) {
        return new ListBigList(list);
    }

    public static class ListBigList
    extends AbstractDoubleBigList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final DoubleList list;

        protected ListBigList(DoubleList list) {
            this.list = list;
        }

        private int intIndex(long index) {
            if (index >= Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("This big list is restricted to 32-bit indices");
            }
            return (int)index;
        }

        @Override
        public long size64() {
            return this.list.size();
        }

        @Override
        public void size(long size) {
            this.list.size(this.intIndex(size));
        }

        @Override
        public DoubleBigListIterator iterator() {
            return DoubleBigListIterators.asBigListIterator(this.list.iterator());
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.asBigListIterator(this.list.listIterator());
        }

        @Override
        public DoubleBigListIterator listIterator(long index) {
            return DoubleBigListIterators.asBigListIterator(this.list.listIterator(this.intIndex(index)));
        }

        @Override
        public boolean addAll(long index, Collection<? extends Double> c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public DoubleBigList subList(long from, long to) {
            return new ListBigList(this.list.subList(this.intIndex(from), this.intIndex(to)));
        }

        @Override
        public boolean contains(double key) {
            return this.list.contains(key);
        }

        @Override
        public double[] toDoubleArray() {
            return this.list.toDoubleArray();
        }

        @Override
        public void removeElements(long from, long to) {
            this.list.removeElements(this.intIndex(from), this.intIndex(to));
        }

        @Override
        @Deprecated
        public double[] toDoubleArray(double[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean addAll(long index, DoubleCollection c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(DoubleCollection c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean addAll(long index, DoubleBigList c2) {
            return this.list.addAll(this.intIndex(index), c2);
        }

        @Override
        public boolean addAll(DoubleBigList c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean containsAll(DoubleCollection c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean removeAll(DoubleCollection c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(DoubleCollection c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void add(long index, double key) {
            this.list.add(this.intIndex(index), key);
        }

        @Override
        public boolean add(double key) {
            return this.list.add(key);
        }

        @Override
        public double getDouble(long index) {
            return this.list.getDouble(this.intIndex(index));
        }

        @Override
        public long indexOf(double k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(double k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public double removeDouble(long index) {
            return this.list.removeDouble(this.intIndex(index));
        }

        @Override
        public double set(long index, double k2) {
            return this.list.set(this.intIndex(index), k2);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.list.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends Double> c2) {
            return this.list.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.list.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.list.retainAll(c2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static class UnmodifiableBigList
    extends DoubleCollections.UnmodifiableCollection
    implements DoubleBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleBigList list;

        protected UnmodifiableBigList(DoubleBigList l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public double getDouble(long i2) {
            return this.list.getDouble(i2);
        }

        @Override
        public double set(long i2, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long i2, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(double k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public long lastIndexOf(double k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(long index, Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(long from, double[][] a2, long offset, long length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, double[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, double[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void size(long size) {
            this.list.size(size);
        }

        @Override
        public long size64() {
            return this.list.size64();
        }

        @Override
        public DoubleBigListIterator iterator() {
            return this.listIterator();
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public DoubleBigListIterator listIterator(long i2) {
            return DoubleBigListIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        public DoubleBigList subList(long from, long to) {
            return DoubleBigLists.unmodifiable(this.list.subList(from, to));
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.list.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int compareTo(BigList<? extends Double> o2) {
            return this.list.compareTo(o2);
        }

        @Override
        public boolean addAll(long index, DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long index, DoubleBigList l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double get(long i2) {
            return this.list.get(i2);
        }

        @Override
        @Deprecated
        public void add(long i2, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double set(long index, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object o2) {
            return this.list.indexOf(o2);
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            return this.list.lastIndexOf(o2);
        }
    }

    public static class SynchronizedBigList
    extends DoubleCollections.SynchronizedCollection
    implements DoubleBigList,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleBigList list;

        protected SynchronizedBigList(DoubleBigList l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedBigList(DoubleBigList l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double getDouble(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getDouble(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double set(long i2, double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(long i2, double k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double removeDouble(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeDouble(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long indexOf(double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long lastIndexOf(double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, Collection<? extends Double> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(long from, double[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, double[][] a2, long offset, long length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(long index, double[][] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void size(long size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size64() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.size64();
            }
        }

        @Override
        public DoubleBigListIterator iterator() {
            return this.list.listIterator();
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public DoubleBigListIterator listIterator(long i2) {
            return this.list.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DoubleBigList subList(long from, long to) {
            Object object = this.sync;
            synchronized (object) {
                return DoubleBigLists.synchronize(this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.list.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compareTo(BigList<? extends Double> o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, DoubleCollection c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(long index, DoubleBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(DoubleBigList l2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void add(long i2, Double k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double get(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double set(long index, Double k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Double remove(long i2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long indexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public long lastIndexOf(Object o2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o2);
            }
        }
    }

    public static class Singleton
    extends AbstractDoubleBigList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final double element;

        private Singleton(double element) {
            this.element = element;
        }

        @Override
        public double getDouble(long i2) {
            if (i2 == 0L) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(double k2) {
            return Double.doubleToLongBits(k2) == Double.doubleToLongBits(this.element);
        }

        @Override
        public double[] toDoubleArray() {
            double[] a2 = new double[]{this.element};
            return a2;
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.singleton(this.element);
        }

        @Override
        public DoubleBigListIterator listIterator(long i2) {
            if (i2 > 1L || i2 < 0L) {
                throw new IndexOutOfBoundsException();
            }
            DoubleBigListIterator l2 = this.listIterator();
            if (i2 == 1L) {
                l2.nextDouble();
            }
            return l2;
        }

        @Override
        public DoubleBigList subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0L || to != 1L) {
                return EMPTY_BIG_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, DoubleBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 1L;
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyBigList
    extends DoubleCollections.EmptyCollection
    implements DoubleBigList,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyBigList() {
        }

        @Override
        public double getDouble(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean rem(double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double removeDouble(long i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(long index, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double set(long index, double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long indexOf(double k2) {
            return -1L;
        }

        @Override
        public long lastIndexOf(double k2) {
            return -1L;
        }

        @Override
        public boolean addAll(long i2, Collection<? extends Double> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(DoubleBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, DoubleCollection c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(long i2, DoubleBigList c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public void add(long index, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean add(Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double get(long i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public Double set(long index, Double k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove(long k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public long indexOf(Object k2) {
            return -1L;
        }

        @Override
        @Deprecated
        public long lastIndexOf(Object k2) {
            return -1L;
        }

        @Override
        public DoubleBigListIterator listIterator() {
            return DoubleBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public DoubleBigListIterator iterator() {
            return DoubleBigListIterators.EMPTY_BIG_LIST_ITERATOR;
        }

        @Override
        public DoubleBigListIterator listIterator(long i2) {
            if (i2 == 0L) {
                return DoubleBigListIterators.EMPTY_BIG_LIST_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        public DoubleBigList subList(long from, long to) {
            if (from == 0L && to == 0L) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void getElements(long from, double[][] a2, long offset, long length) {
            DoubleBigArrays.ensureOffsetLength(a2, offset, length);
            if (from != 0L) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public void removeElements(long from, long to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, double[][] a2, long offset, long length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(long index, double[][] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(long s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size64() {
            return 0L;
        }

        @Override
        public int compareTo(BigList<? extends Double> o2) {
            if (o2 == this) {
                return 0;
            }
            return o2.isEmpty() ? 0 : -1;
        }

        public Object clone() {
            return EMPTY_BIG_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof BigList && ((BigList)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_BIG_LIST;
        }
    }
}

