/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.BigListIterator;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceBigList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractReferenceBigList<K>
extends AbstractReferenceCollection<K>
implements ReferenceBigList<K>,
Stack<K> {
    protected AbstractReferenceBigList() {
    }

    protected void ensureIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size64() + ")");
        }
    }

    protected void ensureRestrictedIndex(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size64()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size64() + ")");
        }
    }

    @Override
    public void add(long index, K k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(K k2) {
        this.add(this.size64(), k2);
        return true;
    }

    @Override
    public K remove(long i2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public K remove(int i2) {
        return this.remove((long)i2);
    }

    @Override
    public K set(long index, K k2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public K set(int index, K k2) {
        return this.set((long)index, k2);
    }

    @Override
    public boolean addAll(long index, Collection<? extends K> c2) {
        this.ensureIndex(index);
        Iterator<K> i2 = c2.iterator();
        boolean retVal = i2.hasNext();
        while (i2.hasNext()) {
            this.add(index++, i2.next());
        }
        return retVal;
    }

    @Deprecated
    public boolean addAll(int index, Collection<? extends K> c2) {
        return this.addAll((long)index, c2);
    }

    @Override
    public boolean addAll(Collection<? extends K> c2) {
        return this.addAll(this.size64(), c2);
    }

    @Override
    public ObjectBigListIterator<K> iterator() {
        return this.listIterator();
    }

    @Override
    public ObjectBigListIterator<K> listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public ObjectBigListIterator<K> listIterator(final long index) {
        this.ensureIndex(index);
        return new AbstractObjectBigListIterator<K>(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractReferenceBigList.this.size64();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractReferenceBigList.this.get(this.last);
            }

            @Override
            public K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractReferenceBigList.this.get(this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(K k2) {
                AbstractReferenceBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(K k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractReferenceBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                AbstractReferenceBigList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    @Deprecated
    public ObjectBigListIterator<K> listIterator(int index) {
        return this.listIterator((long)index);
    }

    @Override
    public boolean contains(Object k2) {
        return this.indexOf(k2) >= 0L;
    }

    @Override
    public long indexOf(Object k2) {
        BigListIterator i2 = this.listIterator();
        while (i2.hasNext()) {
            Object e2 = i2.next();
            if (k2 != e2) continue;
            return i2.previousIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object k2) {
        BigListIterator i2 = this.listIterator(this.size64());
        while (i2.hasPrevious()) {
            Object e2 = i2.previous();
            if (k2 != e2) continue;
            return i2.nextIndex();
        }
        return -1L;
    }

    @Override
    public void size(long size) {
        long i2 = this.size64();
        if (size > i2) {
            while (i2++ < size) {
                this.add((K)null);
            }
        } else {
            while (i2-- != size) {
                this.remove(i2);
            }
        }
    }

    @Deprecated
    public void size(int size) {
        this.size((long)size);
    }

    @Override
    public ReferenceBigList<K> subList(long from, long to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ReferenceSubList(this, from, to);
    }

    @Override
    public void removeElements(long from, long to) {
        this.ensureIndex(to);
        BigListIterator i2 = this.listIterator(from);
        long n2 = to - from;
        if (n2 < 0L) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n2-- != 0L) {
            i2.next();
            i2.remove();
        }
    }

    @Override
    public void addElements(long index, K[][] a2, long offset, long length) {
        this.ensureIndex(index);
        ObjectBigArrays.ensureOffsetLength(a2, offset, length);
        while (length-- != 0L) {
            this.add(index++, ObjectBigArrays.get(a2, offset++));
        }
    }

    @Override
    public void addElements(long index, K[][] a2) {
        this.addElements(index, a2, 0L, ObjectBigArrays.length(a2));
    }

    @Override
    public void getElements(long from, Object[][] a2, long offset, long length) {
        BigListIterator i2 = this.listIterator(from);
        ObjectBigArrays.ensureOffsetLength(a2, offset, length);
        if (from + length > this.size64()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size64() + ")");
        }
        while (length-- != 0L) {
            ObjectBigArrays.set(a2, offset++, i2.next());
        }
    }

    @Override
    public void clear() {
        this.removeElements(0L, this.size64());
    }

    @Override
    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size64());
    }

    @Override
    public int hashCode() {
        ObjectIterator i2 = this.iterator();
        int h2 = 1;
        long s2 = this.size64();
        while (s2-- != 0L) {
            Object k2 = i2.next();
            h2 = 31 * h2 + System.identityHashCode(k2);
        }
        return h2;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BigList)) {
            return false;
        }
        BigList l2 = (BigList)o2;
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        BigListIterator i1 = this.listIterator();
        BigListIterator i2 = l2.listIterator();
        while (s2-- != 0L) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void push(K o2) {
        this.add(o2);
    }

    @Override
    public K pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.size64() - 1L);
    }

    @Override
    public K top() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size64() - 1L);
    }

    @Override
    public K peek(int i2) {
        return this.get(this.size64() - 1L - (long)i2);
    }

    @Deprecated
    public K get(int index) {
        return this.get((long)index);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i2 = this.iterator();
        long n2 = this.size64();
        boolean first = true;
        s2.append("[");
        while (n2-- != 0L) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object k2 = i2.next();
            if (this == k2) {
                s2.append("(this big list)");
                continue;
            }
            s2.append(String.valueOf(k2));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class ReferenceSubList<K>
    extends AbstractReferenceBigList<K>
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceBigList<K> l;
        protected final long from;
        protected long to;

        public ReferenceSubList(ReferenceBigList<K> l2, long from, long to) {
            this.l = l2;
            this.from = from;
            this.to = to;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size64());
            assert (this.to <= this.l.size64());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(K k2) {
            this.l.add(this.to, k2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(long index, K k2) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(long index, Collection<? extends K> c2) {
            this.ensureIndex(index);
            this.to += (long)c2.size();
            return this.l.addAll(this.from + index, c2);
        }

        @Override
        public K get(long index) {
            this.ensureRestrictedIndex(index);
            return this.l.get(this.from + index);
        }

        @Override
        public K remove(long index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.remove(this.from + index);
        }

        @Override
        public K set(long index, K k2) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k2);
        }

        @Override
        public long size64() {
            return this.to - this.from;
        }

        @Override
        public void getElements(long from, Object[][] a2, long offset, long length) {
            this.ensureIndex(from);
            if (from + length > this.size64()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size64() + ")");
            }
            this.l.getElements(this.from + from, a2, offset, length);
        }

        @Override
        public void removeElements(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
            assert (this.assertRange());
        }

        @Override
        public void addElements(long index, K[][] a2, long offset, long length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a2, offset, length);
            this.to += length;
            assert (this.assertRange());
        }

        @Override
        public ObjectBigListIterator<K> listIterator(final long index) {
            this.ensureIndex(index);
            return new AbstractObjectBigListIterator<K>(){
                long pos;
                long last;
                {
                    this.pos = index;
                    this.last = -1L;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < ReferenceSubList.this.size64();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0L;
                }

                @Override
                public K next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return ReferenceSubList.this.l.get(ReferenceSubList.this.from + this.last);
                }

                @Override
                public K previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return ReferenceSubList.this.l.get(ReferenceSubList.this.from + this.pos);
                }

                @Override
                public long nextIndex() {
                    return this.pos;
                }

                @Override
                public long previousIndex() {
                    return this.pos - 1L;
                }

                @Override
                public void add(K k2) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    ReferenceSubList.this.add(this.pos++, k2);
                    this.last = -1L;
                    assert (ReferenceSubList.this.assertRange());
                }

                @Override
                public void set(K k2) {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    ReferenceSubList.this.set(this.last, k2);
                }

                @Override
                public void remove() {
                    if (this.last == -1L) {
                        throw new IllegalStateException();
                    }
                    ReferenceSubList.this.remove(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1L;
                    assert (ReferenceSubList.this.assertRange());
                }
            };
        }

        @Override
        public ReferenceBigList<K> subList(long from, long to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new ReferenceSubList<K>(this, from, to);
        }
    }
}

