/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigList;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ObjectBigArrayBigList<K>
extends AbstractObjectBigList<K>
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353131L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected final boolean wrapped;
    protected transient K[][] a;
    protected long size;
    private static final boolean ASSERTS = false;

    protected ObjectBigArrayBigList(K[][] a2, boolean dummy) {
        this.a = a2;
        this.wrapped = true;
    }

    public ObjectBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = ObjectBigArrays.newBigArray(capacity);
        this.wrapped = false;
    }

    public ObjectBigArrayBigList() {
        this(16L);
    }

    public ObjectBigArrayBigList(ObjectCollection<? extends K> c2) {
        this(c2.size());
        ObjectIterator<K> i2 = c2.iterator();
        while (i2.hasNext()) {
            this.add((K)i2.next());
        }
    }

    public ObjectBigArrayBigList(ObjectBigList<? extends K> l2) {
        this(l2.size64());
        this.size = l2.size64();
        l2.getElements(0L, this.a, 0L, this.size);
    }

    public ObjectBigArrayBigList(K[][] a2) {
        this(a2, 0L, ObjectBigArrays.length(a2));
    }

    public ObjectBigArrayBigList(K[][] a2, long offset, long length) {
        this(length);
        ObjectBigArrays.copy(a2, offset, this.a, 0L, length);
        this.size = length;
    }

    public ObjectBigArrayBigList(Iterator<? extends K> i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public ObjectBigArrayBigList(ObjectIterator<? extends K> i2) {
        this();
        while (i2.hasNext()) {
            this.add((K)i2.next());
        }
    }

    public K[][] elements() {
        return this.a;
    }

    public static <K> ObjectBigArrayBigList<K> wrap(K[][] a2, long length) {
        if (length > ObjectBigArrays.length(a2)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + ObjectBigArrays.length(a2) + ")");
        }
        ObjectBigArrayBigList<K> l2 = new ObjectBigArrayBigList<K>(a2, false);
        l2.size = length;
        return l2;
    }

    public static <K> ObjectBigArrayBigList<K> wrap(K[][] a2) {
        return ObjectBigArrayBigList.wrap(a2, ObjectBigArrays.length(a2));
    }

    public void ensureCapacity(long capacity) {
        if (this.wrapped) {
            this.a = ObjectBigArrays.ensureCapacity(this.a, capacity, this.size);
        } else if (capacity > ObjectBigArrays.length(this.a)) {
            Object[][] t2 = ObjectBigArrays.newBigArray(capacity);
            ObjectBigArrays.copy(this.a, 0L, t2, 0L, this.size);
            this.a = t2;
        }
    }

    private void grow(long capacity) {
        if (this.wrapped) {
            this.a = ObjectBigArrays.grow(this.a, capacity, this.size);
        } else if (capacity > ObjectBigArrays.length(this.a)) {
            int newLength = (int)Math.max(Math.min(2L * ObjectBigArrays.length(this.a), 0x7FFFFFF7L), capacity);
            Object[][] t2 = ObjectBigArrays.newBigArray(newLength);
            ObjectBigArrays.copy(this.a, 0L, t2, 0L, this.size);
            this.a = t2;
        }
    }

    @Override
    public void add(long index, K k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            ObjectBigArrays.copy(this.a, index, this.a, index + 1L, this.size - index);
        }
        ObjectBigArrays.set(this.a, index, k2);
        ++this.size;
    }

    @Override
    public boolean add(K k2) {
        this.grow(this.size + 1L);
        ObjectBigArrays.set(this.a, this.size++, k2);
        return true;
    }

    @Override
    public K get(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return ObjectBigArrays.get(this.a, index);
    }

    @Override
    public long indexOf(Object k2) {
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (!(k2 == null ? ObjectBigArrays.get(this.a, i2) == null : k2.equals(ObjectBigArrays.get(this.a, i2)))) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object k2) {
        long i2 = this.size;
        while (i2-- != 0L) {
            if (!(k2 == null ? ObjectBigArrays.get(this.a, i2) == null : k2.equals(ObjectBigArrays.get(this.a, i2)))) continue;
            return i2;
        }
        return -1L;
    }

    @Override
    public K remove(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        K old = ObjectBigArrays.get(this.a, index);
        --this.size;
        if (index != this.size) {
            ObjectBigArrays.copy(this.a, index + 1L, this.a, index, this.size - index);
        }
        ObjectBigArrays.set(this.a, this.size, null);
        return old;
    }

    @Override
    public boolean remove(Object k2) {
        long index = this.indexOf(k2);
        if (index == -1L) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public K set(long index, K k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        K old = ObjectBigArrays.get(this.a, index);
        ObjectBigArrays.set(this.a, index, k2);
        return old;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        K[] s2 = null;
        K[] d2 = null;
        int ss2 = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i2 = 0L; i2 < this.size; ++i2) {
            if (sd == 0x8000000) {
                sd = 0;
                s2 = this.a[++ss2];
            }
            if (!c2.contains(s2[sd])) {
                if (dd == 0x8000000) {
                    d2 = this.a[++ds];
                    dd = 0;
                }
                d2[dd++] = s2[sd];
            }
            ++sd;
        }
        long j2 = BigArrays.index(ds, dd);
        ObjectBigArrays.fill(this.a, j2, this.size, null);
        boolean modified = this.size != j2;
        this.size = j2;
        return modified;
    }

    @Override
    public void clear() {
        ObjectBigArrays.fill(this.a, 0L, this.size, null);
        this.size = 0L;
    }

    @Override
    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > ObjectBigArrays.length(this.a)) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            ObjectBigArrays.fill(this.a, this.size, size, null);
        } else {
            ObjectBigArrays.fill(this.a, size, this.size, null);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n2) {
        long arrayLength = ObjectBigArrays.length(this.a);
        if (n2 >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = ObjectBigArrays.trim(this.a, Math.max(n2, this.size));
    }

    @Override
    public void getElements(long from, Object[][] a2, long offset, long length) {
        ObjectBigArrays.copy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo(this.size, from, to);
        ObjectBigArrays.copy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
        ObjectBigArrays.fill(this.a, this.size, this.size + to - from, null);
    }

    @Override
    public void addElements(long index, K[][] a2, long offset, long length) {
        this.ensureIndex(index);
        ObjectBigArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        ObjectBigArrays.copy(this.a, index, this.a, index + length, this.size - index);
        ObjectBigArrays.copy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public ObjectBigListIterator<K> listIterator(final long index) {
        this.ensureIndex(index);
        return new AbstractObjectBigListIterator<K>(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ObjectBigArrayBigList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ObjectBigArrays.get(ObjectBigArrayBigList.this.a, this.last);
            }

            @Override
            public K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ObjectBigArrays.get(ObjectBigArrayBigList.this.a, this.pos);
            }

            @Override
            public long nextIndex() {
                return this.pos;
            }

            @Override
            public long previousIndex() {
                return this.pos - 1L;
            }

            @Override
            public void add(K k2) {
                ObjectBigArrayBigList.this.add(this.pos++, k2);
                this.last = -1L;
            }

            @Override
            public void set(K k2) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                ObjectBigArrayBigList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                ObjectBigArrayBigList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }
        };
    }

    public ObjectBigArrayBigList<K> clone() {
        ObjectBigArrayBigList<K> c2 = new ObjectBigArrayBigList<K>(this.size);
        ObjectBigArrays.copy(this.a, 0L, c2.a, 0L, this.size);
        c2.size = this.size;
        return c2;
    }

    private boolean valEquals(K a2, K b2) {
        return a2 == null ? b2 == null : a2.equals(b2);
    }

    public boolean equals(ObjectBigArrayBigList<K> l2) {
        if (l2 == this) {
            return true;
        }
        long s2 = this.size64();
        if (s2 != l2.size64()) {
            return false;
        }
        K[][] a1 = this.a;
        K[][] a2 = l2.a;
        while (s2-- != 0L) {
            if (this.valEquals(ObjectBigArrays.get(a1, s2), ObjectBigArrays.get(a2, s2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ObjectBigArrayBigList<? extends K> l2) {
        long s1 = this.size64();
        long s2 = l2.size64();
        K[][] a1 = this.a;
        K[][] a2 = l2.a;
        int i2 = 0;
        while ((long)i2 < s1 && (long)i2 < s2) {
            K e2;
            K e1 = ObjectBigArrays.get(a1, i2);
            int r2 = ((Comparable)e1).compareTo(e2 = ObjectBigArrays.get(a2, i2));
            if (r2 != 0) {
                return r2;
            }
            ++i2;
        }
        return (long)i2 < s2 ? -1 : ((long)i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        int i2 = 0;
        while ((long)i2 < this.size) {
            s2.writeObject(ObjectBigArrays.get(this.a, i2));
            ++i2;
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = ObjectBigArrays.newBigArray(this.size);
        int i2 = 0;
        while ((long)i2 < this.size) {
            ObjectBigArrays.set(this.a, i2, s2.readObject());
            ++i2;
        }
    }
}

