/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.util.Comparator;

public class ObjectComparators {
    public static final Comparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final Comparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private ObjectComparators() {
    }

    public static <K> Comparator<K> oppositeComparator(Comparator<K> c2) {
        return new OppositeComparator<K>(c2);
    }

    protected static class OppositeComparator<K>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Comparator<K> comparator;

        protected OppositeComparator(Comparator<K> c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(K a2, K b2) {
            return this.comparator.compare(b2, a2);
        }
    }

    protected static class OppositeImplicitComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        public final int compare(Object a2, Object b2) {
            return ((Comparable)b2).compareTo(a2);
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class NaturalImplicitComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        public final int compare(Object a2, Object b2) {
            return ((Comparable)a2).compareTo(b2);
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }
}

