/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.AbstractReferenceList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollections;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;

public class ReferenceLists {
    public static final EmptyList EMPTY_LIST = new EmptyList();

    private ReferenceLists() {
    }

    public static <K> ReferenceList<K> shuffle(ReferenceList<K> l2, Random random) {
        int i2 = l2.size();
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            Object t2 = l2.get(i2);
            l2.set(i2, l2.get(p2));
            l2.set(p2, t2);
        }
        return l2;
    }

    public static <K> ReferenceList<K> emptyList() {
        return EMPTY_LIST;
    }

    public static <K> ReferenceList<K> singleton(K element) {
        return new Singleton(element);
    }

    public static <K> ReferenceList<K> synchronize(ReferenceList<K> l2) {
        return l2 instanceof RandomAccess ? new SynchronizedRandomAccessList<K>(l2) : new SynchronizedList<K>(l2);
    }

    public static <K> ReferenceList<K> synchronize(ReferenceList<K> l2, Object sync) {
        return l2 instanceof RandomAccess ? new SynchronizedRandomAccessList<K>(l2, sync) : new SynchronizedList<K>(l2, sync);
    }

    public static <K> ReferenceList<K> unmodifiable(ReferenceList<K> l2) {
        return l2 instanceof RandomAccess ? new UnmodifiableRandomAccessList<K>(l2) : new UnmodifiableList<K>(l2);
    }

    public static class UnmodifiableRandomAccessList<K>
    extends UnmodifiableList<K>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected UnmodifiableRandomAccessList(ReferenceList<K> l2) {
            super(l2);
        }

        @Override
        public ReferenceList<K> subList(int from, int to) {
            return new UnmodifiableRandomAccessList(this.list.subList(from, to));
        }
    }

    public static class UnmodifiableList<K>
    extends ReferenceCollections.UnmodifiableCollection<K>
    implements ReferenceList<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceList<K> list;

        protected UnmodifiableList(ReferenceList<K> l2) {
            super(l2);
            this.list = l2;
        }

        @Override
        public K get(int i2) {
            return (K)this.list.get(i2);
        }

        @Override
        public K set(int i2, K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int i2, K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object k2) {
            return this.list.indexOf(k2);
        }

        @Override
        public int lastIndexOf(Object k2) {
            return this.list.lastIndexOf(k2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void getElements(int from, Object[] a2, int offset, int length) {
            this.list.getElements(from, a2, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, K[] a2, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, K[] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(int size) {
            this.list.size(size);
        }

        @Override
        public ObjectListIterator<K> listIterator() {
            return ObjectIterators.unmodifiable(this.list.listIterator());
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return this.listIterator();
        }

        @Override
        public ObjectListIterator<K> listIterator(int i2) {
            return ObjectIterators.unmodifiable(this.list.listIterator(i2));
        }

        @Override
        @Deprecated
        public ObjectListIterator<K> objectListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public ObjectListIterator<K> objectListIterator(int i2) {
            return this.listIterator(i2);
        }

        @Override
        public ReferenceList<K> subList(int from, int to) {
            return new UnmodifiableList<K>(this.list.subList(from, to));
        }

        @Override
        @Deprecated
        public ReferenceList<K> referenceSubList(int from, int to) {
            return this.subList(from, to);
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return this.collection.equals(o2);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }
    }

    public static class SynchronizedRandomAccessList<K>
    extends SynchronizedList<K>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected SynchronizedRandomAccessList(ReferenceList<K> l2, Object sync) {
            super(l2, sync);
        }

        protected SynchronizedRandomAccessList(ReferenceList<K> l2) {
            super(l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReferenceList<K> subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(from, to), this.sync);
            }
        }
    }

    public static class SynchronizedList<K>
    extends ReferenceCollections.SynchronizedCollection<K>
    implements ReferenceList<K>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceList<K> list;

        protected SynchronizedList(ReferenceList<K> l2, Object sync) {
            super(l2, sync);
            this.list = l2;
        }

        protected SynchronizedList(ReferenceList<K> l2) {
            super(l2);
            this.list = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K get(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return (K)this.list.get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K set(int i2, K k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int i2, K k2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i2, k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K remove(int i2) {
            Object object = this.sync;
            synchronized (object) {
                return (K)this.list.remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object k2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends K> c2) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getElements(int from, Object[] a2, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int index, K[] a2, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int index, K[] a2) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        @Override
        public ObjectListIterator<K> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return this.listIterator();
        }

        @Override
        public ObjectListIterator<K> listIterator(int i2) {
            return this.list.listIterator(i2);
        }

        @Override
        @Deprecated
        public ObjectListIterator<K> objectListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public ObjectListIterator<K> objectListIterator(int i2) {
            return this.listIterator(i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReferenceList<K> subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList<K>(this.list.subList(from, to), this.sync);
            }
        }

        @Override
        @Deprecated
        public ReferenceList<K> referenceSubList(int from, int to) {
            return this.subList(from, to);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s2) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s2.defaultWriteObject();
            }
        }
    }

    public static class Singleton<K>
    extends AbstractReferenceList<K>
    implements RandomAccess,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        private final K element;

        private Singleton(K element) {
            this.element = element;
        }

        @Override
        public K get(int i2) {
            if (i2 == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean remove(Object k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object k2) {
            return k2 == this.element;
        }

        @Override
        public Object[] toArray() {
            Object[] a2 = new Object[]{this.element};
            return a2;
        }

        @Override
        public ObjectListIterator<K> listIterator() {
            return ObjectIterators.singleton(this.element);
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return this.listIterator();
        }

        @Override
        public ObjectListIterator<K> listIterator(int i2) {
            if (i2 > 1 || i2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            ListIterator l2 = this.listIterator();
            if (i2 == 1) {
                l2.next();
            }
            return l2;
        }

        @Override
        public ReferenceList<K> subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return EMPTY_LIST;
            }
            return this;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }

    public static class EmptyList<K>
    extends ReferenceCollections.EmptyCollection<K>
    implements ReferenceList<K>,
    RandomAccess,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyList() {
        }

        @Override
        public K get(int i2) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean remove(Object k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K remove(int i2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K set(int index, K k2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object k2) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object k2) {
            return -1;
        }

        @Override
        public boolean addAll(int i2, Collection<? extends K> c2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectListIterator<K> listIterator() {
            return ObjectIterators.EMPTY_ITERATOR;
        }

        @Override
        public ObjectListIterator<K> iterator() {
            return ObjectIterators.EMPTY_ITERATOR;
        }

        @Override
        public ObjectListIterator<K> listIterator(int i2) {
            if (i2 == 0) {
                return ObjectIterators.EMPTY_ITERATOR;
            }
            throw new IndexOutOfBoundsException(String.valueOf(i2));
        }

        @Override
        @Deprecated
        public ObjectListIterator<K> objectListIterator() {
            return this.listIterator();
        }

        @Override
        @Deprecated
        public ObjectListIterator<K> objectListIterator(int i2) {
            return this.listIterator(i2);
        }

        @Override
        public ReferenceList<K> subList(int from, int to) {
            if (from == 0 && to == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        @Deprecated
        public ReferenceList<K> referenceSubList(int from, int to) {
            return this.subList(from, to);
        }

        @Override
        public void getElements(int from, Object[] a2, int offset, int length) {
            if (from == 0 && length == 0 && offset >= 0 && offset <= a2.length) {
                return;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, K[] a2, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int index, K[] a2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void size(int s2) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_LIST;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o2) {
            return o2 instanceof List && ((List)o2).isEmpty();
        }

        @Override
        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }
}

