/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import shadersmodcore.transform.SMCRenamerMethodAdaptor;

public class SMCRemap {
    private static boolean deobfuscatedEnv = false;
    public static Map<String, String> mapSrgToMcp = null;
    public static Map<String, String> mapMcpToSrg = null;
    public static Remapper remapper;
    public static Remapper remapperW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCSV(String fileName, Map<String, String[]> map) {
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(fileName));
            rd.readLine();
            while ((line = rd.readLine()) != null) {
                String[] tokens = line.split(",");
                if (tokens.length <= 1) continue;
                map.put(tokens[0], tokens);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String getNamePart(String fullName) {
        int i = fullName.lastIndexOf(47);
        if (i >= 0) {
            return fullName.substring(i + 1);
        }
        return fullName;
    }

    private static String getParent(String fullName) {
        int i = fullName.lastIndexOf(47);
        if (i >= 0) {
            return fullName.substring(0, i);
        }
        return "";
    }

    private static String getDesc(String desc, Map<String, String[]> mapC) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < desc.length()) {
            int p = desc.indexOf(76, i);
            if (p != -1) {
                int q = desc.indexOf(59, p + 1);
                if (q != -1) {
                    s.append(desc, i, p);
                    s.append('L');
                    s.append(SMCRemap.getClassPack(desc.substring(p + 1, q), mapC));
                    s.append(';');
                    i = q + 1;
                    continue;
                }
                return desc;
            }
            s.append(desc, i, desc.length());
            i = desc.length();
        }
        return s.toString();
    }

    private static String getClassPack(String fullName, Map<String, String[]> mapC) {
        String[] packrecord;
        String name = SMCRemap.getNamePart(fullName);
        String pack = SMCRemap.getParent(fullName);
        if (pack.equals("net/minecraft/src") && (packrecord = mapC.get(name)) != null && packrecord.length >= 2) {
            pack = packrecord[1];
        }
        return pack + "/" + name;
    }

    private static String stringForPrint(String s) {
        return s != null ? s : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseSrg(String inFileName, Map<String, String[]> mapC, Map<String, String[]> mapF, Map<String, String[]> mapM) {
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(inFileName));
            while ((line = rd.readLine()) != null) {
                String[] tokens = Arrays.copyOf(line.split(" "), 10);
                String[] data = null;
                if (tokens[0].equals("CL:")) {
                    tokens[6] = SMCRemap.getClassPack(tokens[2], mapC);
                }
                if (tokens[0].equals("FD:")) {
                    tokens[6] = SMCRemap.getClassPack(SMCRemap.getParent(tokens[2]), mapC);
                    tokens[7] = SMCRemap.getNamePart(tokens[2]);
                    tokens[8] = tokens[7];
                    data = mapF.get(tokens[7]);
                    if (data == null || data.length < 2) continue;
                    tokens[8] = data[1];
                    mapSrgToMcp.put(tokens[6] + "." + tokens[7], tokens[8]);
                    mapMcpToSrg.put(tokens[6] + "." + tokens[8], tokens[7]);
                    continue;
                }
                if (!tokens[0].equals("MD:")) continue;
                tokens[6] = SMCRemap.getClassPack(SMCRemap.getParent(tokens[3]), mapC);
                tokens[7] = SMCRemap.getNamePart(tokens[3]);
                tokens[8] = tokens[7];
                tokens[9] = SMCRemap.getDesc(tokens[4], mapC);
                data = mapM.get(SMCRemap.getNamePart(tokens[3]));
                if (data == null || data.length < 2) continue;
                tokens[8] = data[1];
                mapSrgToMcp.put(tokens[6] + "." + tokens[7] + tokens[9], tokens[8]);
                mapMcpToSrg.put(tokens[6] + "." + tokens[8] + tokens[9], tokens[7]);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addClassMap(String srcName, String srgName) {
        mapMcpToSrg.put(srcName, srgName);
        mapSrgToMcp.put(srgName, srcName);
    }

    public static void addInheritedMethod(String owner, String base, String name, String desc) {
        String srcName = mapSrgToMcp.get(base + "." + name + desc);
        mapMcpToSrg.put(owner + "." + srcName + desc, name);
        mapSrgToMcp.put(owner + "." + name + desc, srcName);
    }

    public static void addInheritedField(String owner, String base, String name) {
        String srcName = mapSrgToMcp.get(base + "." + name);
        mapMcpToSrg.put(owner + "." + srcName, name);
        mapSrgToMcp.put(owner + "." + name, srcName);
    }

    public static void initMap() {
        if (mapMcpToSrg == null) {
            mapMcpToSrg = new HashMap<String, String>();
            mapSrgToMcp = new HashMap<String, String>();
            HashMap<String, String[]> mapC = new HashMap<String, String[]>();
            HashMap<String, String[]> mapF = new HashMap<String, String[]>();
            HashMap<String, String[]> mapM = new HashMap<String, String[]>();
            SMCRemap.readCSV("..\\conf\\packages.csv", mapC);
            SMCRemap.readCSV("..\\conf\\fields.csv", mapF);
            SMCRemap.readCSV("..\\conf\\methods.csv", mapM);
            SMCRemap.parseSrg("..\\conf\\joined.srg", mapC, mapF, mapM);
            SMCRemap.addClassMap("net/minecraft/src/Config", "Config");
            SMCRemap.addClassMap("net/minecraft/src/CustomColorizer", "CustomColorizer");
            SMCRemap.addInheritedMethod("net/minecraft/client/multiplayer/WorldClient", "net/minecraft/world/World", "func_72867_j", "(F)F");
            SMCRemap.addInheritedMethod("net/minecraft/client/multiplayer/WorldClient", "net/minecraft/world/World", "func_72826_c", "(F)F");
            SMCRemap.addInheritedMethod("net/minecraft/entity/EntityLivingBase", "net/minecraft/entity/Entity", "func_70013_c", "(F)F");
            SMCRemap.addInheritedField("net/minecraft/client/gui/GuiOptions", "net/minecraft/client/gui/GuiScreen", "field_73882_e");
            SMCRemap.addInheritedField("net/minecraft/client/gui/GuiOptions", "net/minecraft/client/gui/GuiScreen", "field_73880_f");
            SMCRemap.addInheritedField("net/minecraft/client/gui/GuiOptions", "net/minecraft/client/gui/GuiScreen", "field_73881_g");
            SMCRemap.addInheritedField("net/minecraft/client/gui/GuiOptions", "net/minecraft/client/gui/GuiScreen", "field_73887_h");
        }
    }

    private static void putv(Map map, String key, String value) {
        String oldval = (String)map.get(key);
        if (oldval == null) {
            System.out.format("**** add  %s,%s\n", key, value);
            map.put(key, value);
        } else if (!oldval.equals(value)) {
            System.out.format("**** repl %s,%s %s\n", key, value, oldval);
            map.put(key, value);
        } else {
            System.out.format("**** same %s,%s\n", key, value);
        }
    }

    public static MethodVisitor getAdaptor(MethodVisitor mv) {
        if (!deobfuscatedEnv) {
            return mv;
        }
        return new SMCRenamerMethodAdaptor(mv);
    }

    static {
        Boolean deobEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        boolean bl = deobfuscatedEnv = deobEnv != null && deobEnv != false;
        if (!deobfuscatedEnv) {
            remapperW = remapper = new Remapper(){};
        } else {
            SMCRemap.initMap();
            remapper = new SimpleRemapper(mapMcpToSrg);
            remapperW = new SimpleRemapper(mapSrgToMcp);
        }
    }
}

